# -*- coding: utf8 -*-
from django import template
from django.template import Context
from django.template.loader import get_template

register = template.Library()

@register.simple_tag
def book_link_standard(book):
    ''' Отображает ссылку на книгу в стандартном виде '''
    tpl = get_template('components/book-link-standard.html')
    return tpl.render(Context({'book': book }))

@register.simple_tag
def book_link_with_counter(book, counter=None):
    ''' Отображает ссылку на книгу со счетчиком экземпляров книги '''
    tpl = get_template('components/book-link-counter.html')
    return tpl.render(Context({'book': book, 'counter':counter }))