# -*- coding: utf8 -*-
from django import template
from django.template import Context
from django.template.loader import get_template
from libra.books.rss import feeds

register = template.Library()

@register.simple_tag
def feeds_links():
    ''' Отображает ссылку на сотрудника в стандартном виде '''
    tpl = get_template('feeds/feed-link.html')
    
    result = []
    
    for feed_url, cls in feeds.items():
        feed = {
            'title': cls.title,
            'url': cls.link
        }
        result.append(tpl.render(Context({'feed': feed })))
    
    return ''.join(result)