# coding: utf-8
from django.conf.urls.defaults import *

# Пожалуй, редкий файл, который может не соблюдать PEP8
urlpatterns = patterns('libra.books.views',
    url(r'^$',                              'alphabet_list',               name='list_books'),
    url(r'^books.json$',                    'list_books_json',             name='list_books_json'),
    url(r'^(\d+)/$',                        'view_book',                   name='view_book'),
    url(r'^(\d+)/at-reviews$',              'at_reviews',                  name='at-reviews'),
    url(r'^add/$',                          'add_book',                    name='add_book'),
    url(r'^autofill/$',                     'autofill_book',               name='autofill_book'),
    url(r'^case/$',                         'choose_case',                 name='choose_case'),
    url(r'^add-my/$',                       'add_my_book',                 name='add_my_book'),
    url(r'^(\d+)/edit/$',                   'edit_book',                   name='edit_book'),
    url(r'^lenta/$',                        'view_lenta',                  name='view_lenta'),
    # Скачать электронную версию
    url(r'^download/(\d+)/$',               'download_book',               name='download_book'),
    # ajax/ "Я читал эту книгу", "Сохранить отзыв", "я не читал эту книгу"
    url(r'^(\d+)/iread/$',                  'iread_book',                  name='iread_book'),
    # ajax/ "Эта книга у меня (= я взял эту книгу)"
    url(r'^i-got-book/$',                   'igot_book',                   name='igot_book'),
    # Библиотечная карточка сотрудника (какие книги у него есть, что у него на руках)
    url(r'^user/([aA-zZ0-9\-_\+\.]+)/$',    'user_books',                  name='user_books'),
    # Постоянный урл "Библиотечной карточки сотрудника"
    url(r'^my/$',                           'user_books',                  name='my_books'),
    url(r'^no-cover/$',                     'no_cover',                    name='no_cover'),
    url(r'^set-cover/$',                    'set_cover',                   name='set_cover'),
    url(r'^tags/$',                         'list_tags',                   name='list_tags'),
    url(r'^tag(\d+)/$',                     'list_books_tag',              name='list_books_tag'),
    url(r'^tag0(\d*)/office(0?\d+)/$',      'list_books_office',           name='list_books_office'),
    url(r'removetag/$',                     'remove_tag',                  name='remove_tag'),
    url(r'addtag/$',                        'add_tag',                     name='add_tag'),
    (r'^inventory/',            include('libra.books.urls.inventory_urls')),
    url(r'^(\d+)/items/inventory/',         'get_items_inventory',         name='get_items_inventory'),
    url(r'^to_queue/$',                     'to_queue',                    name='to_queue'),
    url(r'^from_queue/$',                      'from_queue',                   name='del_from_queue'),
)
