# coding: utf8
import time

from django.core.cache import cache
from django.db.models import Q
from django.conf import settings
from django.template.loader import render_to_string
from django.core.urlresolvers import reverse

from libra.books.models import Book
from django_intranet_stuff.models import Staff

import yenv
from ids.exceptions import IDSException
from ids.registry import registry


def alpha_letters():
    ' Формирует список букв для алфавитного указателя книг. Результат запоминается в кэше. Если при обращении к кэшу в нем еще лежит результат, то используется он. '
    first_letters = cache.get('libra_first_letters')

    if not first_letters:
        books_titles = Book.objects.filter(bookitem__is_active=True).values_list('title', flat=True)
        first_letters = list(set([title[0].capitalize() for title in books_titles])) # Выберем первые буквы и оставим только уникальные буквы
        first_letters.sort()

        # удалим из списка цифры от 0 до 9 (они будут в индексе не отдельно, а как группа "0-9")
        has_numerics = False
        for n in xrange(0,9):
            n_char = chr(48+n)
            if n_char in first_letters:
                first_letters.remove(n_char)
                has_numerics = True

        # Если были книги, названия которых начинаются с цифры - добавим индекс "0-9"
        if has_numerics: first_letters.insert(0, '0-9')

        cache.set('libra_first_letters', first_letters, 60)

    return first_letters


def group_books(books):
    ' Групирует список книг по первым буквам. Цифры сводятся в одну группу "0-9". В функции закладываемся на то, что список книг у нас приходит отсортированным. '

    grp = []
    last_letter = None
    temp_group = []
    for book in books:
        title = book.title
        f_letter = title[0].capitalize()

        if f_letter in ['0','1','2','3','4','5','6','7','8','9']:
            f_letter = '0-9'

        if last_letter and last_letter != f_letter:
            grp.append([last_letter, temp_group])
            temp_group = []
            last_letter = f_letter

        temp_group.append(book)
        last_letter = f_letter

    # Добавляем последнюю группу в общий список
    if len(temp_group) > 0:
        grp.append([last_letter, temp_group])

    return grp


# remove typical misprints (LIBRA-375)
def fix_typos(title):
    u"""
    Пытаемся исправить возможные незаметные опечатки в названиях книг
    """
    title = title.replace(u'С++', u'C++')
    title = title.replace(u'С#', u'C#')
    return title


def search_staff(staff_string):
    u""" Пытается по строке содержащей логин или ФИО определить сотрудника (объект Staff)
        Алгоритм:
        1. пробует разделить строку по пробелу, если неудается - скорее всего задан логин
        2. Если удалось разбить строку по пробелу - значит вероятно даны ФИ
        3. Для каждого варианта ищем в своей зоне: либо среди имени и фамилии, либо среди логинов (login и login_ld) и ВикиИмени.
    """
    fl = staff_string.split(' ')
    if len(fl) > 1: # Если содержит пробел, попробуем поискать Имя Фамилия и Фамилия Имя в таблице staff
        search = Q(first_name__iexact=fl[0]) & Q(last_name__iexact=fl[1]) | Q(first_name__iexact=fl[1]) & Q(last_name__iexact=fl[0])
    else: # Если не бьется пробелом, воможно эти вики-имя или логин
        search = Q(wiki_name__iexact=staff_string) | Q(login__iexact=staff_string) | Q(login_ld__iexact=staff_string)

    staff = Staff.objects.filter( search ).get()
    return staff


def get_boss(staff):
    u' Определяет прямого руководителя сотрудника staff '
    def max_boss(dpt):
        u' Возвращает руководителя подразделения, или его заместителя '
        if dpt:
            return dpt.chief or dpt.deputy
        else:
            return None

    mboss = max_boss(staff.department)
    if mboss and mboss != staff: # Если сотрудник сам не руководитель своего подразделения
        return mboss
    else: # если он сам руководитель или руководитель не известен, то смотрим выше
        parent_dpt = staff.department.parent
        if parent_dpt:
            boss = max_boss(parent_dpt)
        else: # выше нас, только президент страны, значит мы Волож или Сегалович :)
            return None
        return boss


def create_atpost(book_item, store_time=None):
    if yenv.type != 'production':
        return

    if store_time is not None:
        store_time = str(store_time)

    post = registry.get_repository('at', 'post',
                                   oauth_token=settings.YARU_ACCESS_TOKEN)
    data = {'uid': settings.AT_CLUB_ID,
            'access': 'public', 'type': 'link',
            'title': book_item.book.title,
            'url': ('https://lib.yandex-team.ru' +
                    reverse('view_book', args=[book_item.book_id])),
            'store_time': store_time,
            'content': render_to_string(
                'feeds/latest-books-description.html',
                {'obj': book_item}),
    }

    try:
        post.create(data)
    except IDSException:
        pass
    except Exception:
        pass
