# coding: utf-8

from django import forms
from django.contrib.auth.decorators import login_required
from django.shortcuts import get_object_or_404, redirect
from django.http import Http404
from django.core.mail import send_mail
from django.conf import settings

from libra.books.models import Book, BookQueue


class QueueForm(forms.Form):
    book_id = forms.IntegerField()


@login_required
def to_queue(request):
    f = QueueForm(request.POST)
    staff = request.user.staff

    if f.is_valid():
        book = get_object_or_404(Book, id=f.cleaned_data['book_id'])
        try:
            # проверим, может быть уже есть такая запись
            BookQueue.objects.get(book=book, user=staff, finished=False)
        except BookQueue.DoesNotExist:
            BookQueue.objects.create(book_id=book.id, user=staff)

            if settings.RETURN_BOOK_MAIL:
                send_mail(u'Вы подписались на книгу "%s"' % book.title,
                          (u'Привет! Как только экземпляр книги "%s" освободится'
                           u' или появится новый в библиотеке, мы сообщим тебе' %
                           book.title),
                          from_email=settings.RETURN_BOOK_FROM,
                          recipient_list=[staff.work_email])

        return redirect('view_book', book.id)

    else:
        raise Http404


@login_required
def from_queue(request):
    f = QueueForm(request.POST)
    staff = request.user.staff

    if f.is_valid():
        book = get_object_or_404(Book, id=f.cleaned_data['book_id'])
        try:
            bq = BookQueue.objects.get(book=book, user=staff, finished=False)
            bq.finished = True
            bq.save()
        except BookQueue.DoesNotExist:
            pass

        return redirect('view_book', book.id)
    else:
        raise Http404
