# coding: utf-8

import urllib2
import json

from django.conf import settings
from django import forms
from django.contrib.auth.decorators import login_required
from django.db.models import Q
from django.shortcuts import render_to_response, redirect
from django.template import RequestContext

from libra.books.models import Book
from libra.books.models import OFFICE_TO_LIBRARY
from libra.books.models import Office
from libra.books.utils import fix_typos
from libra.rfid import Rfid


class FilterCityBookForm(forms.Form):
    office = forms.ModelChoiceField(
        queryset=Office.objects.filter(bookitem__isnull=False).distinct(),
        required=False, label='Офис',
        widget=forms.Select(attrs={'form': 'b-head-search'}))


@login_required(redirect_field_name=settings.REDIRECT_FIELD_NAME)
def common_search(request):
    user = request.user.get_profile()
    text = request.GET.get('text', None)
    text = text.strip()
    only_my_office = request.GET.get('only_my_office', 'off') == 'on'
    misspell = request.GET.get('misspell', 'on') == 'on'

    f = FilterCityBookForm(request.GET)

    lib_staff_office_id = user.office_id

    office_filter = user.office_id if only_my_office else None
    office = Office.objects.get(id=lib_staff_office_id)
    show_office_name = only_my_office

    if f.is_valid():
        if f.cleaned_data['office']:
            office = f.cleaned_data['office']
            office_filter = office.id
            show_office_name = True

    def spell_check(text):
        # LIBRA-375
        text = fix_typos(text)

        # use speller
        url = 'http://speller.yandex.net/services/spellservice.json/checkText?text=' + urllib2.quote(text.encode('utf8'))
        json_string = urllib2.urlopen(url, timeout=3).read()
        misprints = json.loads(json_string)
        new_text = ''

        last_pos = 0
        can_fix = 'nothing'
        for m in misprints:
            s = m['s']
            p = m['pos']
            if s:
                if len(s) == 1:
                    # recoverable error
                    new_text += text[last_pos:p]
                    new_text += s[0]
                    last_pos = p + m['len']
                    if can_fix != 'no':
                        can_fix = 'yes'
                else:
                    can_fix = 'no'
            else:
                can_fix = 'no'

        new_text += text[last_pos:]
        return new_text, can_fix

    can_fix = 'nothing'
    orig_text = text
    if misspell:
        text, can_fix = spell_check(text)

    if lib_staff_office_id in OFFICE_TO_LIBRARY:
        lib_staff_office_id = OFFICE_TO_LIBRARY[lib_staff_office_id]

    if text:
        # проверим, не ищут ли по rfid-номеру?
        rfid_number = Rfid.smart_float2decimal(text)

        # разбиваем запрос по пробелам
        words = text.split()
        query = Q()
        for word in words:
            query = query & (
                Q(title__icontains=word) |
                Q(authors_string__icontains=word) |
                Q(publisher__name__icontains=word)
            )

        if rfid_number:
            # похоже что пользователь ищет по RFID номеру
            query = query | Q(bookitem__rfid=rfid_number)

        if office_filter:
            query = query & Q(bookitem__office_id=office_filter)

        items = Book.objects.filter(query, bookitem__is_active=True).distinct()

        # Если нашли всего 1 книгу, сразу редиректим на карточку книги
        if len(items) == 1:
            return redirect(items[0])

    else:
        items, text = [], ''
    return render_to_response(
        "serp.html",
        {
            'items': items,
            'item_count': len(items),
            'search_text': text,
            'orig_text': orig_text,
            'can_fix': can_fix,
            'show_office_name': show_office_name,
            'misspell': misspell,
            'full_path': request.get_full_path,
            'office': office,
            'only_my_office': only_my_office,
            'filter_form': f,
        },
        context_instance=RequestContext(request)
    )
