# coding: utf-8

from django.db import models
from django_intranet_stuff.models import Staff


class Course(models.Model):
    u' Курс '
    name = models.CharField(max_length=255, null=True, blank=True,
                            verbose_name=u'Имя события')
    date = models.DateField(verbose_name=u'дата проведения')

    def __unicode__(self):
        if not self.name:
            return (u'Мероприятие %s %s' %
                    (self.name, self.date.strftime('%d.%m.%Y')))
        else:
            return self.name

    class Meta:
        verbose_name = u'курс'
        verbose_name_plural = u'курсы'


class Attendance(models.Model):
    u' Посещение курса '
    participant = models.ForeignKey(Staff)
    course = models.ForeignKey(Course)
    datetime = models.DateTimeField(auto_now=True, blank=False)

    def __unicode__(self):
        return u'%s@ на курсе %s' % (self.participant.login, self.course.date.strftime('%d.%m.%Y'))

    @property
    def datetime_str(self):
        return self.datetime.strftime('%d.%m.%Y %H:%M')

    class Meta:
        verbose_name = u'посещение'
        verbose_name_plural = u'посещения'
