# coding: utf-8

import codecs
from datetime import datetime

from django.conf import settings
from django.http import HttpResponse
from django.shortcuts import (render_to_response, render, redirect,
                              get_object_or_404)
from django.template.context import RequestContext
from django_intranet_stuff.models import Staff

from django_replicated.decorators import use_master

from libra.crash_course.models import *
from libra.devices.views import FakeRfid
from libra.rfid import Rfid
from libra.shortcuts import response_json


def index(request, id=None):
    if id:
        evnt = get_object_or_404(Course, id=id)
        tmplt = 'event-register.html'
    else:
        evnt = None
        tmplt = 'base-register.html'

    return render_to_response(tmplt, {
        'today': datetime.now().strftime('%d.%m.%Y'),
        'event': evnt,
    }, context_instance=RequestContext(request))


@use_master
def rfid(request):
    result = {'status': 'ok'}
    rfid_number_hex = Rfid.hex2decimal(request.REQUEST['rfid'])
    event_id = request.REQUEST['event_id'] or None
    if event_id:
        evnt = get_object_or_404(Course, id=event_id)
    else:
        evnt = None

    if rfid_number_hex:
        rfid = Rfid(settings.RFID_PROVIDER_URL, settings.USER_AGENT)
        short_rfid = (int(rfid_number_hex) & 0x7fffffff) % 1000000000
        rfid_found = rfid.resolve(short_rfid)
        if rfid_found:
            if rfid.is_employee():
                try:
                    staff = Staff.objects.get(login=rfid.login)
                    register_participant(request.REQUEST['date'], staff, evnt)
                    result.update({
                        'type': 'person',
                        'login': rfid.login,
                        'active': rfid.is_active(),
                        'rfid': request.REQUEST['rfid'],
                        'name': staff.first_name,
                    })
                except Staff.DoesNotExist:
                    result.update({
                        'status':'error',
                        'message': u'Пользователя %s нет в базе' % rfid.login
                    })
            else:
                result.update({
                    'status':'error',
                    'message': u'Не получилось узнать логин по пропуску'
                })
        else:
            result.update({'status': 'error', 'message': u'Неизвестный объект'})
    else:
        result.update({'status': 'error', 'message': u'RFID неправильно введён'})
    return response_json(result)


def register_participant(date, staff, course=None):
    date = datetime.strptime(date, '%d.%m.%Y').date()
    if course is None:
        try:
            course = Course.objects.get(date=date)
        except Course.DoesNotExist:
            course = Course(name='', date=date)
            course.save()

    if Attendance.objects.filter(course=course, participant=staff).count() == 0:
        attendance = Attendance(course=course, participant=staff)
        attendance.save()


def events(request):
    return render_to_response('crash-course-list.html', {
        'courses': Course.objects.all().order_by('-date')
        }, context_instance=RequestContext(request))


def get_department_name(staff):
    depts = staff.departments
    if len(depts) > 1 and depts[0].code == 'yandex':
        dept = depts[1]
    elif len(depts) > 0:
        dept = depts[0]
    else:
        dept = None
    if dept:
        return dept.name
    return 'Unknown'


def event(request, id):
    c = Course.objects.get(pk=id)
    attendances = c.attendance_set.order_by('participant__last_name')
    for att in attendances:
        att.department = get_department_name(att.participant)
    return render_to_response('crash-course.html', {
        'course': c,
        'attendances': attendances
        }, context_instance=RequestContext(request))


def event_csv(request, id):
    c = Course.objects.get(pk=id)
    csv = u''
    for att in c.attendance_set.order_by('participant__last_name'):
        csv += '%s %s,%s,%s,%s\n' % (att.participant.first_name, att.participant.last_name,
            att.participant.login, get_department_name(att.participant),
            att.datetime.strftime('%d.%m.%Y %H:%M'))
    response = HttpResponse(codecs.BOM_UTF8 + csv.encode('utf-8'), content_type='text/csv; charset=UTF-8')
    response['Content-Disposition'] = 'attachment; filename="course%s.csv"' % c.date.strftime('%d.%m.%Y')
    return response


def new_event(request):
    if request.POST:
        name = request.POST['name']
        new_event = Course.objects.create(name=name, date=datetime.now())
        return redirect(event, new_event.id)
    else:
        return render_to_response('new-event.html', {})
