# coding: utf-8

import urllib2, urllib, math, re
from django.utils import simplejson as json
from django.conf import settings
from libra.rfid import Rfid

class BotException(Exception):
    pass

def fetch(act, params={}):
    params['act'] = act
    url = settings.BOT_URL + '?' + urllib.urlencode(params)
    request = urllib2.Request(url, data = None, headers = {'User-Agent': settings.USER_AGENT})
    doc = urllib2.urlopen(request)
    pass_data = json.loads(doc.read())
    doc.close()
    if pass_data['res'] != 1:
        raise BotException
    return pass_data

def status():
    result = {}
    data = fetch('status')
    for item in data['os']:
        result[item["OsInv"]] = item["Responsible"]
    return result

def give(device_id, login):
    fetch('give', {'login': login, 'inv': device_id})

def take(device_id):
    fetch('take', {'inv': device_id})

    
