# coding: utf-8

import datetime
from django.db import models
from libra.books.models import RfidField
from django_intranet_stuff.models import Staff, Office
from libra.devices.bot import status

# Create your models here.

class Device(models.Model):
    u" Модель устройства "
    manufacturer = models.CharField(max_length=255, verbose_name=u"производитель")
    model = models.CharField(max_length=255, verbose_name=u"модель")
    rfid = RfidField(
        max_length=12, verbose_name=u"Инвентарный номер (rfid)", db_index=True
    )
    office = models.ForeignKey(Office, null=True, default=1)

    @property
    def holder(self):
        if not hasattr(self, '_holder'):
            holders = status()
            if self.rfid in holders:
                self._holder = holders[self.rfid]
            else:
                self._holder = None
        return self._holder

    def move_to_user(self, user):
        u' фиксирует взятие девайса сотрудником '
        if self.holder != None and self.holder != user.login:
            self.log_return(Staff.objects.get(login=self.holder))

        self.log_take(user)
        self.save()

    def log_take(self, user):
        u' Записывает в историю факт взятия девайса '
        now = datetime.datetime.now()
        uh = UseHistory(
            user=user, get_date=now, device=self
        )
        uh.save()

    def log_return(self, user):
        u' Записывает в историю факт возврата девайса '
        now = datetime.datetime.now()
        last_rh = self.usehistory_set.filter(
            return_date=None, user=user
        ).order_by('-id')

        if len(last_rh) == 0:
            rh = UseHistory(
                user=user, return_date=now, device=self
            )
        else:
            rh = last_rh[0]
            rh.return_date = now
        rh.save()

    class Meta:
        verbose_name = u"устройство"
        verbose_name_plural = u"устройства"

    def __unicode__(self):
        return "%s %s" % (self.manufacturer, self.model)


class UseHistory(models.Model):
    u" История использования устройства "
    device = models.ForeignKey(Device)
    user = models.ForeignKey(Staff)
    get_date = models.DateTimeField(
        blank=True, null=True, verbose_name=u'дата взятия'
    )
    return_date = models.DateTimeField(
        blank=True, null=True, verbose_name=u'дата возврата'
    )

    class Meta:
        verbose_name = u"запись об использовании"
        verbose_name_plural = u"записи об использовании"

    def __unicode__(self):
        return "%s by %s" % (self.device, self.user.login)
