# coding: utf-8
from django.shortcuts import render_to_response, render
from django.template.context import RequestContext
from django.conf import settings

from django_intranet_stuff.models import Staff
from libra.shortcuts import response_json
from libra.rfid import Rfid
from libra.devices.models import Device
from libra.devices.bot import take as bot_take, give as bot_give, status as bot_status

class FakeRfid(object):
    def __init__(self, _, __):
        self.active_employee = {'login':'markov', 'active':True, 'employee':True}
        self.inactive_employee = {'login':'sorgoz', 'active':False, 'employee':True}
        self.stranger = {'login':'nol0', 'active':True, 'employee':False}
    def resolve(self, number):
        if number == 9:
            self.obj = self.stranger
            return True
        if number == 8:
            self.obj = self.inactive_employee
            return True
        if number == 7:
            self.obj = self.active_employee
            return True
        return False
    def is_employee(self):
        return self.obj['employee']
    @property
    def login(self):
        return self.obj['login']
    def is_active(self):
        return self.obj['active']
    @classmethod
    def hex2decimal(clazz, string):
        return origRfid.hex2decimal(string)


def index(request, office_id=1):
    devices = Device.objects.filter(office_id=office_id)
    holders = bot_status()
    for device in devices:
        if device.rfid in holders:
            device._holder = holders[device.rfid]
        else:
            device._holder = None
    return render(
        request,
        'devices.html',
        {
            'devices': devices,
            'device_count': len(devices)
        }
    )

def touchscreen(request):
    return render_to_response('touchscreen.html', {}, context_instance=RequestContext(request))

def rfid(request):
    result = {'status': 'ok'}
    try:
        rfid_number = int(request.REQUEST['rfid'])
    except:
        rfid_number = None
    rfid_number_hex = Rfid.hex2decimal(request.REQUEST['rfid'])
    if rfid_number or rfid_number_hex:
        device = None
        if rfid_number:
            try:
                device = Device.objects.get(rfid=rfid_number)
                result.update({
                    'type': 'device',
                    'device': str(device),
                    'rfid': device.rfid,
                })
                if device.holder:
                    result.update({'holder': device.holder})
            except Device.DoesNotExist:
                pass
        if rfid_number_hex and not device:
            rfid = Rfid(settings.RFID_PROVIDER_URL, settings.USER_AGENT)
            short_rfid = (int(rfid_number_hex) & 0x7fffffff) % 1000000000
            rfid_found = rfid.resolve(short_rfid)
            if rfid_found:
                if rfid.is_employee():
                    result.update({
                        'type': 'person',
                        'login': rfid.login,
                        'active': rfid.is_active(),
                        'rfid': request.REQUEST['rfid']
                    })
                else:
                    result.update({
                        'status':'error',
                        'message': u'Не получилось узнать логин по пропуску'
                    })
            else:
                result.update({'status': 'error', 'message': u'Неизвестный объект'})
    else:
        result.update({'status': 'error', 'message': u'RFID неправильно введён'})
    return response_json(result)

def take(request):
    user_rfid = Rfid.hex2decimal(request.REQUEST['user'])
    rfid = Rfid(settings.RFID_PROVIDER_URL, settings.USER_AGENT)
    short_rfid = (int(user_rfid) & 0x7fffffff) % 1000000000
    rfid_found = rfid.resolve(short_rfid)
    device = Device.objects.get(rfid=request.REQUEST['device'])
    if rfid_found and rfid.is_employee() and rfid.is_active():
        try:
            bot_give(device.rfid, rfid.login)
            device.move_to_user(Staff.objects.get(login=rfid.login))
            return response_json({'status': 'ok'})
        except:
            return response_json({'status': 'error'})
    return response_json({'status': 'error'})

def return_(request):
    user_rfid = Rfid.hex2decimal(request.REQUEST['user'])
    rfid = Rfid(settings.RFID_PROVIDER_URL, settings.USER_AGENT)
    short_rfid = (int(user_rfid) & 0x7fffffff) % 1000000000
    rfid_found = rfid.resolve(short_rfid)
    device = Device.objects.get(rfid=request.REQUEST['device'])
    if rfid_found and rfid.is_employee() and rfid.is_active():
        try:
            bot_take(device.rfid)
            device.log_return(Staff.objects.get(login=rfid.login))
            return response_json({'status': 'ok'})
        except:
            return response_json({'status': 'error'})
    return response_json({'status': 'error'})







