#coding: utf-8

"""
    This django-admin command sets special flag 'reload' for all active kiosks to force page refresh
     in kiosks' browsers.
     This action have to be scheduled to run once a day (at night).
"""

from django.core.management.base import BaseCommand

from libra.utils import lock
from libra.kiosks.models import Kiosk


class Command(BaseCommand):
    help = 'Sets flag "force refresh kiosks"'

    @lock('reload_kiosks')
    def handle(self, *args, **options):
        for kiosk in Kiosk.objects.all():
            kiosk.set_force_reload()
