# encoding: utf-8
import datetime
from south.db import db
from south.v2 import DataMigration
from django.db import models

class Migration(DataMigration):

    def forwards(self, orm):
        "Write your forwards methods here."
        try:
            office = orm['users.Office'].objects.get(id=1)
            kiosk = orm.Kiosk(id=1, name=u'Библиотека в Красной Розе', office=office)
            kiosk.save()
        except Exception, e:
            print u'Initial data migration failed: %s' % e.message

    def backwards(self, orm):
        "Write your backwards methods here."
        pass

    models = {
        'kiosks.kiosk': {
            'Meta': {'object_name': 'Kiosk'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'live_date': ('django.db.models.fields.DateField', [], {'auto_now': 'True', 'blank': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'default': "u'Library'", 'max_length': '50'}),
            'office': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['users.Office']"})
        },
        'users.city': {
            'Meta': {'object_name': 'City'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '100'})
        },
        'users.office': {
            'Meta': {'object_name': 'Office'},
            'city': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['users.City']", 'null': 'True'}),
            'from_staff_id': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '255'})
        }
    }

    complete_apps = ['kiosks']
