# coding: utf-8
from django.db import models
from django_intranet_stuff.models import Office

class Kiosk(models.Model):
    u' Библиотечный киоск '
    office = models.ForeignKey(Office)
    name = models.CharField(max_length=50, blank=False, default=u'Library', verbose_name=u'обозначение')
    live_date = models.DateTimeField(auto_now=True, verbose_name=u'Время последнего запроса')
    force_reload = models.BooleanField(verbose_name=u'Перезагрузить киоск', default=False)

    class Meta:
        verbose_name = u'киоск'
        verbose_name_plural = u'киоски'

    def __unicode__(self):
        return u'%s / %s' % (self.name, self.office.name)

    def set_force_reload(self):
        u' Устанавливает флаг принудительного рефреша киоска '
        self.force_reload = True
        self.save()