# coding: utf-8

import urllib2, math, re
from django.utils import simplejson as json
from django.conf import settings


class Rfid:
    u' Представляет результат идентификации пропуска человека по RFID-метке '

    def __init__(self, rfid_provider_url=settings.RFID_PROVIDER_URL,
                 user_agent=settings.USER_AGENT):
        self._RFID_PROVIDER_URL = rfid_provider_url  # Адрес резолвера rfid-номеров в логины
        self._USER_AGENT = user_agent
        self.not_found = False  # признак "не нашли такой ID среди пропусков"
        self.login = None       # логин, соответствующий пропуску (у внешних людей нет логина)
        self.type = None

    def _urlfetch(self, url):
        headers = {'User-Agent': self._USER_AGENT,
                   'Authorization': 'OAuth ' + settings.RFID_ACCESS_TOKEN}
        request = urllib2.Request(self._RFID_PROVIDER_URL + url, data=None,
                                  headers=headers)
        fp = urllib2.urlopen(request)
        pass_data = json.load(fp)
        fp.close()
        return pass_data

    def resolve(self, rfid_number):
        u' попробует узнать логин сотрудника по номеру пропуска '
        resolver_url = 'rfid-api/export/%d/' % rfid_number
        try:
            pass_data = self._urlfetch(resolver_url)
            if 'login' in pass_data:
                self.login = pass_data.get('login', None)
                self.type = pass_data.get('holdertype', None)
                self.status = pass_data.get('status', None)
                return True
            else:
                return None
        except urllib2.HTTPError:
            self.not_found = True
            return None

    def is_active(self):
        u' Признак "пропуск действующий" '
        return self.status == 1

    def is_employee(self):
        u' Признак принадлежности пропуска сотруднику компании '
        return self.type == 'employee'

    def is_other(self):
        u' признак принадлежности пропуска подрядчикам (клининг и т.п.) '
        return self.type != 'employee'

    @staticmethod
    def hex2decimal(n):
        u' Преобразует ID RFID-метки из hex-формата ридера, в идентификатор'
        try:
            n = int(n,16)
        except:
            n = None
        return n

    @staticmethod
    def float2decimal(fl):
        u'Преобразует дробное число на метке в идентификатор считываемый ридером.'
        u' Всегда ожидаем на входе строку(!), содержащую точку или запятую как разделитель '
        fl = fl.replace('.',',')
        d,f = fl.split(',')
        return int(d)*65536 + int(f)

    @staticmethod
    def decimal2float(n):
        u' Преобразует ID RFID-метки из формата ридера, в печатный формат (псевдо float)'
        n = int(n)
        d = int(math.floor(n / 65536))
        f = n - d * 65536
        return '%d,%05d' % (d,f,)

    @staticmethod
    def smart_float2decimal(value):
        u' Умное преобразование human-style/decimal в decimal. Функция сама определяет в каком виде пришли данные, и возвращает decimal'
        if value and len(value)>2:
            if re.match('^\d+$', value):
                return int(value)
            elif re.match(u'^\d+[,.]\d+$', value):  # пишем в m - результат матчинга
                return Rfid.float2decimal(value)
            elif re.match(u'^[0-9abcdef]+$', value, re.I):
                return Rfid.hex2decimal(value)
            else:
                return None
