# -*- coding: utf-8 -*-
from django.conf.urls.defaults import *
from libra import settings

from django.contrib import admin
admin.autodiscover()

from libra.books.rss import LatestAllBooksRSS, LatestCompanyBooksRSS

urlpatterns = patterns('',
    url(r'^$',            'libra.books.views.index_page',     name='index_page'),
    url(r'^search/',      'libra.books.views.common_search',  name='common_search'),
    url(r'^ping/',        'libra.books.views.ping'),
    (r'^books/',          include('libra.books.urls.books_urls')),
    (r'^orders/',         include('libra.books.urls.orders_urls')),
    (r'^publishers/',     include('libra.books.urls.publishers_urls')),
    (r'^case/',           include('libra.books.urls.case_urls')),
    (r'^api/',            include('libra.api.urls')),
    (r'^kiosk/',          include('libra.kiosks.urls')),
    (r'^common/',         include('libra.books.urls.common_urls')),
    (r'^devices/',        include('libra.devices.urls')),
    (r'^crash-course/',    include('libra.crash_course.urls')),
    (r'^admin/',          include(admin.site.urls)),
    (r'^rss/latest-all/', LatestAllBooksRSS()),
    (r'^rss/latest-ya/',  LatestCompanyBooksRSS()),
)

if settings.DEBUG:
    urlpatterns += patterns('',
        (r'media/(?P<path>.*)$', 'django.views.static.serve', {'document_root': settings.MEDIA_ROOT})
    )
