# -*- coding: utf-8 -*-

from libra.users.models import Staff
from django.core.management.base import BaseCommand

class Command(BaseCommand):
    help = 'Outputs minimum user photo and avatar sizes.'
    
    def handle(self, *args, **options):
        avatar = {'width': None, 'height': None}
        photo = {'width': None, 'height': None}
        for s in Staff.objects.all():
            if not s.photo.name:
                continue
            
            try:
                if not avatar['height'] or avatar['height'] > s.avatar.height:
                    avatar['height'] = s.avatar.height
                if not avatar['width'] or avatar['width'] > s.avatar.width:
                    avatar['width'] = s.avatar.width
            except:
                pass
            
            try:
                if not photo['height'] or photo['height'] > s.photo.height:
                    photo['height'] = s.photo.height
                if not photo['width'] or photo['width'] > s.photo.width:
                    photo['width'] = s.photo.width
            except:
                pass
        
        print "Minimum user avatar width=%(width)s, height=%(height)s" % avatar
        print "Minimum user photo width=%(width)s, height=%(height)s" % photo
        