# -*- coding: utf-8 -*-

from django.core.management.base import BaseCommand
from optparse import make_option
from libra.users.plocker import PLocker

class Command(BaseCommand, PLocker):
    help = 'Updates services data.'
    option_list = BaseCommand.option_list
    if '--verbosity' not in [opt.get_opt_string() for opt in BaseCommand.option_list]:
        option_list += make_option('-v', '--verbosity', action='store', dest='verbosity', default='1',
            type='choice', choices=['0', '1', '2'],
            help='Verbosity level; 0=minimal output, 1=normal output, 2=all output; set to 0 for running by cron daemon'),

    def handle(self, *args, **options):
        try:
            verbosity = int(options.get('verbosity', 1))
        except:
            verbosity = 1

        if not self.is_slave() and self.plock('updateservices'):
            import users.service_updater
            users.service_updater.update(verbosity)
    
            if verbosity:
                print 'All done'
            self.punlock()