# -*- coding: utf-8 -*-

from django.core.management.base import BaseCommand
from optparse import make_option
from django.core.management import call_command
from libra.users.plocker import PLocker

class Command(BaseCommand, PLocker):
    help = 'Updates staff data.'
    option_list = BaseCommand.option_list + (
        make_option('--force', dest='force', action='store_true', default=False,
            help='Force update all staff users.'),
    )
    if '--verbosity' not in [opt.get_opt_string() for opt in BaseCommand.option_list]:
        option_list += make_option('-v', '--verbosity', action='store', dest='verbosity', default='0',
            type='choice', choices=['0', '1', '2'],
            help='Verbosity level; 0=minimal output, 1=normal output, 2=all output; set to 0 for running by cron daemon'),

    def handle(self, *args, **options):
        force = options.get('force')
        verbosity = int(options.get('verbosity'))

        if not self.is_slave() and self.plock('updatestaff'):
            import users.updater
            users.updater.update(force)
            if verbosity:
                print 'Update users from staff done'
    
            call_command('updateservices', verbosity=verbosity)
            self.punlock()