# -*- coding:utf-8 -*-
import blackbox, urllib
import logging
from django.contrib.auth.models import User, AnonymousUser
from django.http import HttpResponseRedirect
from django.conf import settings
from libra.users.models import Staff

class LazyUser(object):

    def __init__(self, login=None):
        self.login = login

    def __get__(self, request, obj_type=None):
        if not hasattr(request, '_cached_user'):
            if self.login:
                try:
                    request._cached_user = User.objects.get(username=self.login)
                except User.DoesNotExist:
                    request._cached_user = User.objects.create_user(self.login, '%s@yandex-team.ru' % self.login)
            else:
                request._cached_user = AnonymousUser()
            request._cached_user.__class__._profile_cache = LazyProfile()
            # @todo: remove this legacy some time
            request._cached_user.__class__.profile = LazyProfile()
        return request._cached_user


class LazyProfile(object):
    def __init__(self):
        self.profile = None
    def __get__(self, user, obj_type=None):
        if self.profile == None:
            if user:
                try:
                    self.profile = Staff.objects.get(login_ld=user.username)
                except Staff.DoesNotExist:
                    self.profile = False
                    #    -  
                    logging.warning('LIBRA: Profile for user "%s" not found in Staff model / users.middleware.LazyProfile()' % user.username)
        return self.profile


class PassportAuthMiddleware:

    def process_request(self, request):
        session = None
        if request.COOKIES.get('Session_id', '') and request.COOKIES.get('yandex_login', ''):
            blackbox.BLACKBOX_URL = settings.BLACKBOX_URL
            session =  blackbox.sessionid(
                request.COOKIES.get('Session_id', ''),
                request.META.get('REMOTE_ADDR', ''),
                request.get_host().replace(':'+str(request.META.get('SERVER_PORT', '')), ''),
                dbfields = [getattr(blackbox, x) for x in settings.PASSPORT_FIELDS]
            )

            if session.redirect and request.method == 'GET' and not request.is_ajax():
                return HttpResponseRedirect(settings.SESSION_REFRESH_URL + urllib.quote(request.build_absolute_uri()))

        if session and session.valid:
            request.__class__.user = LazyUser(session.fields['login'])
        else:
            request.__class__.user = LazyUser()

        return None
