# -*- coding: utf-8 -*-

from south.db import db
from libra.users.models import *

class Migration:
    
    def forwards(self):

        # Model 'Office'
        db.create_table('users_office', (
            ('id', models.AutoField(verbose_name='ID', primary_key=True, auto_created=True)),
            ('from_staff_id', models.PositiveIntegerField(db_index=True)),
            ('name', models.CharField(max_length=255)),
        ))

        # Mock Models
        Department = db.mock_model(model_name='Department', db_table='users_department', db_tablespace='', pk_field_name='id', pk_field_type=models.AutoField)

        # Model 'Department'
        db.create_table('users_department', (
            ('id', models.AutoField(verbose_name='ID', primary_key=True, auto_created=True)),
            ('from_staff_id', models.PositiveIntegerField(db_index=True)),
            ('parent', models.ForeignKey(Department, null=True, blank=True, related_name='children')),
            ('name', models.CharField(max_length=255)),
            ('en_name', models.CharField(max_length=255, null=True)),
            ('code', models.CharField(max_length=20, null=True)),
            ('bg_color', models.CharField(max_length=20, null=True)),
            ('fg_color', models.CharField(max_length=20, null=True)),
            ('lft', models.PositiveIntegerField()),
            ('rght', models.PositiveIntegerField()),
            ('tree_id', models.PositiveIntegerField()),
            ('level', models.PositiveIntegerField()),
        ))

        # Mock Models
        Office = db.mock_model(model_name='Office', db_table='users_office', db_tablespace='', pk_field_name='id', pk_field_type=models.AutoField)

        # Model 'Staff'
        db.create_table('users_staff', (
            ('id', models.AutoField(verbose_name='ID', primary_key=True, auto_created=True)),
            ('from_staff_id', models.PositiveIntegerField(db_index=True)),
            ('first_name', models.CharField(max_length=50, null=True, db_index=True)),
            ('middle_name', models.CharField(max_length=50, null=True)),
            ('last_name', models.CharField(max_length=100, null=True, db_index=True)),
            ('en_name', models.CharField(max_length=255, null=True)),
            ('birthday', models.DateField(null=True)),
            ('gender', models.CharField(max_length=1, null=True)),
            ('family_status', models.CharField(max_length=1, null=True)),
            ('children', models.PositiveSmallIntegerField(null=True)),
            ('car', models.CharField(max_length=100, null=True)),
            ('car_num', models.CharField(max_length=50, null=True)),
            ('address', models.CharField(max_length=255, null=True)),
            ('edu_status', models.CharField(max_length=1, null=True)),
            ('edu_place', models.CharField(max_length=255, null=True)),
            ('edu_date', models.DateField(null=True)),
            ('department', models.ForeignKey(Department, null=True)),
            ('is_dismissed', models.BooleanField(default=False)),
            ('office', models.ForeignKey(Office, null=True)),
            ('desk_id', models.PositiveIntegerField(null=True)),
            ('login', models.CharField(max_length=50, db_index=True, null=True)),
            ('login_ld', models.CharField(max_length=50, db_index=True, null=True)),
            ('domain', models.CharField(max_length=1, null=True)),
            ('wiki_name', models.CharField(max_length=100, db_index=True, null=True)),
            ('join_at', models.DateField(null=True)),
            ('quit_at', models.DateField(null=True)),
            ('position', models.CharField(max_length=100, null=True)),
            ('employment', models.CharField(max_length=1, null=True)),
            ('is_big_boss', models.BooleanField(default=False)),
            ('created_at', models.DateTimeField(auto_now_add=True)),
            ('modified_at', models.DateTimeField(auto_now=True)),
            ('avatar', models.ImageField(upload_to='i/user/')),
            ('photo', models.ImageField(upload_to='i/userphoto/')),
            ('work_phone', models.PositiveIntegerField(null=True, db_index=True)),
            ('mobile_phone', models.CharField(max_length=100, null=True, db_index=True)),
            ('work_email', models.CharField(max_length=100, null=True, db_index=True)),
        ))
        
        # Mock Models
        Staff = db.mock_model(model_name='Staff', db_table='users_staff', db_tablespace='', pk_field_name='id', pk_field_type=models.AutoField)
        
        # Model 'Office'
        db.create_table('users_departmentstaff', (
            ('id', models.AutoField(verbose_name='ID', primary_key=True, auto_created=True)),
            ('staff', models.ForeignKey(Staff)),
            ('department', models.ForeignKey(Department)),
            ('role', models.CharField(max_length=1)),
        ))
        
        db.send_create_signal('users', ['Staff','Department','Office', 'DepartmentStaff'])
    
    def backwards(self):
        db.delete_table('users_departmentstaff')
        db.delete_table('users_staff')
        db.delete_table('users_department')
        db.delete_table('users_office')
