# -*- coding: utf-8 -*-

from south.db import db
from libra.users.models import *

class Migration:

    def forwards(self):
        db.create_table('users_city', (
            ('id', models.AutoField(verbose_name='ID', primary_key=True, auto_created=True)),
            ('name', models.CharField(max_length=100)),
        ))
        db.send_create_signal('users', ['City'])

        City = db.mock_model(model_name='City', db_table='users_city', db_tablespace='', pk_field_name='id', pk_field_type=models.AutoField)
        db.add_column('users_office', 'city', models.ForeignKey(City, null=True))

    def backwards(self):
        db.delete_column('users_office', 'city_id')
        db.delete_table('users_city')

