
from south.db import db
from libra.users.models import *

class Migration:
    
    def forwards(self):
        # Mock Models
        Department = db.mock_model(model_name='Department', db_table='users_department', db_tablespace='', pk_field_name='id', pk_field_type=models.AutoField)
        
        # Model 'DepartmentStaffCounter'
        db.create_table('users_departmentstaffcounter', (
            ('id', models.AutoField(verbose_name='ID', primary_key=True, auto_created=True)),
            ('department', models.ForeignKey(Department, null=False)),
            ('day', models.DateField(db_index=True)),
            ('staff_counter', models.PositiveSmallIntegerField()),
        ))

        db.send_create_signal('users', ['DepartmentStaffCounter'])
    
    def backwards(self):
        db.delete_table('users_departmentstaffcounter')

