# -*- coding: utf-8 -*-

from south.db import db
from django.db import models
from libra.users.models import *

class Migration:
    
    def forwards(self):
        
        
        # Mock Models
        Service = db.mock_model(model_name='Service', db_table='users_service', db_tablespace='', pk_field_name='id', pk_field_type=models.AutoField, pk_field_args=[], pk_field_kwargs={})
        Staff = db.mock_model(model_name='Staff', db_table='users_staff', db_tablespace='', pk_field_name='id', pk_field_type=models.AutoField, pk_field_args=[], pk_field_kwargs={})
        
        # Model 'Service'
        db.create_table('users_service', (
            ('id', models.AutoField(verbose_name='ID', primary_key=True, auto_created=True)),
            ('from_staff_id', models.PositiveIntegerField(db_index=True)),
            ('parent', models.ForeignKey(Service, null=True, blank=True, related_name='children')),
            ('jira_key', models.CharField(max_length=20, null=True)),
            ('name', models.CharField(max_length=255)),
            ('url', models.CharField(max_length=255, null=True)),
            ('url_wiki', models.CharField(max_length=255, null=True)),
            ('wiki_supertag', models.CharField(max_length=255, db_index=True, null=True)),
            ('order', models.IntegerField(db_index=True)),
            ('maillist', models.EmailField(null=True)),
            ('owner', models.ForeignKey(Staff, null=True)),
            ('lft', models.PositiveIntegerField()),
            ('rght', models.PositiveIntegerField()),
            ('tree_id', models.PositiveIntegerField()),
            ('level', models.PositiveIntegerField()),
        ))
        # Model 'ServiceRole'
        db.create_table('users_servicerole', (
            ('id', models.AutoField(verbose_name='ID', primary_key=True, auto_created=True)),
            ('from_staff_id', models.PositiveIntegerField(db_index=True)),
            ('name', models.CharField(max_length=255, null=True)),
            ('order', models.IntegerField(db_index=True)),
            ('senior', models.BooleanField(default=False)),
        ))
        
        # Mock Models
        Staff = db.mock_model(model_name='Staff', db_table='users_staff', db_tablespace='', pk_field_name='id', pk_field_type=models.AutoField, pk_field_args=[], pk_field_kwargs={})
        Service = db.mock_model(model_name='Service', db_table='users_service', db_tablespace='', pk_field_name='id', pk_field_type=models.AutoField, pk_field_args=[], pk_field_kwargs={})
        ServiceRole = db.mock_model(model_name='ServiceRole', db_table='users_servicerole', db_tablespace='', pk_field_name='id', pk_field_type=models.AutoField, pk_field_args=[], pk_field_kwargs={})
        
        # Model 'ServiceMember'
        db.create_table('users_servicemember', (
            ('id', models.AutoField(verbose_name='ID', primary_key=True, auto_created=True)),
            ('from_staff_id', models.PositiveIntegerField(db_index=True)),
            ('staff', models.ForeignKey(Staff)),
            ('service', models.ForeignKey(Service)),
            ('role', models.ForeignKey(ServiceRole)),
            ('description', models.CharField(max_length=255, null=True)),
            ('order', models.IntegerField(db_index=True)),
            ('is_temp', models.BooleanField(default=False)),
        ))
        
        db.send_create_signal('users', ['Service','ServiceRole','ServiceMember'])
    
    def backwards(self):
        db.delete_table('users_servicemember')
        db.delete_table('users_servicerole')
        db.delete_table('users_service')
        
