# -*- coding: utf-8 -*-

from south.db import db
from django.db import models
from libra.users.models import *

class Migration:
    
    def forwards(self):
        # Mock Models
        Staff = db.mock_model(model_name='Staff', db_table='users_staff', db_tablespace='', pk_field_name='id', pk_field_type=models.AutoField, pk_field_args=[], pk_field_kwargs={})

        # Model 'StaffInflection'
        db.create_table('users_staffinflection', (
            ('id', models.AutoField(verbose_name='ID', primary_key=True, auto_created=True)),
            ('staff', models.ForeignKey(Staff)),
            ('subjective', models.CharField(max_length=100)),
            ('genitive', models.CharField(max_length=100)),
            ('dative', models.CharField(max_length=100)),
            ('accusative', models.CharField(max_length=100)),
            ('ablative', models.CharField(max_length=100)),
            ('prepositional', models.CharField(max_length=100)),
        ))
        db.send_create_signal('users', ['StaffInflection',])

    def backwards(self):
        db.delete_table('users_staffinflection')
