# -*- coding: utf-8 -*-

import os, sys
from django.core.files import locks
from django.conf import settings
from django.db import connection

LOCK_PATH = getattr(settings, 'LOCK_PATH', None)
if not LOCK_PATH:
    LOCK_PATH = settings.VAR_PATH

class PLocker(object):
    def plock(self, id):
        if not os.path.isdir(LOCK_PATH):
            os.makedirs(LOCK_PATH)

        self.filename = os.path.join(LOCK_PATH, id.replace('/', '_'))
        if os.path.isfile(self.filename):
            prev_unclean = True
        else:
            prev_unclean = False

        try:
            self.filepointer = open(self.filename, 'w')
            locks.lock(self.filepointer, locks.LOCK_EX | locks.LOCK_NB)
        except IOError:
            print "Another process detected"
            return False

        if prev_unclean:
            print "Previous process end unclean"
            pass

        return True

    def punlock(self):
        locks.unlock(self.filepointer)
        self.filepointer.close()
        os.remove(self.filename)

    def is_slave(self):
        cursor = connection.cursor()
        sql = 'SELECT @@read_only'
        cursor.execute(sql)
        return int(cursor.fetchone()[0])