# -*- coding: utf-8 -*-

import xml.dom.minidom, urllib, time, re
from models import Service, ServiceRole, ServiceMember, Staff
from utils import Uri

verbosity = 1

total_services = 0
saved_services = 0


def _attr(node, name):
    try:
        attr = node.attributes.getNamedItem(name)
        if not attr:
            return None
        try:
            return int(attr.nodeValue)
        except ValueError:
            return unicode(attr.nodeValue).strip()
    except UnicodeDecodeError:
        return None


def _wiki_url(url):
    if not url:
        return None

    tag = re.sub(r'^(https?://wiki\.yandex(-team)?\.ru)?/', '', url)
    return Uri.translit(tag)


def handle_service(service):
    global total_services, saved_services, verbosity
    total_services += 1

    db_service = Service(from_staff_id=_attr(service, 'service_id'))
    db_service.owner = None
    if _attr(service, 'owner'):
        db_service.owner = Staff.objects.get(login_ld=_attr(service, 'owner'))

    db_service.name = _attr(service, 'name')
    db_service.order = _attr(service, 'num')
    if _attr(service, 'skey') and len(_attr(service, 'skey')) > 0:
        db_service.jira_key = _attr(service, 'skey')[:20]
    db_service.url = _attr(service, 'url')
    db_service.url_wiki = _attr(service, 'wiki')
    db_service.wiki_supertag = _wiki_url(_attr(service, 'wiki'))
    db_service.maillist = _attr(service, 'maillist')

    db_service.parent = None
    if _attr(service, 'parent_id'):
        db_service.parent = Service.objects.get(from_staff_id = _attr(service, 'parent_id'))

    try:
        current_service = Service.objects.get(from_staff_id = _attr(service, 'service_id'))
        changed = False
        for attr in ('owner', 'name', 'order', 'jira_key', 'url', 'url_wiki', 'maillist', 'parent'):
            if current_service.__getattribute__(attr) != db_service.__getattribute__(attr):
                current_service.__setattr__(attr, db_service.__getattribute__(attr))
                changed = True
                if verbosity:
                    print u"Changed attr: " + unicode(attr) + " (" + unicode(current_service.__getattribute__(attr)) + " vs " + unicode(db_service.__getattribute__(attr)) + ")"

        if changed:
            saved_services += 1
            current_service.save()
    except Service.DoesNotExist:
        db_service.save()
        saved_services += 1



def _get_role(staff_id):
    return ServiceRole(from_staff_id=staff_id)


roles = {}

def handle_role(role):
    global roles
    role_id = _attr(role, 'id')
    if role_id and not role_id in roles:
        role_to_save = _get_role(role_id)
        role_to_save.name = _attr(role, 'name')
        role_to_save.order = _attr(role, 'num')
        if _attr(role, 'senior'):
            role_to_save.senior = True
        role_to_save.save()
        roles[role_id] = role_to_save


def empty_roles():
    ServiceRole.objects.all().delete()


total_members = 0
saved_members = 0

def handle_member(member):
    global roles, total_members, saved_members, verbosity
    total_members += 1
    member_to_save = ServiceMember(from_staff_id=_attr(member, 'team_id'))
    try:
        member_to_save.staff = Staff.objects.get(login_ld=_attr(member, 'ld_login'))
    except:
        if verbosity:
            print "login failed: " + str(_attr(member, 'ld_login')) + " on id " + str(_attr(member, 'team_id'))
        return
    member_to_save.role = roles[_attr(member, 'type')]
    member_to_save.service = Service.objects.get(from_staff_id = _attr(member, 'service_id'))
    member_to_save.description = _attr(member, 'descr')
    member_to_save.order = _attr(member, 'num')
    if _attr(member, 'temp'):
        member_to_save.is_temp = True

    try:
        current_member = ServiceMember.objects.get(from_staff_id = _attr(member, 'team_id'))
        changed = False
        for name in ('staff','role','order','service','description'):
            if member_to_save.__getattribute__(name) != current_member.__getattribute__(name):
                changed = True
                break

        if changed:
            member_to_save.id = current_member.id
            member_to_save.save()
            saved_members += 1
    except ServiceMember.DoesNotExist:
        member_to_save.save()
        saved_members += 1


def update(verbose=1):
    global total_services, saved_services, total_members, saved_members, verbosity
    verbosity = verbose
    """
    Update runner

    @param force: force update all staff users
    @type force: bool
    """

    uri = 'http://staff.yandex.ru/staff/services/xmlroles.xhtml'

    s = urllib.urlopen(uri).read()
    dom = xml.dom.minidom.parseString(s)

    empty_roles()
    for role in dom.getElementsByTagName('role'):
        handle_role(role)
    if verbosity:
        print  "Roles done"

    uri = 'http://staff.yandex.ru/staff/services/xml.xhtml'

    s = urllib.urlopen(uri).read()
    dom = xml.dom.minidom.parseString(s)

    for service in dom.getElementsByTagName('service'):
        handle_service(service)

    if verbosity:
        print "Total services: " + str(total_services) + ", updated: " + str(saved_services)

    for member in dom.getElementsByTagName('team'):
        handle_member(member)

    if verbosity:
        print "Total members: " + str(total_members) + ", updated: " + str(saved_members)


