# -*- coding: utf-8 -*-

import datetime
from models import DepartmentStaffCounter, Department, Staff

def update():
    """
    Count DepartmentStaffCounter value today
    """

    today = datetime.date.today()
    for dep in Department.objects.order_by('lft'):
        try:
            DepartmentStaffCounter.objects.filter(department=dep).filter(day=today)[0]
        except:
            DepartmentStaffCounter(
                day = today,
                department = dep,
                staff_counter = Staff.objects.filter(department__in=list(dep.get_descendants()) + [dep,]).exclude(is_dismissed=True).count()
            ).save()
