# -*- coding: utf-8 -*-

import xml.dom.minidom, os, urllib, time
from libra.users.models import Staff, Department, Office, DepartmentStaff, StaffInflection, City
from django.core.files.base import ContentFile
from django.conf import settings
from utils import inflect

departments = {}
cities = (
    'Москва',
    'Санкт-Петербург',
    'Екатеринбург',
    'Украина',
    'Калифорния',
)


def make_cities():
    if not City.objects.all().count():
        for city in cities:
            City(name=city).save()

        for o in Office.objects.all():
            if o.name.find(', ') != -1:
                try:
                    o.city = City.objects.get(name=o.name[:o.name.find(', ')])
                except:
                    try:
                        o.city = City.objects.get(name=o.name[o.name.find(', ')+2:])
                    except:
                        continue
            else:
                try:
                    o.city = City.objects.get(name=o.name)
                except:
                    continue
            o.save()


def handle_office(office):
    """
    Parse offices from XML and save it to DB
    """
    from_staff_id = office.attributes.getNamedItem('office_id').nodeValue
    name = office.attributes.getNamedItem('name').nodeValue
    try:
        o = Office.objects.get(from_staff_id=from_staff_id)
    except:
        o = Office(from_staff_id=from_staff_id)
    o.name = name
    o.save()

def pre_handle_dep(dep):
    """
    Preparing department - storing to global var departments hash for correct tree building
    """
    from_staff_id = dep.attributes.getNamedItem('dep_id').nodeValue
    departments[from_staff_id] = {
        'name': dep.attributes.getNamedItem('dep_name').nodeValue,
        'code': _get_value_from_node_attr(dep, 'did'),
        'en_name': _get_value_from_node_attr(dep, 'eng_name'),
        'bg_color': _get_value_from_node_attr(dep, 'color'),
        'fg_color': _get_value_from_node_attr(dep, 'textcolor'),
        'parent': _get_value_from_node_attr(dep, 'parent'),
        'chief_id': _get_value_from_node_attr(dep, 'id_chief', True),
        'deputy_id': _get_value_from_node_attr(dep, 'deputy_id', True),
        'is_handled': False,
    }

def handle_dep(from_staff_id, dep):
    """
    Parse departments from XML and save it into DB
    Chief and deputy fields saving to global var departments for post handlin,
    because at this moment we don't know about users
    """
    try:
        d = Department.objects.get(from_staff_id=from_staff_id)
    except:
        d = Department(from_staff_id=from_staff_id)

    d.name = dep['name']
    d.code = dep['code']
    d.en_name = dep['en_name']
    d.bg_color = dep['bg_color']
    d.fg_color = dep['fg_color']
    if dep['parent']:
        try:
            d.parent = Department.objects.get(from_staff_id=dep['parent'])
        except:
            if departments[dep['parent']]:
                handle_dep(dep['parent'], departments[dep['parent']])
                d.parent = Department.objects.get(from_staff_id=dep['parent'])
    d.save()
    departments[from_staff_id]['id'] = d.id

def post_handle_dep():
    """
    Save chief and deputy department's fields to DB from global var departments
    after users handling
    """
    for dep in departments:
        if departments[dep]['chief_id']:
            _handle_department_staff(departments[dep]['chief_id'], departments[dep]['id'], DepartmentStaff.ROLE_CHIEF)
        if departments[dep]['deputy_id']:
            _handle_department_staff(departments[dep]['deputy_id'], departments[dep]['id'], DepartmentStaff.ROLE_DEPUTY)

def _handle_department_staff(from_staff_id, dep_id, role):
    try:
        DepartmentStaff.objects.filter(department__id=dep_id).filter(role=role).delete()
    except:
        raise
    DepartmentStaff(
        staff=Staff.objects.get(from_staff_id=from_staff_id),
        department_id=dep_id,
        role=role
    ).save()

def handle_user(user):
    """
    Parse users from XML and save it into DB
    """
    from_staff_id = int(user.attributes.getNamedItem('user_id').nodeValue)
    try:
        u = Staff.objects.get(from_staff_id=from_staff_id)
    except:
        u = Staff(from_staff_id=from_staff_id)

    u.department = _get_foreign_from_node_attr(user, 'departament', Department)
    u.is_dismissed = False
    if u.department.from_staff_id == 39:
        u.department = _get_foreign_from_node_attr(user, 'dep_id', Department)
        u.is_dismissed = True
    u.office = _get_foreign_from_node_attr(user, 'office_id', Office)
    u.desk_id = _get_value_from_node_attr(user, 'table_id', True)
    u.login = _get_value_from_node_attr(user, 'login')
    u.login_ld = _get_value_from_node_attr(user, 'ld_login')
    domain = _get_value_from_node_attr(user, 'domain', True)
    if domain == 1:
        u.domain = 'C'
    elif domain == 2:
        u.domain = 'Y'
    elif domain == 3:
        u.domain = 'U'
    elif domain == 4:
        u.domain = 'M'
    elif domain == 5:
        u.domain = 'P'
    u.wiki_name = _get_value_from_node_attr(user, 'wiki_name')
    u.position = _get_value_from_node_attr(user, 'position')
    if _get_value_from_node_attr(user, 'first_in'):
        u.is_big_boss = True
    else:
        u.is_big_boss = False
    employment = _get_value_from_node_attr(user, 'jobform', True)
    if employment == 1:
        u.employment = 'F'
    elif employment == 2:
        u.employment = 'P'
    elif employment == 3:
        u.employment = 'D'
    u.join_at = _get_date(_get_value_from_node_attr(user, 'enterdate'), '%Y-%m-%d')
    u.quit_at = _get_date(_get_value_from_node_attr(user, 'date_quit'), '%Y-%m-%d')
    u.modified_at = _get_date(_get_value_from_node_attr(user, 'last_updated'))

    u.first_name = _get_value_from_node_attr(user, 'firstname')
    u.middle_name = _get_value_from_node_attr(user, 'secname')
    u.last_name = _get_value_from_node_attr(user, 'lastname')
    u.en_name = _get_value_from_node_attr(user, 'englname')
    u.birthday = _get_date(_get_value_from_node_attr(user, 'birthday'), '%Y-%m-%d')
    gender = _get_value_from_node_attr(user, 'sex')
    if gender.lower() == u'м':
        u.gender = 'M'
    elif gender.lower() == u'ж':
        u.gender = 'F'
    familystatus = _get_value_from_node_attr(user, 'familystatus', True)
    if familystatus == 1:
        u.family_status = 'S'
    elif familystatus == 2:
        u.family_status = 'M'
    u.children = _get_value_from_node_attr(user, 'children', True)
    u.address = _get_value_from_node_attr(user, 'place')
    u.car_num = _get_value_from_node_attr(user, 'auto_no')
    u.car = _get_value_from_node_attr(user, 'auto_mark')
    u.edu_place = _get_value_from_node_attr(user, 'eduplace')
    u.edu_date = _get_date(_get_value_from_node_attr(user, 'edudate'), '%Y-%m-%d')
    edu_status = _get_value_from_node_attr(user, 'edustatus', True)
    if edu_status == 4:
        u.edu_status = 'S'
    elif edu_status == 3:
        u.edu_status = 'I'
    elif edu_status == 1:
        u.edu_status = 'T'
    elif edu_status == 2:
        u.edu_status = 'L'
    elif edu_status == 5:
        u.edu_status = 'N'

    if u.login_ld and getattr(settings, 'USERS_AVATARS', None):
        avatar = _get_value_from_node_attr(user, 'phototb')
        if avatar and avatar!='photos/tb/nophoto.gif' and avatar!='photos/tb/1155_nadomnik.gif':
            try:
                _save_file(u.avatar, u.login_ld, avatar)
            except Exception, e:
                print e
                u.avatar = None
        photo = _get_value_from_node_attr(user, 'photourl')
        if photo and photo!='photos/nophoto.gif':
            try:
                _save_file(u.photo, u.login_ld, photo)
            except Exception, e:
                print e
                u.photo = None
        if avatar or photo:
            _clear_cache(u.login_ld)

    u.work_phone = _get_value_from_node_attr(user, 'ad_phone', True)
    u.mobile_phone = _get_value_from_node_attr(user, 'mobile')
    u.guid = _get_value_from_node_attr(user, 'guid')
    if u.login and u.domain:
        u.work_email = u.login
        if u.domain == 'C':
            u.work_email += '@comptek.ru'
        elif u.domain == 'Y':
            u.work_email += '@yandex-team.ru'
        elif u.domain == 'U':
            u.work_email += '@yandex-team.com.ua'
        elif u.domain == 'M':
            u.work_email += '@yamoney.ru'
        elif u.domain == 'P':
            u.work_email += '@yaprobki.ru'


#mobile
#icq
#homephone
#homemail
#homeurl
#ad_phone


    try:
        u.save()
    except Exception, e:
        print u.login, from_staff_id
        raise e

    inflections = inflect(' '.join(x for x in (u.first_name, u.last_name,) if x))
    if inflections:
        try:
            StaffInflection.objects.get(staff=u).delete()
        except StaffInflection.DoesNotExist:
            pass
        if len(inflections) > 1:
             StaffInflection(
                staff = u,
                subjective = inflections[0],
                genitive = inflections[1],
                dative = inflections[2],
                accusative = inflections[3],
                ablative = inflections[4],
                prepositional = inflections[5]
            ).save()

    #user.attributes.getNamedItem('mail').nodeValue
    #user.attributes.getNamedItem('mobile').nodeValue # check_empty_value
    #user.attributes.getNamedItem('workphone').nodeValue

def _save_file(field, login, uri):
    """
    Saving file 
    """
    s = urllib.urlopen('http://staff.yandex.ru/staff/%s' % uri).read()
    if field:
        field.delete()
    field.save(login + '.jpg', ContentFile(s))

def _clear_cache(login):
    path = os.path.join(settings.VAR_PATH, 'users', 'avatars')
    for f in os.listdir(path):
        if os.path.isfile(os.path.join(path, f)) and f.find(login+'-')!=-1:
            os.remove(os.path.join(path, f))


def _get_date(dt, format='%Y-%m-%d %H:%M:%S'):
    """
    MSSQL/staff date parse
    """
    if not dt:
        return None
    try:
        tuplah = time.strptime(dt, '%b %d %Y %I:%M%p')
        if tuplah[0] == 1930:
            return None
        return time.strftime(format, tuplah)
    except:
        return None

def _get_value_from_node_value(node):
    """
    XML helper
    """
    try:
        value = node.firstChild.nodeValue
    except:
        return None
    if not value or not value.strip():
        return None
    return value

def _get_value_from_node_attr(node, name, is_int=False):
    """
    XML helper for getting attribute 'name' value from node 'node'
    
    @param node: minidom XML-node
    @type node: xml.dom.minidom.Node

    @param name: minidom XML-node
    @type name: xml.dom.minidom.Node

    @param is_int: flag for to int conversion
    @type is_int: bool

    @return: node's attribute value
    @rtype: str|int
    """
    try:
        value = node.attributes.getNamedItem(name).nodeValue
    except:
        return None
    if is_int:
        try:
            value = int(value)
            if value < 0:
                value = 0
        except:
            value = None
        return value
    else:
        if not value or not value.strip() or value == '--':
            return None
        return value.strip()

def _get_foreign_from_node_attr(node, name, model):
    """
    XML helper for django foreign keys
    """
    if _get_value_from_node_attr(node, name):
        try:
            return model.objects.get(from_staff_id=_get_value_from_node_attr(node, name))
        except:
            return None
    return None

def update(force=False):
    """
    Update runner

    @param force: force update all staff users
    @type force: bool
    """
    uri = 'http://staff.yandex.ru/staff/xml_center.xhtml'

    if not force:
        try:
            last_updated = Staff.objects.all().order_by('-modified_at')[0]
            uri += '?last_updated=%s' % urllib.quote(str(last_updated.modified_at))
        except:
            pass

    s = urllib.urlopen(uri).read()
    dom = xml.dom.minidom.parseString(s)

    for office in dom.getElementsByTagName('office'):
        handle_office(office)

    for dep in dom.getElementsByTagName('departament'):
        pre_handle_dep(dep)
    for from_staff_id in departments:
        handle_dep(from_staff_id, departments[from_staff_id])

    for user in dom.getElementsByTagName('user'):
        handle_user(user)

    post_handle_dep()

    make_cities()
