# -*- coding: utf-8 -*-

import re, urllib, xml.dom.minidom
from django.core.files.base import ContentFile


class Uri:
    macroses = {
        u'вики': 'wiki',
        u'вака': 'wacko',
        u'вака': 'shwacko',
        u'веб': 'web',
        u'ланс': 'lance',
        u'кукуц': 'kukutz',
        u'мендокуси': 'mendokusee',
        u'яремко': 'iaremko',
        u'николай': 'nikolai',
        u'алексей': 'aleksey',
        u'анатолий': 'anatoly',
    }
    singleCharLettersFrom = [u'а', u'б', u'в', u'г', u'д', u'е', u'з', u'и', u'к', u'л', u'м', u'н', u'о', u'п', u'р', u'с', u'т', u'у', u'ф', u'х', u'ъ', u'ь', u'ц', u'ы', u'А', u'Б', u'В', u'Г', u'Д', u'Е', u'З', u'И', u'К', u'Л', u'М', u'Н', u'О', u'П', u'Р', u'С', u'Т', u'У', u'Ф', u'Х', u'Ъ', u'Ь', u'Ц', u'Ы']
    singleCharLettersTo = ['a', 'b', 'v', 'g', 'd', 'e', 'z', 'i', 'k', 'l', 'm', 'n', 'o', 'p', 'r', 's', 't', 'u', 'f', 'x', '_', '_', 'c', 'y', 'A', 'B', 'V', 'G', 'D', 'E', 'Z', 'I', 'K', 'L', 'M', 'N', 'O', 'P', 'R', 'S', 'T', 'U', 'F', 'X', '_', '_', 'C', 'Y']
    doubleCharLettersFrom = [u'й', u'ё', u'ж', u'ч', u'ш', u'щ', u'э', u'ю', u'я' , u'Й', u'Ё', u'Ж', u'Ч', u'Ш', u'Щ', u'Э', u'Ю', u'Я']
    doubleCharLettersTo = ['jj', 'jo', 'zh', 'ch', 'sh', 'shh', 'je', 'ju', 'ja', 'Jj', 'Jo', 'Zh', 'Ch', 'Sh', 'Shh', 'Je', 'Ju', 'Ja']
    
    @classmethod
    def translit(cls, page_tag):
        # substitute macroses
        for macros_key in cls.macroses:
            start = 0
            while True:
                position = page_tag.lower().find(macros_key, start)
                start = position + 1
                if position > -1:
                    if page_tag[position].lower() == page_tag[position]:
                        continue
                    key_length = len(macros_key)
                    if len(page_tag) > position + key_length \
                        and page_tag[position + key_length].lower() == page_tag[position + key_length]:
                        continue
                    macros_value = cls.macroses[macros_key]
                    page_tag = page_tag[:position] + macros_value.capitalize() + page_tag[position + key_length:]
                else:
                    break

        # substitute single char translit chars
        singleCharsLength = len(cls.singleCharLettersFrom)
        i = 0
        while i < singleCharsLength:
            page_tag = page_tag.replace(cls.singleCharLettersFrom[i], cls.singleCharLettersTo[i])
            i += 1

        # substitute double char translit chars
        doubleCharsLength = len(cls.doubleCharLettersFrom)
        i = 0
        while i < doubleCharsLength:
            page_tag = page_tag.replace(cls.doubleCharLettersFrom[i], cls.doubleCharLettersTo[i])
            i += 1

        # remove everything not allowed in the name
        page_tag = re.sub(r'[^A-zaz0-9\.\/\-]', '', page_tag)
        return page_tag.lower().rstrip('/')


class StaffUpdater(object):
    """
    Set of helper function for mixin to management command wich fetch info from staff.yandex.ru
    """
    STAFF_URL = 'http://staff.yandex.ru/'

    def _get_img_file(self, fname):
        return ContentFile(urllib.urlopen(fname).read())

    def _get_dom_from_url(self, url):
        return xml.dom.minidom.parseString(urllib.urlopen(url).read())

    def _get_date(self, dt, format='%Y-%m-%d %H:%M:%S'):
        """
        MSSQL/staff date parse
        """
        if not dt:
            return None
        try:
            tuplah = time.strptime(dt, '%b %d %Y %I:%M%p')
            if tuplah[0] == 1930:
                return None
            return time.strftime(format, tuplah)
        except:
            return None

    def _get_value_from_node_value(self, node):
        """
        XML helper
        """
        try:
            value = node.firstChild.nodeValue
        except AttributeError:
            return None
        if not value or not value.strip():
            return None
        return value

    def _get_value_from_node_attr(self, node, name, is_int=False):
        """
        XML helper for getting attribute 'name' value from node 'node'
        
        @param node: minidom XML-node
        @type node: xml.dom.minidom.Node

        @param name: minidom XML-node
        @type name: xml.dom.minidom.Node

        @param is_int: flag for to int conversion
        @type is_int: bool

        @return: node's attribute value
        @rtype: str|int
        """
        try:
            value = node.attributes.getNamedItem(name).nodeValue
        except AttributeError:
            return None
        if is_int:
            try:
                value = int(value)
            except ValueError:
                value = 0
            return value
        else:
            if not value or not value.strip() or value == '--':
                return None
            return value.strip()

    def _get_foreign_from_node_attr(self, node, name, model):
        """
        XML helper for django foreign keys
        """
        t = self._get_value_from_node_attr(node, name)
        if t:
            try:
                return model.objects.get(from_staff_id=t)
            except model.DoesNotExist:
                return None
        return None


INFLECTOR_URL = u'http://export.yandex.ru/inflect.xml?name='

def inflect(str):
    s = urllib.urlopen(INFLECTOR_URL + urllib.quote(str.encode('utf-8'))).read()
    return map(lambda x: x.firstChild.nodeValue, xml.dom.minidom.parseString(s).getElementsByTagName('inflection'))

