import os
import telebot as tb
from datetime import datetime

from collections import defaultdict
from enum import Enum

import scripts  # https://st.yandex-team.ru/HRTOOLS-460#5f8424e5fe8a193d0cbe7bb9


token = os.getenv('BOT_TELEGRAM_TOKEN')
bot = tb.TeleBot(token)


context = defaultdict(lambda: defaultdict(str))  # {user.id: {param: value}}

class Script:
    code = ''
    option = ''
    module = None

    def __init__(self, code: str, option: str):
        self.code = code
        self.option = option
        self.module = getattr(scripts, self.code)
    
    def __getattr__(self, attr: str):
        return getattr(self.module, attr)


SHOW_PROCEDURE = Script('show_procedure', 'Какова процедура?')
NEW_PURCHASE = Script('new_purchase', 'Создать новую закупку')
WRITE_TO_PURCHASER = Script('write_to_purchaser', 'Написать закупщику')
SHOW_PROVIDERS = Script('show_providers', 'Посмотреть пул поставщиков')
BLACKLIST_PROVIDER = Script('blacklist_provider', 'Добавить поставщика в чёрный список')
RATE_PROVIDER = Script('rate_provider', 'Оценить опыт работы с поставщиком')
SHOW_SLA = Script('show_sla', 'Узнать SLA на время тендера')
SHOW_TENDER_STAGES = Script('show_tender_stages', 'Узнать об этапах тендерной процедуры')
I_FORGOT_ZP_NUMBER = Script('i_forgot_zp_number', 'Я забыл номер ЗП')
SHOW_PROVIDER_EXPENSE = Script('show_provider_expense', 'Узнать расход с поставщиком')

SCRIPTS = {
    SHOW_PROCEDURE.code: SHOW_PROCEDURE,
    NEW_PURCHASE.code: NEW_PURCHASE,
    WRITE_TO_PURCHASER.code: WRITE_TO_PURCHASER,
    SHOW_PROVIDERS.code: SHOW_PROVIDERS,
    BLACKLIST_PROVIDER.code: BLACKLIST_PROVIDER,
    RATE_PROVIDER.code: RATE_PROVIDER,
    SHOW_SLA.code: SHOW_SLA,
    SHOW_TENDER_STAGES.code: SHOW_TENDER_STAGES,
    I_FORGOT_ZP_NUMBER.code: I_FORGOT_ZP_NUMBER,
    SHOW_PROVIDER_EXPENSE.code: SHOW_PROVIDER_EXPENSE,
}


def show_menu(chat_id: int, welcome_message: str = '') -> None:
    markup = tb.types.InlineKeyboardMarkup()
    for callback, script in SCRIPTS.items():
        markup.add(
            tb.types.InlineKeyboardButton(text=script.option, callback_data=callback)
        )
    
    bot.send_message(chat_id, welcome_message, reply_markup=markup)


@bot.message_handler(commands=['start'])
def start_message(message):
    show_menu(message.chat.id, welcome_message='Давай начнём. Есть такие опции:')


@bot.callback_query_handler(func=lambda call: True)
def callback_query(call: tb.types.CallbackQuery):
    user_context = context[call.from_user.username]
    if call.data in SCRIPTS:
        script = SCRIPTS[call.data].run
        response_text = script(call, bot, context=user_context)
        bot.edit_message_text(
            chat_id=call.message.chat.id,
            message_id=call.message.message_id,
            text=f'[{SCRIPTS[call.data].option}]\n\n{response_text}',
        ) 
    else:  # эта ветка по идее не доступна
        bot.answer_callback_query(call.id, "Ошибка.")
        bot.delete_message(chat_id=call.message.chat.id, message_id=call.message.message_id)
        

if __name__ == '__main__':
    print('starting bot https://t.me/procutestbot')
    bot.polling()
    print('\nterminated')
