import telebot as tb
from functools import partial


def run(call: tb.types.CallbackQuery, bot: tb.TeleBot, context: dict = None) -> str:
    get_provider_name_func = partial(get_provider_name, bot=bot, context=context)
    bot.register_next_step_handler(call.message, get_provider_name_func)
    return 'Введи ИНН или название поставщика.'


def get_provider_name(message, bot, context: dict):
    # log_message_to_console(message)
    context['provider_name'] = message.text
    bot.send_message(message.from_user.id, 'Введи комментарий: почему стоит заблокировать этого поставщика?')
    get_description_func = partial(get_blocking_description, bot=bot, context=context)
    bot.register_next_step_handler(message, get_description_func)


def get_blocking_description(message, bot, context: dict):
    # log_message_to_console(message)
    context['blocking_description'] = message.text
    bot.send_message(
        message.from_user.id,
        f"ИТОГО\n"
        f"Поставщик: {context['provider_name']}\n"
        f"Комментарий: {context['blocking_description']}\n\n"
        f"Всё верно? Блокируем? [y/n]"
    )
    # todo: можно вывести кнопки да\нет

    create_purchase_func = partial(create_purchase, bot=bot, context=context)
    bot.register_next_step_handler(message, create_purchase_func)


def create_st_block_provider_ticket(name: str, description: str) -> str:
    # blah-blah-blah
    return 'BLOCKPROVIDER-12345'

def create_purchase(message, bot, context: dict):
    provider_name = context.pop('provider_name')
    provider_description = context.pop('blocking_description')
    if not (provider_name and provider_description):
        bot.send_message(
            message.from_user.id,
            'Что-то пошло не так, потерялись введённые данные.\n'
            'Давай сначала: /start'
        )
        return
    if message.text.lower() not in ('да', 'yes', '+', 'конечно', 'lf', 'нуы', 'y', 'д', 'l', ):
        bot.send_message(
            message.from_user.id,
            'Ну нет так нет.\n'
            'Если что — пиши /start'
        )
        return
    ticket_key = create_st_block_provider_ticket(provider_name, provider_description)
    bot.send_message(
        message.from_user.id,
        f'Тикет на блокировку создан: st.yandex-team.ru/{ticket_key}',
    )




# @bot.message_handler(commands=['create_purchase'])
# def create_purchase(message):
#     provider_name = context[message.from_user.id].pop('purchase_name')
#     provider_description = context[message.from_user.id].pop('purchase_description')
#     if not (purchase_name and purchase_description):
#         bot.send_message(
#             message.from_user.id,
#             'Что-то пошло не так, потерялись введённые данные.\n'
#             'Давай сначала: /start'
#         )
#     ticket_key = create_st_purchase_ticket(purchase_name, purchase_description)
#     bot.send_message(
#         message.from_user.id,
#         f'Тикет создан: st.yandex-team.ru/{ticket_key}',
#     )