import telebot as tb
from functools import partial


def run(call: tb.types.CallbackQuery, bot: tb.TeleBot, context: dict = None) -> str:
    get_provider_name_func = partial(get_provider_name, bot=bot, context=context)
    bot.register_next_step_handler(call.message, get_provider_name_func)
    return 'Введи ИНН или название поставщика.'


def get_provider_name(message, bot, context: dict):
    context['provider_name'] = message.text
    bot.send_message(message.from_user.id, 'Введи комментарий: что ещё вам известно о поставщике и закупке?')
    get_description_func = partial(get_provider_description, bot=bot, context=context)
    bot.register_next_step_handler(message, get_description_func)


def get_provider_description(message, bot, context: dict):
    context['provider_description'] = message.text
    bot.send_message(
        message.from_user.id,
        f"ИТОГО\n"
        f"Поставщик: {context['provider_name']}\n"
        f"Комментарий: {context['provider_description']}\n\n"
        f"Всё верно? Создаём тикет на поиск номера ЗП? [y/n]"
    )
    # todo: можно вывести кнопки да\нет

    create_search_func = partial(create_search, bot=bot, context=context)
    bot.register_next_step_handler(message, create_search_func)


def create_st_search_zp_ticket(name: str, description: str) -> str:
    # Создаём тикет на поиск номера ЗП, в который прокидываем всю введённую информацию, 
    # даем на него ссылку пользователю. Тикет размечаем типом/тегом/компонентом, 
    # чтобы можно было отфильтровать такие тикеты и вывести их отдельным блоком на дашборде.
    return 'SEARCHZP-12345'

def create_search(message, bot, context: dict):
    provider_name = context.pop('provider_name')
    provider_description = context.pop('provider_description')
    if not (provider_name and provider_description):
        bot.send_message(
            message.from_user.id,
            'Что-то пошло не так, потерялись введённые данные.\n'
            'Давай сначала: /start'
        )
        return

    if message.text.lower() not in ('да', 'yes', '+', 'конечно', 'lf', 'нуы', 'y', 'д', 'l', ):
        bot.send_message(
            message.from_user.id,
            'Ну нет так нет.\n'
            'Если что — пиши /start'
        )
        return

    ticket_key = create_st_search_zp_ticket(provider_name, provider_description)
    bot.send_message(
        message.from_user.id,
        f'Тикет на поиск номера ЗП создан: st.yandex-team.ru/{ticket_key}',
    )
