import telebot as tb
from functools import partial


def run(call: tb.types.CallbackQuery, bot: tb.TeleBot, context: dict = None) -> str:
    get_provider_name_func = partial(get_provider_name, bot=bot, context=context)
    bot.register_next_step_handler(call.message, get_provider_name_func)
    return 'Введи ИНН поставщика.'


def get_provider_name(message, bot, context: dict):
    context['provider_name'] = message.text
    bot.send_message(message.from_user.id, 'Укажи год')
    get_description_func = partial(get_year, bot=bot, context=context)
    bot.register_next_step_handler(message, get_description_func)


def get_expenses_from_bi(name: str, year: str) -> str:
    # Забираем из BI и показываем совокупные расходы с поставщиком в рублях за выбранный год, если есть такие данные в BI.
    return '100500 денег'


def get_year(message, bot, context: dict):
    year = message.text
    provider_name = context.pop('provider_name')
    expense_info = get_expenses_from_bi(provider_name, year) 
    bot.send_message(
        message.from_user.id,
        expense_info,
    )
