// Code generated by schema-generate. DO NOT EDIT.

package api

import (
	"bytes"
	"encoding/json"
	"fmt"
)

// Roles set
var RolesSet = map[string]string{"read_departmentstaff": "read_departmentstaff", "read_equipment": "read_equipment", "read_group": "read_group", "read_groupmembership": "read_groupmembership", "read_office": "read_office", "read_organization": "read_organization", "read_person": "read_person", "read_position": "read_position", "read_room": "read_room", "read_table": "read_table"}

// Root
type Root interface{}

// AccountsItems
type AccountsItems struct {
	Id         *int    `bson:"id" json:"id,omitempty"`
	Private    *bool   `bson:"private" json:"private,omitempty"`
	Type       *string `bson:"type" json:"type,omitempty"`
	Value      *string `bson:"value" json:"value,omitempty"`
	ValueLower *string `bson:"value_lower" json:"value_lower,omitempty"`
}

// AccountsrefItems
type AccountsrefItems struct {
	Id         *int    `bson:"id" json:"id,omitempty"`
	Private    *bool   `bson:"private" json:"private,omitempty"`
	Value      *string `bson:"value" json:"value,omitempty"`
	ValueLower *string `bson:"value_lower" json:"value_lower,omitempty"`
}

// AffiliationCounters
type AffiliationCounters struct {
	External *int `bson:"external" json:"external,omitempty"`
	Yamoney  *int `bson:"yamoney" json:"yamoney,omitempty"`
	Yandex   *int `bson:"yandex" json:"yandex,omitempty"`
}

// BicyclesItems
type BicyclesItems struct {
	Description *string `bson:"description" json:"description,omitempty"`
	Id          *int    `bson:"id" json:"id,omitempty"`
	Plate       *int    `bson:"plate" json:"plate,omitempty"`
}

// CarsItems
type CarsItems struct {
	Id    *int    `bson:"id" json:"id,omitempty"`
	Model *string `bson:"model" json:"model,omitempty"`
	Plate *string `bson:"plate" json:"plate,omitempty"`
}

// City
type City struct {
	Country   *Country  `bson:"country" json:"country,omitempty"`
	CreatedAt *string   `bson:"created_at" json:"created_at,omitempty"`
	Id        *int      `bson:"id" json:"id,omitempty"`
	IsDeleted *bool     `bson:"is_deleted" json:"is_deleted,omitempty"`
	Name      *LangPair `bson:"name" json:"name,omitempty"`
}

// Contacts
type Contacts struct {
	Maillists *[]string `bson:"maillists" json:"maillists,omitempty"`
	Wiki      *string   `bson:"wiki" json:"wiki,omitempty"`
}

// ContactsItems
type ContactsItems struct {
	Type  *interface{} `bson:"type" json:"type,omitempty"`
	Value *string      `bson:"value" json:"value,omitempty"`
}

// Country
type Country struct {
	Code      *string   `bson:"code" json:"code,omitempty"`
	CreatedAt *string   `bson:"created_at" json:"created_at,omitempty"`
	Domain    *string   `bson:"domain" json:"domain,omitempty"`
	Geobase   *Geobase  `bson:"geobase" json:"geobase,omitempty"`
	Id        *int      `bson:"id" json:"id,omitempty"`
	IsDeleted *bool     `bson:"is_deleted" json:"is_deleted,omitempty"`
	Name      *LangPair `bson:"name" json:"name,omitempty"`
}

// Department
type Department struct {
	Contacts    *Contacts      `bson:"contacts" json:"contacts,omitempty"`
	Description *LangPair      `bson:"description" json:"description,omitempty"`
	Heads       *[]*HeadsItems `bson:"heads" json:"heads,omitempty"`
	Id          *interface{}   `bson:"id" json:"id,omitempty"`
	IsDeleted   *bool          `bson:"is_deleted" json:"is_deleted,omitempty"`
	Kind        *interface{}   `bson:"kind" json:"kind,omitempty"`
	Level       *int           `bson:"level" json:"level,omitempty"`
	Name        *Name          `bson:"name" json:"name,omitempty"`
	Url         *string        `bson:"url" json:"url,omitempty"`
}

// Departmentstaff
type Departmentstaff struct {
	DepartmentGroup *Groupshortref `bson:"department_group" json:"department_group,omitempty"`
	Id              *int           `bson:"id" json:"id,omitempty"`
	Meta            *Meta          `bson:"_meta" json:"_meta,omitempty"`
	Person          *Personref     `bson:"person" json:"person,omitempty"`
	Role            *string        `bson:"role" json:"role,omitempty"`
}

// Education
type Education struct {
	Area   *interface{} `bson:"area" json:"area,omitempty"`
	Date   *string      `bson:"date" json:"date,omitempty"`
	Place  *LangPair    `bson:"place" json:"place,omitempty"`
	Status *interface{} `bson:"status" json:"status,omitempty"`
}

// EmailsItems
type EmailsItems struct {
	Address    *string `bson:"address" json:"address,omitempty"`
	Id         *int    `bson:"id" json:"id,omitempty"`
	SourceType *string `bson:"source_type" json:"source_type,omitempty"`
}

// Environment
type Environment struct {
	Shell    *string `bson:"shell" json:"shell,omitempty"`
	Timezone *string `bson:"timezone" json:"timezone,omitempty"`
}

// Equipment
type Equipment struct {
	CreatedAt   *string      `bson:"created_at" json:"created_at,omitempty"`
	Description *string      `bson:"description" json:"description,omitempty"`
	Floor       *Floor       `bson:"floor" json:"floor,omitempty"`
	Hostname    *string      `bson:"hostname" json:"hostname,omitempty"`
	Id          *int         `bson:"id" json:"id,omitempty"`
	IsDeleted   *bool        `bson:"is_deleted" json:"is_deleted,omitempty"`
	Location    *Location    `bson:"location" json:"location,omitempty"`
	Meta        *Meta        `bson:"_meta" json:"_meta,omitempty"`
	Name        *string      `bson:"name" json:"name,omitempty"`
	Type        *interface{} `bson:"type" json:"type,omitempty"`
}

// Floor
type Floor struct {
	CreatedAt *string      `bson:"created_at" json:"created_at,omitempty"`
	Id        *int         `bson:"id" json:"id,omitempty"`
	Image     *interface{} `bson:"image" json:"image,omitempty"`
	IsDeleted *bool        `bson:"is_deleted" json:"is_deleted,omitempty"`
	Name      *LangPair    `bson:"name" json:"name,omitempty"`
	Number    *interface{} `bson:"number" json:"number,omitempty"`
	Office    *Officeref   `bson:"office" json:"office,omitempty"`
}

// Floorflatref
type Floorflatref struct {
	Id        *int         `bson:"id" json:"id,omitempty"`
	Image     *interface{} `bson:"image" json:"image,omitempty"`
	IsDeleted *bool        `bson:"is_deleted" json:"is_deleted,omitempty"`
	Name      *LangPair    `bson:"name" json:"name,omitempty"`
	Number    *interface{} `bson:"number" json:"number,omitempty"`
}

// Floorref
type Floorref struct {
	Id        *int         `bson:"id" json:"id,omitempty"`
	IsDeleted *bool        `bson:"is_deleted" json:"is_deleted,omitempty"`
	Name      *LangPair    `bson:"name" json:"name,omitempty"`
	Number    *interface{} `bson:"number" json:"number,omitempty"`
	Office    *Officeref   `bson:"office" json:"office,omitempty"`
}

// Geobase
type Geobase struct {
	Id *int `bson:"id" json:"id,omitempty"`
}

// GpgKeysItems
type GpgKeysItems struct {
	Description *string `bson:"description" json:"description,omitempty"`
	Fingerprint *string `bson:"fingerprint" json:"fingerprint,omitempty"`
	Id          *int    `bson:"id" json:"id,omitempty"`
	Key         *string `bson:"key" json:"key,omitempty"`
}

// Group
type Group struct {
	AffiliationCounters *AffiliationCounters  `bson:"affiliation_counters" json:"affiliation_counters,omitempty"`
	Ancestors           *[]*Grouprefnested    `bson:"ancestors" json:"ancestors,omitempty"`
	Department          *Department           `bson:"department" json:"department,omitempty"`
	Description         *string               `bson:"description" json:"description,omitempty"`
	Id                  *int                  `bson:"id" json:"id,omitempty"`
	IsDeleted           *bool                 `bson:"is_deleted" json:"is_deleted,omitempty"`
	Level               *int                  `bson:"level" json:"level,omitempty"`
	Meta                *Meta                 `bson:"_meta" json:"_meta,omitempty"`
	Name                *string               `bson:"name" json:"name,omitempty"`
	Parent              *interface{}          `bson:"parent" json:"parent,omitempty"`
	Responsibles        *[]*ResponsiblesItems `bson:"responsibles" json:"responsibles,omitempty"`
	RoleScope           *interface{}          `bson:"role_scope" json:"role_scope,omitempty"`
	Service             *Serviceref           `bson:"service" json:"service,omitempty"`
	Type                *interface{}          `bson:"type" json:"type,omitempty"`
	Url                 *string               `bson:"url" json:"url,omitempty"`
}

// Groupmembership
type Groupmembership struct {
	Group    *Groupref  `bson:"group" json:"group,omitempty"`
	Id       *int       `bson:"id" json:"id,omitempty"`
	JoinedAt *string    `bson:"joined_at" json:"joined_at,omitempty"`
	Meta     *Meta      `bson:"_meta" json:"_meta,omitempty"`
	Person   *Personref `bson:"person" json:"person,omitempty"`
}

// Groupref
type Groupref struct {
	AffiliationCounters *AffiliationCounters  `bson:"affiliation_counters" json:"affiliation_counters,omitempty"`
	Ancestors           *[]*Grouprefnested    `bson:"ancestors" json:"ancestors,omitempty"`
	Department          *Department           `bson:"department" json:"department,omitempty"`
	Description         *string               `bson:"description" json:"description,omitempty"`
	Id                  *int                  `bson:"id" json:"id,omitempty"`
	IsDeleted           *bool                 `bson:"is_deleted" json:"is_deleted,omitempty"`
	Level               *int                  `bson:"level" json:"level,omitempty"`
	Name                *string               `bson:"name" json:"name,omitempty"`
	Parent              *interface{}          `bson:"parent" json:"parent,omitempty"`
	Responsibles        *[]*ResponsiblesItems `bson:"responsibles" json:"responsibles,omitempty"`
	RoleScope           *interface{}          `bson:"role_scope" json:"role_scope,omitempty"`
	Service             *Serviceref           `bson:"service" json:"service,omitempty"`
	Type                *interface{}          `bson:"type" json:"type,omitempty"`
	Url                 *string               `bson:"url" json:"url,omitempty"`
}

// Grouprefnested
type Grouprefnested struct {
	AffiliationCounters *AffiliationCounters  `bson:"affiliation_counters" json:"affiliation_counters,omitempty"`
	Department          *Department           `bson:"department" json:"department,omitempty"`
	Description         *string               `bson:"description" json:"description,omitempty"`
	Id                  *int                  `bson:"id" json:"id,omitempty"`
	IsDeleted           *bool                 `bson:"is_deleted" json:"is_deleted,omitempty"`
	Level               *int                  `bson:"level" json:"level,omitempty"`
	Name                *string               `bson:"name" json:"name,omitempty"`
	Responsibles        *[]*ResponsiblesItems `bson:"responsibles" json:"responsibles,omitempty"`
	RoleScope           *interface{}          `bson:"role_scope" json:"role_scope,omitempty"`
	Service             *Serviceref           `bson:"service" json:"service,omitempty"`
	Type                *interface{}          `bson:"type" json:"type,omitempty"`
	Url                 *string               `bson:"url" json:"url,omitempty"`
}

// GroupsItems
type GroupsItems struct {
	Group    *Groupref `bson:"group" json:"group,omitempty"`
	Id       *int      `bson:"id" json:"id,omitempty"`
	JoinedAt *string   `bson:"joined_at" json:"joined_at,omitempty"`
}

// Groupshortref
type Groupshortref struct {
	Department *Shortrefdepartment `bson:"department" json:"department,omitempty"`
	Id         *interface{}        `bson:"id" json:"id,omitempty"`
	IsDeleted  *bool               `bson:"is_deleted" json:"is_deleted,omitempty"`
	Level      *int                `bson:"level" json:"level,omitempty"`
	Name       *string             `bson:"name" json:"name,omitempty"`
	RoleScope  *interface{}        `bson:"role_scope" json:"role_scope,omitempty"`
	Service    *Serviceref         `bson:"service" json:"service,omitempty"`
	Type       *interface{}        `bson:"type" json:"type,omitempty"`
	Url        *string             `bson:"url" json:"url,omitempty"`
}

// HeadsItems
type HeadsItems struct {
	Id     *int         `bson:"id" json:"id,omitempty"`
	Person *Personref   `bson:"person" json:"person,omitempty"`
	Role   *interface{} `bson:"role" json:"role,omitempty"`
}

// Images
type Images struct {
	Avatar *string `bson:"avatar" json:"avatar,omitempty"`
	Photo  *string `bson:"photo" json:"photo,omitempty"`
}

// KeysItems
type KeysItems struct {
	Description       *string `bson:"description" json:"description,omitempty"`
	Fingerprint       *string `bson:"fingerprint" json:"fingerprint,omitempty"`
	FingerprintSha256 *string `bson:"fingerprint_sha256" json:"fingerprint_sha256,omitempty"`
	Id                *int    `bson:"id" json:"id,omitempty"`
	Key               *string `bson:"key" json:"key,omitempty"`
}

// Kind_object
type Kind_object struct {
	Id   *int         `bson:"id" json:"id,omitempty"`
	Name *LangPair    `bson:"name" json:"name,omitempty"`
	Slug *interface{} `bson:"slug" json:"slug,omitempty"`
}

// LangPair
type LangPair struct {
	En *string `bson:"en" json:"en,omitempty"`
	Ru *string `bson:"ru" json:"ru,omitempty"`
}

// Language
type Language struct {
	AutoTranslate *bool   `bson:"auto_translate" json:"auto_translate,omitempty"`
	Content       *string `bson:"content" json:"content,omitempty"`
	Native        *string `bson:"native" json:"native,omitempty"`
	Ui            *string `bson:"ui" json:"ui,omitempty"`
}

// Location
type Location struct {
	X *int `bson:"x" json:"x,omitempty"`
	Y *int `bson:"y" json:"y,omitempty"`
}

// Memorial_object
type Memorial_object struct {
	DeathDate *string `bson:"death_date" json:"death_date,omitempty"`
	Id        *int    `bson:"id" json:"id,omitempty"`
}

// Meta
type Meta struct {
	MessageId  *int    `bson:"message_id" json:"message_id,omitempty"`
	ModifiedAt *string `bson:"modified_at" json:"modified_at,omitempty"`
}

// Name
type Name struct {
	First        *LangPair `bson:"first" json:"first,omitempty"`
	HasNamesake  *bool     `bson:"has_namesake" json:"has_namesake,omitempty"`
	HiddenMiddle *bool     `bson:"hidden_middle" json:"hidden_middle,omitempty"`
	Last         *LangPair `bson:"last" json:"last,omitempty"`
	Middle       *string   `bson:"middle" json:"middle,omitempty"`
}

// Office
type Office struct {
	Address   *LangPair        `bson:"address" json:"address,omitempty"`
	City      *City            `bson:"city" json:"city,omitempty"`
	Code      *string          `bson:"code" json:"code,omitempty"`
	Contacts  *Contacts        `bson:"contacts" json:"contacts,omitempty"`
	CreatedAt *string          `bson:"created_at" json:"created_at,omitempty"`
	Floors    *[]*Floorflatref `bson:"floors" json:"floors,omitempty"`
	HaveMap   *bool            `bson:"have_map" json:"have_map,omitempty"`
	Id        *int             `bson:"id" json:"id,omitempty"`
	IsDeleted *bool            `bson:"is_deleted" json:"is_deleted,omitempty"`
	IsVirtual *bool            `bson:"is_virtual" json:"is_virtual,omitempty"`
	Meta      *Meta            `bson:"_meta" json:"_meta,omitempty"`
	Name      *LangPair        `bson:"name" json:"name,omitempty"`
	Timezone  *string          `bson:"timezone" json:"timezone,omitempty"`
}

// Officeref
type Officeref struct {
	Address   *LangPair `bson:"address" json:"address,omitempty"`
	City      *City     `bson:"city" json:"city,omitempty"`
	Code      *string   `bson:"code" json:"code,omitempty"`
	Contacts  *Contacts `bson:"contacts" json:"contacts,omitempty"`
	CreatedAt *string   `bson:"created_at" json:"created_at,omitempty"`
	HaveMap   *bool     `bson:"have_map" json:"have_map,omitempty"`
	Id        *int      `bson:"id" json:"id,omitempty"`
	IsDeleted *bool     `bson:"is_deleted" json:"is_deleted,omitempty"`
	IsVirtual *bool     `bson:"is_virtual" json:"is_virtual,omitempty"`
	Name      *LangPair `bson:"name" json:"name,omitempty"`
	Timezone  *string   `bson:"timezone" json:"timezone,omitempty"`
}

// Official
type Official struct {
	Affiliation     *interface{}  `bson:"affiliation" json:"affiliation,omitempty"`
	ContractEndedAt *interface{}  `bson:"contract_ended_at" json:"contract_ended_at,omitempty"`
	Duties          *LangPair     `bson:"duties" json:"duties,omitempty"`
	Employment      *interface{}  `bson:"employment" json:"employment,omitempty"`
	HasByodAccess   *bool         `bson:"has_byod_access" json:"has_byod_access,omitempty"`
	IsDismissed     *bool         `bson:"is_dismissed" json:"is_dismissed,omitempty"`
	IsHomeworker    *bool         `bson:"is_homeworker" json:"is_homeworker,omitempty"`
	IsRobot         *bool         `bson:"is_robot" json:"is_robot,omitempty"`
	IsTrainee       *bool         `bson:"is_trainee" json:"is_trainee,omitempty"`
	JoinAt          *string       `bson:"join_at" json:"join_at,omitempty"`
	NdaEndedAt      *interface{}  `bson:"nda_ended_at" json:"nda_ended_at,omitempty"`
	Organization    *Organization `bson:"organization" json:"organization,omitempty"`
	Position        *LangPair     `bson:"position" json:"position,omitempty"`
	QuitAt          *interface{}  `bson:"quit_at" json:"quit_at,omitempty"`
	StaffAgreement  *bool         `bson:"staff_agreement" json:"staff_agreement,omitempty"`
	Wiretap         *bool         `bson:"wiretap" json:"wiretap,omitempty"`
}

// Organization
type Organization struct {
	CreatedAt *string `bson:"created_at" json:"created_at,omitempty"`
	Id        *int    `bson:"id" json:"id,omitempty"`
	IsDeleted *bool   `bson:"is_deleted" json:"is_deleted,omitempty"`
	Meta      *Meta   `bson:"_meta" json:"_meta,omitempty"`
	Name      *string `bson:"name" json:"name,omitempty"`
	NameEn    *string `bson:"name_en" json:"name_en,omitempty"`
}

// Person
type Person struct {
	Accounts         *[]*AccountsItems    `bson:"accounts" json:"accounts,omitempty"`
	Bicycles         *[]*BicyclesItems    `bson:"bicycles" json:"bicycles,omitempty"`
	Cars             *[]*CarsItems        `bson:"cars" json:"cars,omitempty"`
	Chief            *interface{}         `bson:"chief" json:"chief,omitempty"`
	Chiefs           *[]*Personnewref     `bson:"chiefs" json:"chiefs,omitempty"`
	Contacts         *[]*ContactsItems    `bson:"contacts" json:"contacts,omitempty"`
	CreatedAt        *string              `bson:"created_at" json:"created_at,omitempty"`
	DepartmentGroup  *Groupref            `bson:"department_group" json:"department_group,omitempty"`
	Education        *Education           `bson:"education" json:"education,omitempty"`
	Emails           *[]*EmailsItems      `bson:"emails" json:"emails,omitempty"`
	Environment      *Environment         `bson:"environment" json:"environment,omitempty"`
	GpgKeys          *[]*GpgKeysItems     `bson:"gpg_keys" json:"gpg_keys,omitempty"`
	Groups           *[]*GroupsItems      `bson:"groups" json:"groups,omitempty"`
	Guid             *string              `bson:"guid" json:"guid,omitempty"`
	HrPartners       *[]*Personnewref     `bson:"hr_partners" json:"hr_partners,omitempty"`
	Id               *int                 `bson:"id" json:"id,omitempty"`
	Images           *Images              `bson:"images" json:"images,omitempty"`
	IsDeleted        *bool                `bson:"is_deleted" json:"is_deleted,omitempty"`
	Keys             *[]*KeysItems        `bson:"keys" json:"keys,omitempty"`
	Language         *Language            `bson:"language" json:"language,omitempty"`
	Location         *Location            `bson:"location" json:"location,omitempty"`
	Login            *string              `bson:"login" json:"login,omitempty"`
	Memorial         *interface{}         `bson:"memorial" json:"memorial,omitempty"`
	Meta             *Meta                `bson:"_meta" json:"_meta,omitempty"`
	Name             *Name                `bson:"name" json:"name,omitempty"`
	Official         *Official            `bson:"official" json:"official,omitempty"`
	Personal         *Personal            `bson:"personal" json:"personal,omitempty"`
	PersonalEmails   *[]*AccountsrefItems `bson:"personal_emails" json:"personal_emails,omitempty"`
	Phones           *[]*PhonesItems      `bson:"phones" json:"phones,omitempty"`
	RobotOwners      *[]*RobotOwnersItems `bson:"robot_owners" json:"robot_owners,omitempty"`
	RobotUsers       *[]*RobotUsersItems  `bson:"robot_users" json:"robot_users,omitempty"`
	SkypeAccounts    *[]*AccountsrefItems `bson:"skype_accounts" json:"skype_accounts,omitempty"`
	TelegramAccounts *[]*AccountsrefItems `bson:"telegram_accounts" json:"telegram_accounts,omitempty"`
	Uid              *string              `bson:"uid" json:"uid,omitempty"`
	WorkEmail        *string              `bson:"work_email" json:"work_email,omitempty"`
	WorkPhone        *int                 `bson:"work_phone" json:"work_phone,omitempty"`
	Yandex           *Yandex              `bson:"yandex" json:"yandex,omitempty"`
}

// Personal
type Personal struct {
	About             *string      `bson:"about" json:"about,omitempty"`
	Address           *LangPair    `bson:"address" json:"address,omitempty"`
	Birthday          *string      `bson:"birthday" json:"birthday,omitempty"`
	Children          *int         `bson:"children" json:"children,omitempty"`
	FamilyStatus      *interface{} `bson:"family_status" json:"family_status,omitempty"`
	Gender            *interface{} `bson:"gender" json:"gender,omitempty"`
	MobilePhoneModel  *string      `bson:"mobile_phone_model" json:"mobile_phone_model,omitempty"`
	MobilePhoneNumber *string      `bson:"mobile_phone_number" json:"mobile_phone_number,omitempty"`
	TshirtSize        *interface{} `bson:"tshirt_size" json:"tshirt_size,omitempty"`
}

// Personnewref
type Personnewref struct {
	Guid  *string `bson:"guid" json:"guid,omitempty"`
	Id    *int    `bson:"id" json:"id,omitempty"`
	Login *string `bson:"login" json:"login,omitempty"`
	Name  *Name   `bson:"name" json:"name,omitempty"`
	Uid   *string `bson:"uid" json:"uid,omitempty"`
}

// Personref
type Personref struct {
	Guid      *string   `bson:"guid" json:"guid,omitempty"`
	Id        *int      `bson:"id" json:"id,omitempty"`
	IsDeleted *bool     `bson:"is_deleted" json:"is_deleted,omitempty"`
	Login     *string   `bson:"login" json:"login,omitempty"`
	Name      *Name     `bson:"name" json:"name,omitempty"`
	Official  *Official `bson:"official" json:"official,omitempty"`
	Uid       *string   `bson:"uid" json:"uid,omitempty"`
}

// PhonesItems
type PhonesItems struct {
	Description *string      `bson:"description" json:"description,omitempty"`
	Id          *int         `bson:"id" json:"id,omitempty"`
	IsMain      *bool        `bson:"is_main" json:"is_main,omitempty"`
	Kind        *interface{} `bson:"kind" json:"kind,omitempty"`
	Number      *string      `bson:"number" json:"number,omitempty"`
	Protocol    *interface{} `bson:"protocol" json:"protocol,omitempty"`
	Type        *interface{} `bson:"type" json:"type,omitempty"`
}

// Position
type Position struct {
	Code      *int         `bson:"code" json:"code,omitempty"`
	EndDate   *interface{} `bson:"end_date" json:"end_date,omitempty"`
	Id        *int         `bson:"id" json:"id,omitempty"`
	Meta      *Meta        `bson:"_meta" json:"_meta,omitempty"`
	Name      *LangPair    `bson:"name" json:"name,omitempty"`
	StartDate *string      `bson:"start_date" json:"start_date,omitempty"`
}

// ResponsiblesItems
type ResponsiblesItems struct {
	Id          *int       `bson:"id" json:"id,omitempty"`
	PermittedAt *string    `bson:"permitted_at" json:"permitted_at,omitempty"`
	Person      *Personref `bson:"person" json:"person,omitempty"`
}

// RobotOwnersItems
type RobotOwnersItems struct {
	Id     *int       `bson:"id" json:"id,omitempty"`
	Person *Personref `bson:"person" json:"person,omitempty"`
}

// RobotUsersItems
type RobotUsersItems struct {
	Id     *int       `bson:"id" json:"id,omitempty"`
	Person *Personref `bson:"person" json:"person,omitempty"`
}

// Room
type Room struct {
	Additional *string      `bson:"additional" json:"additional,omitempty"`
	Capacity   *string      `bson:"capacity" json:"capacity,omitempty"`
	CreatedAt  *string      `bson:"created_at" json:"created_at,omitempty"`
	Equipment  *Equipment   `bson:"equipment" json:"equipment,omitempty"`
	Floor      *Floor       `bson:"floor" json:"floor,omitempty"`
	Id         *int         `bson:"id" json:"id,omitempty"`
	IsBookable *bool        `bson:"is_bookable" json:"is_bookable,omitempty"`
	IsDeleted  *bool        `bson:"is_deleted" json:"is_deleted,omitempty"`
	Location   *Location    `bson:"location" json:"location,omitempty"`
	Meta       *Meta        `bson:"_meta" json:"_meta,omitempty"`
	Name       *Name        `bson:"name" json:"name,omitempty"`
	Number     *int         `bson:"number" json:"number,omitempty"`
	Phone      *string      `bson:"phone" json:"phone,omitempty"`
	Type       *interface{} `bson:"type" json:"type,omitempty"`
}

// Serviceref
type Serviceref struct {
	Id *interface{} `bson:"id" json:"id,omitempty"`
}

// Shortrefdepartment
type Shortrefdepartment struct {
	Id *interface{} `bson:"id" json:"id,omitempty"`
}

// Table
type Table struct {
	CreatedAt *string   `bson:"created_at" json:"created_at,omitempty"`
	Floor     *Floor    `bson:"floor" json:"floor,omitempty"`
	Id        *int      `bson:"id" json:"id,omitempty"`
	Location  *Location `bson:"location" json:"location,omitempty"`
	Meta      *Meta     `bson:"_meta" json:"_meta,omitempty"`
	Number    *int      `bson:"number" json:"number,omitempty"`
}

// Yandex
type Yandex struct {
	Login *string `bson:"login" json:"login,omitempty"`
}

func (strct *AccountsItems) MarshalJSON() ([]byte, error) {
	buf := bytes.NewBuffer(make([]byte, 0))
	buf.WriteString("{")
	comma := false
	// Marshal the "id" field
	if strct.Id != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"id\": ")
		if tmp, err := json.Marshal(strct.Id); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "private" field
	if strct.Private != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"private\": ")
		if tmp, err := json.Marshal(strct.Private); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "type" field
	if strct.Type != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"type\": ")
		if tmp, err := json.Marshal(strct.Type); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "value" field
	if strct.Value != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"value\": ")
		if tmp, err := json.Marshal(strct.Value); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "value_lower" field
	if strct.ValueLower != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"value_lower\": ")
		if tmp, err := json.Marshal(strct.ValueLower); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}

	buf.WriteString("}")
	rv := buf.Bytes()
	return rv, nil
}

func (strct *AccountsItems) UnmarshalJSON(b []byte) error {
	var jsonMap map[string]json.RawMessage
	if err := json.Unmarshal(b, &jsonMap); err != nil {
		return err
	}
	// parse all the defined properties
	for k, v := range jsonMap {
		switch k {
		case "id":
			if err := json.Unmarshal([]byte(v), &strct.Id); err != nil {
				return err
			}
		case "private":
			if err := json.Unmarshal([]byte(v), &strct.Private); err != nil {
				return err
			}
		case "type":
			if err := json.Unmarshal([]byte(v), &strct.Type); err != nil {
				return err
			}
		case "value":
			if err := json.Unmarshal([]byte(v), &strct.Value); err != nil {
				return err
			}
		case "value_lower":
			if err := json.Unmarshal([]byte(v), &strct.ValueLower); err != nil {
				return err
			}
		default:
			return fmt.Errorf("additional property not allowed: \"" + k + "\"")
		}
	}
	return nil
}

func (strct *AccountsrefItems) MarshalJSON() ([]byte, error) {
	buf := bytes.NewBuffer(make([]byte, 0))
	buf.WriteString("{")
	comma := false
	// Marshal the "id" field
	if strct.Id != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"id\": ")
		if tmp, err := json.Marshal(strct.Id); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "private" field
	if strct.Private != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"private\": ")
		if tmp, err := json.Marshal(strct.Private); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "value" field
	if strct.Value != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"value\": ")
		if tmp, err := json.Marshal(strct.Value); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "value_lower" field
	if strct.ValueLower != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"value_lower\": ")
		if tmp, err := json.Marshal(strct.ValueLower); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}

	buf.WriteString("}")
	rv := buf.Bytes()
	return rv, nil
}

func (strct *AccountsrefItems) UnmarshalJSON(b []byte) error {
	var jsonMap map[string]json.RawMessage
	if err := json.Unmarshal(b, &jsonMap); err != nil {
		return err
	}
	// parse all the defined properties
	for k, v := range jsonMap {
		switch k {
		case "id":
			if err := json.Unmarshal([]byte(v), &strct.Id); err != nil {
				return err
			}
		case "private":
			if err := json.Unmarshal([]byte(v), &strct.Private); err != nil {
				return err
			}
		case "value":
			if err := json.Unmarshal([]byte(v), &strct.Value); err != nil {
				return err
			}
		case "value_lower":
			if err := json.Unmarshal([]byte(v), &strct.ValueLower); err != nil {
				return err
			}
		default:
			return fmt.Errorf("additional property not allowed: \"" + k + "\"")
		}
	}
	return nil
}

func (strct *AffiliationCounters) MarshalJSON() ([]byte, error) {
	buf := bytes.NewBuffer(make([]byte, 0))
	buf.WriteString("{")
	comma := false
	// Marshal the "external" field
	if strct.External != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"external\": ")
		if tmp, err := json.Marshal(strct.External); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "yamoney" field
	if strct.Yamoney != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"yamoney\": ")
		if tmp, err := json.Marshal(strct.Yamoney); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "yandex" field
	if strct.Yandex != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"yandex\": ")
		if tmp, err := json.Marshal(strct.Yandex); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}

	buf.WriteString("}")
	rv := buf.Bytes()
	return rv, nil
}

func (strct *AffiliationCounters) UnmarshalJSON(b []byte) error {
	var jsonMap map[string]json.RawMessage
	if err := json.Unmarshal(b, &jsonMap); err != nil {
		return err
	}
	// parse all the defined properties
	for k, v := range jsonMap {
		switch k {
		case "external":
			if err := json.Unmarshal([]byte(v), &strct.External); err != nil {
				return err
			}
		case "yamoney":
			if err := json.Unmarshal([]byte(v), &strct.Yamoney); err != nil {
				return err
			}
		case "yandex":
			if err := json.Unmarshal([]byte(v), &strct.Yandex); err != nil {
				return err
			}
		default:
			return fmt.Errorf("additional property not allowed: \"" + k + "\"")
		}
	}
	return nil
}

func (strct *BicyclesItems) MarshalJSON() ([]byte, error) {
	buf := bytes.NewBuffer(make([]byte, 0))
	buf.WriteString("{")
	comma := false
	// Marshal the "description" field
	if strct.Description != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"description\": ")
		if tmp, err := json.Marshal(strct.Description); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "id" field
	if strct.Id != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"id\": ")
		if tmp, err := json.Marshal(strct.Id); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "plate" field
	if strct.Plate != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"plate\": ")
		if tmp, err := json.Marshal(strct.Plate); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}

	buf.WriteString("}")
	rv := buf.Bytes()
	return rv, nil
}

func (strct *BicyclesItems) UnmarshalJSON(b []byte) error {
	var jsonMap map[string]json.RawMessage
	if err := json.Unmarshal(b, &jsonMap); err != nil {
		return err
	}
	// parse all the defined properties
	for k, v := range jsonMap {
		switch k {
		case "description":
			if err := json.Unmarshal([]byte(v), &strct.Description); err != nil {
				return err
			}
		case "id":
			if err := json.Unmarshal([]byte(v), &strct.Id); err != nil {
				return err
			}
		case "plate":
			if err := json.Unmarshal([]byte(v), &strct.Plate); err != nil {
				return err
			}
		default:
			return fmt.Errorf("additional property not allowed: \"" + k + "\"")
		}
	}
	return nil
}

func (strct *CarsItems) MarshalJSON() ([]byte, error) {
	buf := bytes.NewBuffer(make([]byte, 0))
	buf.WriteString("{")
	comma := false
	// Marshal the "id" field
	if strct.Id != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"id\": ")
		if tmp, err := json.Marshal(strct.Id); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "model" field
	if strct.Model != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"model\": ")
		if tmp, err := json.Marshal(strct.Model); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "plate" field
	if strct.Plate != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"plate\": ")
		if tmp, err := json.Marshal(strct.Plate); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}

	buf.WriteString("}")
	rv := buf.Bytes()
	return rv, nil
}

func (strct *CarsItems) UnmarshalJSON(b []byte) error {
	var jsonMap map[string]json.RawMessage
	if err := json.Unmarshal(b, &jsonMap); err != nil {
		return err
	}
	// parse all the defined properties
	for k, v := range jsonMap {
		switch k {
		case "id":
			if err := json.Unmarshal([]byte(v), &strct.Id); err != nil {
				return err
			}
		case "model":
			if err := json.Unmarshal([]byte(v), &strct.Model); err != nil {
				return err
			}
		case "plate":
			if err := json.Unmarshal([]byte(v), &strct.Plate); err != nil {
				return err
			}
		default:
			return fmt.Errorf("additional property not allowed: \"" + k + "\"")
		}
	}
	return nil
}

func (strct *City) MarshalJSON() ([]byte, error) {
	buf := bytes.NewBuffer(make([]byte, 0))
	buf.WriteString("{")
	comma := false
	// Marshal the "country" field
	if strct.Country != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"country\": ")
		if tmp, err := json.Marshal(strct.Country); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "created_at" field
	if strct.CreatedAt != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"created_at\": ")
		if tmp, err := json.Marshal(strct.CreatedAt); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "id" field
	if strct.Id != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"id\": ")
		if tmp, err := json.Marshal(strct.Id); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "is_deleted" field
	if strct.IsDeleted != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"is_deleted\": ")
		if tmp, err := json.Marshal(strct.IsDeleted); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "name" field
	if strct.Name != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"name\": ")
		if tmp, err := json.Marshal(strct.Name); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}

	buf.WriteString("}")
	rv := buf.Bytes()
	return rv, nil
}

func (strct *City) UnmarshalJSON(b []byte) error {
	var jsonMap map[string]json.RawMessage
	if err := json.Unmarshal(b, &jsonMap); err != nil {
		return err
	}
	// parse all the defined properties
	for k, v := range jsonMap {
		switch k {
		case "country":
			if err := json.Unmarshal([]byte(v), &strct.Country); err != nil {
				return err
			}
		case "created_at":
			if err := json.Unmarshal([]byte(v), &strct.CreatedAt); err != nil {
				return err
			}
		case "id":
			if err := json.Unmarshal([]byte(v), &strct.Id); err != nil {
				return err
			}
		case "is_deleted":
			if err := json.Unmarshal([]byte(v), &strct.IsDeleted); err != nil {
				return err
			}
		case "name":
			if err := json.Unmarshal([]byte(v), &strct.Name); err != nil {
				return err
			}
		default:
			return fmt.Errorf("additional property not allowed: \"" + k + "\"")
		}
	}
	return nil
}

func (strct *Contacts) MarshalJSON() ([]byte, error) {
	buf := bytes.NewBuffer(make([]byte, 0))
	buf.WriteString("{")
	comma := false
	// Marshal the "maillists" field
	if strct.Maillists != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"maillists\": ")
		if tmp, err := json.Marshal(strct.Maillists); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "wiki" field
	if strct.Wiki != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"wiki\": ")
		if tmp, err := json.Marshal(strct.Wiki); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}

	buf.WriteString("}")
	rv := buf.Bytes()
	return rv, nil
}

func (strct *Contacts) UnmarshalJSON(b []byte) error {
	var jsonMap map[string]json.RawMessage
	if err := json.Unmarshal(b, &jsonMap); err != nil {
		return err
	}
	// parse all the defined properties
	for k, v := range jsonMap {
		switch k {
		case "maillists":
			if err := json.Unmarshal([]byte(v), &strct.Maillists); err != nil {
				return err
			}
		case "wiki":
			if err := json.Unmarshal([]byte(v), &strct.Wiki); err != nil {
				return err
			}
		default:
			return fmt.Errorf("additional property not allowed: \"" + k + "\"")
		}
	}
	return nil
}

func (strct *ContactsItems) MarshalJSON() ([]byte, error) {
	buf := bytes.NewBuffer(make([]byte, 0))
	buf.WriteString("{")
	comma := false
	// Marshal the "type" field
	if strct.Type != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"type\": ")
		if tmp, err := json.Marshal(strct.Type); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "value" field
	if strct.Value != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"value\": ")
		if tmp, err := json.Marshal(strct.Value); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}

	buf.WriteString("}")
	rv := buf.Bytes()
	return rv, nil
}

func (strct *ContactsItems) UnmarshalJSON(b []byte) error {
	var jsonMap map[string]json.RawMessage
	if err := json.Unmarshal(b, &jsonMap); err != nil {
		return err
	}
	// parse all the defined properties
	for k, v := range jsonMap {
		switch k {
		case "type":
			if err := json.Unmarshal([]byte(v), &strct.Type); err != nil {
				return err
			}
		case "value":
			if err := json.Unmarshal([]byte(v), &strct.Value); err != nil {
				return err
			}
		default:
			return fmt.Errorf("additional property not allowed: \"" + k + "\"")
		}
	}
	return nil
}

func (strct *Country) MarshalJSON() ([]byte, error) {
	buf := bytes.NewBuffer(make([]byte, 0))
	buf.WriteString("{")
	comma := false
	// Marshal the "code" field
	if strct.Code != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"code\": ")
		if tmp, err := json.Marshal(strct.Code); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "created_at" field
	if strct.CreatedAt != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"created_at\": ")
		if tmp, err := json.Marshal(strct.CreatedAt); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "domain" field
	if strct.Domain != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"domain\": ")
		if tmp, err := json.Marshal(strct.Domain); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "geobase" field
	if strct.Geobase != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"geobase\": ")
		if tmp, err := json.Marshal(strct.Geobase); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "id" field
	if strct.Id != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"id\": ")
		if tmp, err := json.Marshal(strct.Id); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "is_deleted" field
	if strct.IsDeleted != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"is_deleted\": ")
		if tmp, err := json.Marshal(strct.IsDeleted); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "name" field
	if strct.Name != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"name\": ")
		if tmp, err := json.Marshal(strct.Name); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}

	buf.WriteString("}")
	rv := buf.Bytes()
	return rv, nil
}

func (strct *Country) UnmarshalJSON(b []byte) error {
	var jsonMap map[string]json.RawMessage
	if err := json.Unmarshal(b, &jsonMap); err != nil {
		return err
	}
	// parse all the defined properties
	for k, v := range jsonMap {
		switch k {
		case "code":
			if err := json.Unmarshal([]byte(v), &strct.Code); err != nil {
				return err
			}
		case "created_at":
			if err := json.Unmarshal([]byte(v), &strct.CreatedAt); err != nil {
				return err
			}
		case "domain":
			if err := json.Unmarshal([]byte(v), &strct.Domain); err != nil {
				return err
			}
		case "geobase":
			if err := json.Unmarshal([]byte(v), &strct.Geobase); err != nil {
				return err
			}
		case "id":
			if err := json.Unmarshal([]byte(v), &strct.Id); err != nil {
				return err
			}
		case "is_deleted":
			if err := json.Unmarshal([]byte(v), &strct.IsDeleted); err != nil {
				return err
			}
		case "name":
			if err := json.Unmarshal([]byte(v), &strct.Name); err != nil {
				return err
			}
		default:
			return fmt.Errorf("additional property not allowed: \"" + k + "\"")
		}
	}
	return nil
}

func (strct *Department) MarshalJSON() ([]byte, error) {
	buf := bytes.NewBuffer(make([]byte, 0))
	buf.WriteString("{")
	comma := false
	// Marshal the "contacts" field
	if strct.Contacts != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"contacts\": ")
		if tmp, err := json.Marshal(strct.Contacts); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "description" field
	if strct.Description != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"description\": ")
		if tmp, err := json.Marshal(strct.Description); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "heads" field
	if strct.Heads != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"heads\": ")
		if tmp, err := json.Marshal(strct.Heads); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "id" field
	if strct.Id != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"id\": ")
		if tmp, err := json.Marshal(strct.Id); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "is_deleted" field
	if strct.IsDeleted != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"is_deleted\": ")
		if tmp, err := json.Marshal(strct.IsDeleted); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "kind" field
	if strct.Kind != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"kind\": ")
		if tmp, err := json.Marshal(strct.Kind); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "level" field
	if strct.Level != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"level\": ")
		if tmp, err := json.Marshal(strct.Level); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "name" field
	if strct.Name != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"name\": ")
		if tmp, err := json.Marshal(strct.Name); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "url" field
	if strct.Url != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"url\": ")
		if tmp, err := json.Marshal(strct.Url); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}

	buf.WriteString("}")
	rv := buf.Bytes()
	return rv, nil
}

func (strct *Department) UnmarshalJSON(b []byte) error {
	var jsonMap map[string]json.RawMessage
	if err := json.Unmarshal(b, &jsonMap); err != nil {
		return err
	}
	// parse all the defined properties
	for k, v := range jsonMap {
		switch k {
		case "contacts":
			if err := json.Unmarshal([]byte(v), &strct.Contacts); err != nil {
				return err
			}
		case "description":
			if err := json.Unmarshal([]byte(v), &strct.Description); err != nil {
				return err
			}
		case "heads":
			if err := json.Unmarshal([]byte(v), &strct.Heads); err != nil {
				return err
			}
		case "id":
			if err := json.Unmarshal([]byte(v), &strct.Id); err != nil {
				return err
			}
		case "is_deleted":
			if err := json.Unmarshal([]byte(v), &strct.IsDeleted); err != nil {
				return err
			}
		case "kind":
			if err := json.Unmarshal([]byte(v), &strct.Kind); err != nil {
				return err
			}
		case "level":
			if err := json.Unmarshal([]byte(v), &strct.Level); err != nil {
				return err
			}
		case "name":
			if err := json.Unmarshal([]byte(v), &strct.Name); err != nil {
				return err
			}
		case "url":
			if err := json.Unmarshal([]byte(v), &strct.Url); err != nil {
				return err
			}
		default:
			return fmt.Errorf("additional property not allowed: \"" + k + "\"")
		}
	}
	return nil
}

func (strct *Departmentstaff) MarshalJSON() ([]byte, error) {
	buf := bytes.NewBuffer(make([]byte, 0))
	buf.WriteString("{")
	comma := false
	// Marshal the "department_group" field
	if strct.DepartmentGroup != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"department_group\": ")
		if tmp, err := json.Marshal(strct.DepartmentGroup); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "id" field
	if strct.Id != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"id\": ")
		if tmp, err := json.Marshal(strct.Id); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "_meta" field
	if strct.Meta != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"_meta\": ")
		if tmp, err := json.Marshal(strct.Meta); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "person" field
	if strct.Person != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"person\": ")
		if tmp, err := json.Marshal(strct.Person); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "role" field
	if strct.Role != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"role\": ")
		if tmp, err := json.Marshal(strct.Role); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}

	buf.WriteString("}")
	rv := buf.Bytes()
	return rv, nil
}

func (strct *Departmentstaff) UnmarshalJSON(b []byte) error {
	var jsonMap map[string]json.RawMessage
	if err := json.Unmarshal(b, &jsonMap); err != nil {
		return err
	}
	// parse all the defined properties
	for k, v := range jsonMap {
		switch k {
		case "department_group":
			if err := json.Unmarshal([]byte(v), &strct.DepartmentGroup); err != nil {
				return err
			}
		case "id":
			if err := json.Unmarshal([]byte(v), &strct.Id); err != nil {
				return err
			}
		case "_meta":
			if err := json.Unmarshal([]byte(v), &strct.Meta); err != nil {
				return err
			}
		case "person":
			if err := json.Unmarshal([]byte(v), &strct.Person); err != nil {
				return err
			}
		case "role":
			if err := json.Unmarshal([]byte(v), &strct.Role); err != nil {
				return err
			}
		default:
			return fmt.Errorf("additional property not allowed: \"" + k + "\"")
		}
	}
	return nil
}

func (strct *Education) MarshalJSON() ([]byte, error) {
	buf := bytes.NewBuffer(make([]byte, 0))
	buf.WriteString("{")
	comma := false
	// Marshal the "area" field
	if strct.Area != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"area\": ")
		if tmp, err := json.Marshal(strct.Area); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "date" field
	if strct.Date != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"date\": ")
		if tmp, err := json.Marshal(strct.Date); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "place" field
	if strct.Place != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"place\": ")
		if tmp, err := json.Marshal(strct.Place); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "status" field
	if strct.Status != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"status\": ")
		if tmp, err := json.Marshal(strct.Status); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}

	buf.WriteString("}")
	rv := buf.Bytes()
	return rv, nil
}

func (strct *Education) UnmarshalJSON(b []byte) error {
	var jsonMap map[string]json.RawMessage
	if err := json.Unmarshal(b, &jsonMap); err != nil {
		return err
	}
	// parse all the defined properties
	for k, v := range jsonMap {
		switch k {
		case "area":
			if err := json.Unmarshal([]byte(v), &strct.Area); err != nil {
				return err
			}
		case "date":
			if err := json.Unmarshal([]byte(v), &strct.Date); err != nil {
				return err
			}
		case "place":
			if err := json.Unmarshal([]byte(v), &strct.Place); err != nil {
				return err
			}
		case "status":
			if err := json.Unmarshal([]byte(v), &strct.Status); err != nil {
				return err
			}
		default:
			return fmt.Errorf("additional property not allowed: \"" + k + "\"")
		}
	}
	return nil
}

func (strct *EmailsItems) MarshalJSON() ([]byte, error) {
	buf := bytes.NewBuffer(make([]byte, 0))
	buf.WriteString("{")
	comma := false
	// Marshal the "address" field
	if strct.Address != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"address\": ")
		if tmp, err := json.Marshal(strct.Address); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "id" field
	if strct.Id != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"id\": ")
		if tmp, err := json.Marshal(strct.Id); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "source_type" field
	if strct.SourceType != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"source_type\": ")
		if tmp, err := json.Marshal(strct.SourceType); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}

	buf.WriteString("}")
	rv := buf.Bytes()
	return rv, nil
}

func (strct *EmailsItems) UnmarshalJSON(b []byte) error {
	var jsonMap map[string]json.RawMessage
	if err := json.Unmarshal(b, &jsonMap); err != nil {
		return err
	}
	// parse all the defined properties
	for k, v := range jsonMap {
		switch k {
		case "address":
			if err := json.Unmarshal([]byte(v), &strct.Address); err != nil {
				return err
			}
		case "id":
			if err := json.Unmarshal([]byte(v), &strct.Id); err != nil {
				return err
			}
		case "source_type":
			if err := json.Unmarshal([]byte(v), &strct.SourceType); err != nil {
				return err
			}
		default:
			return fmt.Errorf("additional property not allowed: \"" + k + "\"")
		}
	}
	return nil
}

func (strct *Environment) MarshalJSON() ([]byte, error) {
	buf := bytes.NewBuffer(make([]byte, 0))
	buf.WriteString("{")
	comma := false
	// Marshal the "shell" field
	if strct.Shell != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"shell\": ")
		if tmp, err := json.Marshal(strct.Shell); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "timezone" field
	if strct.Timezone != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"timezone\": ")
		if tmp, err := json.Marshal(strct.Timezone); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}

	buf.WriteString("}")
	rv := buf.Bytes()
	return rv, nil
}

func (strct *Environment) UnmarshalJSON(b []byte) error {
	var jsonMap map[string]json.RawMessage
	if err := json.Unmarshal(b, &jsonMap); err != nil {
		return err
	}
	// parse all the defined properties
	for k, v := range jsonMap {
		switch k {
		case "shell":
			if err := json.Unmarshal([]byte(v), &strct.Shell); err != nil {
				return err
			}
		case "timezone":
			if err := json.Unmarshal([]byte(v), &strct.Timezone); err != nil {
				return err
			}
		default:
			return fmt.Errorf("additional property not allowed: \"" + k + "\"")
		}
	}
	return nil
}

func (strct *Equipment) MarshalJSON() ([]byte, error) {
	buf := bytes.NewBuffer(make([]byte, 0))
	buf.WriteString("{")
	comma := false
	// Marshal the "created_at" field
	if strct.CreatedAt != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"created_at\": ")
		if tmp, err := json.Marshal(strct.CreatedAt); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "description" field
	if strct.Description != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"description\": ")
		if tmp, err := json.Marshal(strct.Description); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "floor" field
	if strct.Floor != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"floor\": ")
		if tmp, err := json.Marshal(strct.Floor); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "hostname" field
	if strct.Hostname != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"hostname\": ")
		if tmp, err := json.Marshal(strct.Hostname); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "id" field
	if strct.Id != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"id\": ")
		if tmp, err := json.Marshal(strct.Id); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "is_deleted" field
	if strct.IsDeleted != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"is_deleted\": ")
		if tmp, err := json.Marshal(strct.IsDeleted); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "location" field
	if strct.Location != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"location\": ")
		if tmp, err := json.Marshal(strct.Location); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "_meta" field
	if strct.Meta != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"_meta\": ")
		if tmp, err := json.Marshal(strct.Meta); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "name" field
	if strct.Name != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"name\": ")
		if tmp, err := json.Marshal(strct.Name); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "type" field
	if strct.Type != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"type\": ")
		if tmp, err := json.Marshal(strct.Type); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}

	buf.WriteString("}")
	rv := buf.Bytes()
	return rv, nil
}

func (strct *Equipment) UnmarshalJSON(b []byte) error {
	var jsonMap map[string]json.RawMessage
	if err := json.Unmarshal(b, &jsonMap); err != nil {
		return err
	}
	// parse all the defined properties
	for k, v := range jsonMap {
		switch k {
		case "created_at":
			if err := json.Unmarshal([]byte(v), &strct.CreatedAt); err != nil {
				return err
			}
		case "description":
			if err := json.Unmarshal([]byte(v), &strct.Description); err != nil {
				return err
			}
		case "floor":
			if err := json.Unmarshal([]byte(v), &strct.Floor); err != nil {
				return err
			}
		case "hostname":
			if err := json.Unmarshal([]byte(v), &strct.Hostname); err != nil {
				return err
			}
		case "id":
			if err := json.Unmarshal([]byte(v), &strct.Id); err != nil {
				return err
			}
		case "is_deleted":
			if err := json.Unmarshal([]byte(v), &strct.IsDeleted); err != nil {
				return err
			}
		case "location":
			if err := json.Unmarshal([]byte(v), &strct.Location); err != nil {
				return err
			}
		case "_meta":
			if err := json.Unmarshal([]byte(v), &strct.Meta); err != nil {
				return err
			}
		case "name":
			if err := json.Unmarshal([]byte(v), &strct.Name); err != nil {
				return err
			}
		case "type":
			if err := json.Unmarshal([]byte(v), &strct.Type); err != nil {
				return err
			}
		default:
			return fmt.Errorf("additional property not allowed: \"" + k + "\"")
		}
	}
	return nil
}

func (strct *Floor) MarshalJSON() ([]byte, error) {
	buf := bytes.NewBuffer(make([]byte, 0))
	buf.WriteString("{")
	comma := false
	// Marshal the "created_at" field
	if strct.CreatedAt != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"created_at\": ")
		if tmp, err := json.Marshal(strct.CreatedAt); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "id" field
	if strct.Id != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"id\": ")
		if tmp, err := json.Marshal(strct.Id); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "image" field
	if strct.Image != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"image\": ")
		if tmp, err := json.Marshal(strct.Image); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "is_deleted" field
	if strct.IsDeleted != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"is_deleted\": ")
		if tmp, err := json.Marshal(strct.IsDeleted); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "name" field
	if strct.Name != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"name\": ")
		if tmp, err := json.Marshal(strct.Name); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "number" field
	if strct.Number != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"number\": ")
		if tmp, err := json.Marshal(strct.Number); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "office" field
	if strct.Office != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"office\": ")
		if tmp, err := json.Marshal(strct.Office); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}

	buf.WriteString("}")
	rv := buf.Bytes()
	return rv, nil
}

func (strct *Floor) UnmarshalJSON(b []byte) error {
	var jsonMap map[string]json.RawMessage
	if err := json.Unmarshal(b, &jsonMap); err != nil {
		return err
	}
	// parse all the defined properties
	for k, v := range jsonMap {
		switch k {
		case "created_at":
			if err := json.Unmarshal([]byte(v), &strct.CreatedAt); err != nil {
				return err
			}
		case "id":
			if err := json.Unmarshal([]byte(v), &strct.Id); err != nil {
				return err
			}
		case "image":
			if err := json.Unmarshal([]byte(v), &strct.Image); err != nil {
				return err
			}
		case "is_deleted":
			if err := json.Unmarshal([]byte(v), &strct.IsDeleted); err != nil {
				return err
			}
		case "name":
			if err := json.Unmarshal([]byte(v), &strct.Name); err != nil {
				return err
			}
		case "number":
			if err := json.Unmarshal([]byte(v), &strct.Number); err != nil {
				return err
			}
		case "office":
			if err := json.Unmarshal([]byte(v), &strct.Office); err != nil {
				return err
			}
		default:
			return fmt.Errorf("additional property not allowed: \"" + k + "\"")
		}
	}
	return nil
}

func (strct *Floorflatref) MarshalJSON() ([]byte, error) {
	buf := bytes.NewBuffer(make([]byte, 0))
	buf.WriteString("{")
	comma := false
	// Marshal the "id" field
	if strct.Id != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"id\": ")
		if tmp, err := json.Marshal(strct.Id); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "image" field
	if strct.Image != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"image\": ")
		if tmp, err := json.Marshal(strct.Image); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "is_deleted" field
	if strct.IsDeleted != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"is_deleted\": ")
		if tmp, err := json.Marshal(strct.IsDeleted); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "name" field
	if strct.Name != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"name\": ")
		if tmp, err := json.Marshal(strct.Name); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "number" field
	if strct.Number != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"number\": ")
		if tmp, err := json.Marshal(strct.Number); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}

	buf.WriteString("}")
	rv := buf.Bytes()
	return rv, nil
}

func (strct *Floorflatref) UnmarshalJSON(b []byte) error {
	var jsonMap map[string]json.RawMessage
	if err := json.Unmarshal(b, &jsonMap); err != nil {
		return err
	}
	// parse all the defined properties
	for k, v := range jsonMap {
		switch k {
		case "id":
			if err := json.Unmarshal([]byte(v), &strct.Id); err != nil {
				return err
			}
		case "image":
			if err := json.Unmarshal([]byte(v), &strct.Image); err != nil {
				return err
			}
		case "is_deleted":
			if err := json.Unmarshal([]byte(v), &strct.IsDeleted); err != nil {
				return err
			}
		case "name":
			if err := json.Unmarshal([]byte(v), &strct.Name); err != nil {
				return err
			}
		case "number":
			if err := json.Unmarshal([]byte(v), &strct.Number); err != nil {
				return err
			}
		default:
			return fmt.Errorf("additional property not allowed: \"" + k + "\"")
		}
	}
	return nil
}

func (strct *Floorref) MarshalJSON() ([]byte, error) {
	buf := bytes.NewBuffer(make([]byte, 0))
	buf.WriteString("{")
	comma := false
	// Marshal the "id" field
	if strct.Id != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"id\": ")
		if tmp, err := json.Marshal(strct.Id); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "is_deleted" field
	if strct.IsDeleted != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"is_deleted\": ")
		if tmp, err := json.Marshal(strct.IsDeleted); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "name" field
	if strct.Name != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"name\": ")
		if tmp, err := json.Marshal(strct.Name); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "number" field
	if strct.Number != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"number\": ")
		if tmp, err := json.Marshal(strct.Number); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "office" field
	if strct.Office != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"office\": ")
		if tmp, err := json.Marshal(strct.Office); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}

	buf.WriteString("}")
	rv := buf.Bytes()
	return rv, nil
}

func (strct *Floorref) UnmarshalJSON(b []byte) error {
	var jsonMap map[string]json.RawMessage
	if err := json.Unmarshal(b, &jsonMap); err != nil {
		return err
	}
	// parse all the defined properties
	for k, v := range jsonMap {
		switch k {
		case "id":
			if err := json.Unmarshal([]byte(v), &strct.Id); err != nil {
				return err
			}
		case "is_deleted":
			if err := json.Unmarshal([]byte(v), &strct.IsDeleted); err != nil {
				return err
			}
		case "name":
			if err := json.Unmarshal([]byte(v), &strct.Name); err != nil {
				return err
			}
		case "number":
			if err := json.Unmarshal([]byte(v), &strct.Number); err != nil {
				return err
			}
		case "office":
			if err := json.Unmarshal([]byte(v), &strct.Office); err != nil {
				return err
			}
		default:
			return fmt.Errorf("additional property not allowed: \"" + k + "\"")
		}
	}
	return nil
}

func (strct *Geobase) MarshalJSON() ([]byte, error) {
	buf := bytes.NewBuffer(make([]byte, 0))
	buf.WriteString("{")
	comma := false
	// Marshal the "id" field
	if strct.Id != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"id\": ")
		if tmp, err := json.Marshal(strct.Id); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}

	buf.WriteString("}")
	rv := buf.Bytes()
	return rv, nil
}

func (strct *Geobase) UnmarshalJSON(b []byte) error {
	var jsonMap map[string]json.RawMessage
	if err := json.Unmarshal(b, &jsonMap); err != nil {
		return err
	}
	// parse all the defined properties
	for k, v := range jsonMap {
		switch k {
		case "id":
			if err := json.Unmarshal([]byte(v), &strct.Id); err != nil {
				return err
			}
		default:
			return fmt.Errorf("additional property not allowed: \"" + k + "\"")
		}
	}
	return nil
}

func (strct *GpgKeysItems) MarshalJSON() ([]byte, error) {
	buf := bytes.NewBuffer(make([]byte, 0))
	buf.WriteString("{")
	comma := false
	// Marshal the "description" field
	if strct.Description != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"description\": ")
		if tmp, err := json.Marshal(strct.Description); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "fingerprint" field
	if strct.Fingerprint != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"fingerprint\": ")
		if tmp, err := json.Marshal(strct.Fingerprint); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "id" field
	if strct.Id != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"id\": ")
		if tmp, err := json.Marshal(strct.Id); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "key" field
	if strct.Key != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"key\": ")
		if tmp, err := json.Marshal(strct.Key); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}

	buf.WriteString("}")
	rv := buf.Bytes()
	return rv, nil
}

func (strct *GpgKeysItems) UnmarshalJSON(b []byte) error {
	var jsonMap map[string]json.RawMessage
	if err := json.Unmarshal(b, &jsonMap); err != nil {
		return err
	}
	// parse all the defined properties
	for k, v := range jsonMap {
		switch k {
		case "description":
			if err := json.Unmarshal([]byte(v), &strct.Description); err != nil {
				return err
			}
		case "fingerprint":
			if err := json.Unmarshal([]byte(v), &strct.Fingerprint); err != nil {
				return err
			}
		case "id":
			if err := json.Unmarshal([]byte(v), &strct.Id); err != nil {
				return err
			}
		case "key":
			if err := json.Unmarshal([]byte(v), &strct.Key); err != nil {
				return err
			}
		default:
			return fmt.Errorf("additional property not allowed: \"" + k + "\"")
		}
	}
	return nil
}

func (strct *Group) MarshalJSON() ([]byte, error) {
	buf := bytes.NewBuffer(make([]byte, 0))
	buf.WriteString("{")
	comma := false
	// Marshal the "affiliation_counters" field
	if strct.AffiliationCounters != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"affiliation_counters\": ")
		if tmp, err := json.Marshal(strct.AffiliationCounters); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "ancestors" field
	if strct.Ancestors != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"ancestors\": ")
		if tmp, err := json.Marshal(strct.Ancestors); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "department" field
	if strct.Department != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"department\": ")
		if tmp, err := json.Marshal(strct.Department); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "description" field
	if strct.Description != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"description\": ")
		if tmp, err := json.Marshal(strct.Description); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "id" field
	if strct.Id != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"id\": ")
		if tmp, err := json.Marshal(strct.Id); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "is_deleted" field
	if strct.IsDeleted != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"is_deleted\": ")
		if tmp, err := json.Marshal(strct.IsDeleted); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "level" field
	if strct.Level != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"level\": ")
		if tmp, err := json.Marshal(strct.Level); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "_meta" field
	if strct.Meta != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"_meta\": ")
		if tmp, err := json.Marshal(strct.Meta); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "name" field
	if strct.Name != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"name\": ")
		if tmp, err := json.Marshal(strct.Name); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "parent" field
	if strct.Parent != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"parent\": ")
		if tmp, err := json.Marshal(strct.Parent); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "responsibles" field
	if strct.Responsibles != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"responsibles\": ")
		if tmp, err := json.Marshal(strct.Responsibles); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "role_scope" field
	if strct.RoleScope != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"role_scope\": ")
		if tmp, err := json.Marshal(strct.RoleScope); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "service" field
	if strct.Service != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"service\": ")
		if tmp, err := json.Marshal(strct.Service); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "type" field
	if strct.Type != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"type\": ")
		if tmp, err := json.Marshal(strct.Type); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "url" field
	if strct.Url != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"url\": ")
		if tmp, err := json.Marshal(strct.Url); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}

	buf.WriteString("}")
	rv := buf.Bytes()
	return rv, nil
}

func (strct *Group) UnmarshalJSON(b []byte) error {
	var jsonMap map[string]json.RawMessage
	if err := json.Unmarshal(b, &jsonMap); err != nil {
		return err
	}
	// parse all the defined properties
	for k, v := range jsonMap {
		switch k {
		case "affiliation_counters":
			if err := json.Unmarshal([]byte(v), &strct.AffiliationCounters); err != nil {
				return err
			}
		case "ancestors":
			if err := json.Unmarshal([]byte(v), &strct.Ancestors); err != nil {
				return err
			}
		case "department":
			if err := json.Unmarshal([]byte(v), &strct.Department); err != nil {
				return err
			}
		case "description":
			if err := json.Unmarshal([]byte(v), &strct.Description); err != nil {
				return err
			}
		case "id":
			if err := json.Unmarshal([]byte(v), &strct.Id); err != nil {
				return err
			}
		case "is_deleted":
			if err := json.Unmarshal([]byte(v), &strct.IsDeleted); err != nil {
				return err
			}
		case "level":
			if err := json.Unmarshal([]byte(v), &strct.Level); err != nil {
				return err
			}
		case "_meta":
			if err := json.Unmarshal([]byte(v), &strct.Meta); err != nil {
				return err
			}
		case "name":
			if err := json.Unmarshal([]byte(v), &strct.Name); err != nil {
				return err
			}
		case "parent":
			if err := json.Unmarshal([]byte(v), &strct.Parent); err != nil {
				return err
			}
		case "responsibles":
			if err := json.Unmarshal([]byte(v), &strct.Responsibles); err != nil {
				return err
			}
		case "role_scope":
			if err := json.Unmarshal([]byte(v), &strct.RoleScope); err != nil {
				return err
			}
		case "service":
			if err := json.Unmarshal([]byte(v), &strct.Service); err != nil {
				return err
			}
		case "type":
			if err := json.Unmarshal([]byte(v), &strct.Type); err != nil {
				return err
			}
		case "url":
			if err := json.Unmarshal([]byte(v), &strct.Url); err != nil {
				return err
			}
		default:
			return fmt.Errorf("additional property not allowed: \"" + k + "\"")
		}
	}
	return nil
}

func (strct *Groupmembership) MarshalJSON() ([]byte, error) {
	buf := bytes.NewBuffer(make([]byte, 0))
	buf.WriteString("{")
	comma := false
	// Marshal the "group" field
	if strct.Group != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"group\": ")
		if tmp, err := json.Marshal(strct.Group); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "id" field
	if strct.Id != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"id\": ")
		if tmp, err := json.Marshal(strct.Id); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "joined_at" field
	if strct.JoinedAt != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"joined_at\": ")
		if tmp, err := json.Marshal(strct.JoinedAt); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "_meta" field
	if strct.Meta != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"_meta\": ")
		if tmp, err := json.Marshal(strct.Meta); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "person" field
	if strct.Person != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"person\": ")
		if tmp, err := json.Marshal(strct.Person); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}

	buf.WriteString("}")
	rv := buf.Bytes()
	return rv, nil
}

func (strct *Groupmembership) UnmarshalJSON(b []byte) error {
	var jsonMap map[string]json.RawMessage
	if err := json.Unmarshal(b, &jsonMap); err != nil {
		return err
	}
	// parse all the defined properties
	for k, v := range jsonMap {
		switch k {
		case "group":
			if err := json.Unmarshal([]byte(v), &strct.Group); err != nil {
				return err
			}
		case "id":
			if err := json.Unmarshal([]byte(v), &strct.Id); err != nil {
				return err
			}
		case "joined_at":
			if err := json.Unmarshal([]byte(v), &strct.JoinedAt); err != nil {
				return err
			}
		case "_meta":
			if err := json.Unmarshal([]byte(v), &strct.Meta); err != nil {
				return err
			}
		case "person":
			if err := json.Unmarshal([]byte(v), &strct.Person); err != nil {
				return err
			}
		default:
			return fmt.Errorf("additional property not allowed: \"" + k + "\"")
		}
	}
	return nil
}

func (strct *Groupref) MarshalJSON() ([]byte, error) {
	buf := bytes.NewBuffer(make([]byte, 0))
	buf.WriteString("{")
	comma := false
	// Marshal the "affiliation_counters" field
	if strct.AffiliationCounters != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"affiliation_counters\": ")
		if tmp, err := json.Marshal(strct.AffiliationCounters); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "ancestors" field
	if strct.Ancestors != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"ancestors\": ")
		if tmp, err := json.Marshal(strct.Ancestors); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "department" field
	if strct.Department != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"department\": ")
		if tmp, err := json.Marshal(strct.Department); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "description" field
	if strct.Description != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"description\": ")
		if tmp, err := json.Marshal(strct.Description); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "id" field
	if strct.Id != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"id\": ")
		if tmp, err := json.Marshal(strct.Id); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "is_deleted" field
	if strct.IsDeleted != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"is_deleted\": ")
		if tmp, err := json.Marshal(strct.IsDeleted); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "level" field
	if strct.Level != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"level\": ")
		if tmp, err := json.Marshal(strct.Level); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "name" field
	if strct.Name != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"name\": ")
		if tmp, err := json.Marshal(strct.Name); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "parent" field
	if strct.Parent != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"parent\": ")
		if tmp, err := json.Marshal(strct.Parent); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "responsibles" field
	if strct.Responsibles != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"responsibles\": ")
		if tmp, err := json.Marshal(strct.Responsibles); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "role_scope" field
	if strct.RoleScope != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"role_scope\": ")
		if tmp, err := json.Marshal(strct.RoleScope); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "service" field
	if strct.Service != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"service\": ")
		if tmp, err := json.Marshal(strct.Service); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "type" field
	if strct.Type != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"type\": ")
		if tmp, err := json.Marshal(strct.Type); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "url" field
	if strct.Url != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"url\": ")
		if tmp, err := json.Marshal(strct.Url); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}

	buf.WriteString("}")
	rv := buf.Bytes()
	return rv, nil
}

func (strct *Groupref) UnmarshalJSON(b []byte) error {
	var jsonMap map[string]json.RawMessage
	if err := json.Unmarshal(b, &jsonMap); err != nil {
		return err
	}
	// parse all the defined properties
	for k, v := range jsonMap {
		switch k {
		case "affiliation_counters":
			if err := json.Unmarshal([]byte(v), &strct.AffiliationCounters); err != nil {
				return err
			}
		case "ancestors":
			if err := json.Unmarshal([]byte(v), &strct.Ancestors); err != nil {
				return err
			}
		case "department":
			if err := json.Unmarshal([]byte(v), &strct.Department); err != nil {
				return err
			}
		case "description":
			if err := json.Unmarshal([]byte(v), &strct.Description); err != nil {
				return err
			}
		case "id":
			if err := json.Unmarshal([]byte(v), &strct.Id); err != nil {
				return err
			}
		case "is_deleted":
			if err := json.Unmarshal([]byte(v), &strct.IsDeleted); err != nil {
				return err
			}
		case "level":
			if err := json.Unmarshal([]byte(v), &strct.Level); err != nil {
				return err
			}
		case "name":
			if err := json.Unmarshal([]byte(v), &strct.Name); err != nil {
				return err
			}
		case "parent":
			if err := json.Unmarshal([]byte(v), &strct.Parent); err != nil {
				return err
			}
		case "responsibles":
			if err := json.Unmarshal([]byte(v), &strct.Responsibles); err != nil {
				return err
			}
		case "role_scope":
			if err := json.Unmarshal([]byte(v), &strct.RoleScope); err != nil {
				return err
			}
		case "service":
			if err := json.Unmarshal([]byte(v), &strct.Service); err != nil {
				return err
			}
		case "type":
			if err := json.Unmarshal([]byte(v), &strct.Type); err != nil {
				return err
			}
		case "url":
			if err := json.Unmarshal([]byte(v), &strct.Url); err != nil {
				return err
			}
		default:
			return fmt.Errorf("additional property not allowed: \"" + k + "\"")
		}
	}
	return nil
}

func (strct *Grouprefnested) MarshalJSON() ([]byte, error) {
	buf := bytes.NewBuffer(make([]byte, 0))
	buf.WriteString("{")
	comma := false
	// Marshal the "affiliation_counters" field
	if strct.AffiliationCounters != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"affiliation_counters\": ")
		if tmp, err := json.Marshal(strct.AffiliationCounters); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "department" field
	if strct.Department != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"department\": ")
		if tmp, err := json.Marshal(strct.Department); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "description" field
	if strct.Description != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"description\": ")
		if tmp, err := json.Marshal(strct.Description); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "id" field
	if strct.Id != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"id\": ")
		if tmp, err := json.Marshal(strct.Id); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "is_deleted" field
	if strct.IsDeleted != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"is_deleted\": ")
		if tmp, err := json.Marshal(strct.IsDeleted); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "level" field
	if strct.Level != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"level\": ")
		if tmp, err := json.Marshal(strct.Level); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "name" field
	if strct.Name != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"name\": ")
		if tmp, err := json.Marshal(strct.Name); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "responsibles" field
	if strct.Responsibles != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"responsibles\": ")
		if tmp, err := json.Marshal(strct.Responsibles); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "role_scope" field
	if strct.RoleScope != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"role_scope\": ")
		if tmp, err := json.Marshal(strct.RoleScope); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "service" field
	if strct.Service != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"service\": ")
		if tmp, err := json.Marshal(strct.Service); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "type" field
	if strct.Type != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"type\": ")
		if tmp, err := json.Marshal(strct.Type); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "url" field
	if strct.Url != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"url\": ")
		if tmp, err := json.Marshal(strct.Url); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}

	buf.WriteString("}")
	rv := buf.Bytes()
	return rv, nil
}

func (strct *Grouprefnested) UnmarshalJSON(b []byte) error {
	var jsonMap map[string]json.RawMessage
	if err := json.Unmarshal(b, &jsonMap); err != nil {
		return err
	}
	// parse all the defined properties
	for k, v := range jsonMap {
		switch k {
		case "affiliation_counters":
			if err := json.Unmarshal([]byte(v), &strct.AffiliationCounters); err != nil {
				return err
			}
		case "department":
			if err := json.Unmarshal([]byte(v), &strct.Department); err != nil {
				return err
			}
		case "description":
			if err := json.Unmarshal([]byte(v), &strct.Description); err != nil {
				return err
			}
		case "id":
			if err := json.Unmarshal([]byte(v), &strct.Id); err != nil {
				return err
			}
		case "is_deleted":
			if err := json.Unmarshal([]byte(v), &strct.IsDeleted); err != nil {
				return err
			}
		case "level":
			if err := json.Unmarshal([]byte(v), &strct.Level); err != nil {
				return err
			}
		case "name":
			if err := json.Unmarshal([]byte(v), &strct.Name); err != nil {
				return err
			}
		case "responsibles":
			if err := json.Unmarshal([]byte(v), &strct.Responsibles); err != nil {
				return err
			}
		case "role_scope":
			if err := json.Unmarshal([]byte(v), &strct.RoleScope); err != nil {
				return err
			}
		case "service":
			if err := json.Unmarshal([]byte(v), &strct.Service); err != nil {
				return err
			}
		case "type":
			if err := json.Unmarshal([]byte(v), &strct.Type); err != nil {
				return err
			}
		case "url":
			if err := json.Unmarshal([]byte(v), &strct.Url); err != nil {
				return err
			}
		default:
			return fmt.Errorf("additional property not allowed: \"" + k + "\"")
		}
	}
	return nil
}

func (strct *GroupsItems) MarshalJSON() ([]byte, error) {
	buf := bytes.NewBuffer(make([]byte, 0))
	buf.WriteString("{")
	comma := false
	// Marshal the "group" field
	if strct.Group != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"group\": ")
		if tmp, err := json.Marshal(strct.Group); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "id" field
	if strct.Id != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"id\": ")
		if tmp, err := json.Marshal(strct.Id); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "joined_at" field
	if strct.JoinedAt != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"joined_at\": ")
		if tmp, err := json.Marshal(strct.JoinedAt); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}

	buf.WriteString("}")
	rv := buf.Bytes()
	return rv, nil
}

func (strct *GroupsItems) UnmarshalJSON(b []byte) error {
	var jsonMap map[string]json.RawMessage
	if err := json.Unmarshal(b, &jsonMap); err != nil {
		return err
	}
	// parse all the defined properties
	for k, v := range jsonMap {
		switch k {
		case "group":
			if err := json.Unmarshal([]byte(v), &strct.Group); err != nil {
				return err
			}
		case "id":
			if err := json.Unmarshal([]byte(v), &strct.Id); err != nil {
				return err
			}
		case "joined_at":
			if err := json.Unmarshal([]byte(v), &strct.JoinedAt); err != nil {
				return err
			}
		default:
			return fmt.Errorf("additional property not allowed: \"" + k + "\"")
		}
	}
	return nil
}

func (strct *Groupshortref) MarshalJSON() ([]byte, error) {
	buf := bytes.NewBuffer(make([]byte, 0))
	buf.WriteString("{")
	comma := false
	// Marshal the "department" field
	if strct.Department != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"department\": ")
		if tmp, err := json.Marshal(strct.Department); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "id" field
	if strct.Id != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"id\": ")
		if tmp, err := json.Marshal(strct.Id); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "is_deleted" field
	if strct.IsDeleted != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"is_deleted\": ")
		if tmp, err := json.Marshal(strct.IsDeleted); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "level" field
	if strct.Level != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"level\": ")
		if tmp, err := json.Marshal(strct.Level); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "name" field
	if strct.Name != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"name\": ")
		if tmp, err := json.Marshal(strct.Name); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "role_scope" field
	if strct.RoleScope != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"role_scope\": ")
		if tmp, err := json.Marshal(strct.RoleScope); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "service" field
	if strct.Service != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"service\": ")
		if tmp, err := json.Marshal(strct.Service); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "type" field
	if strct.Type != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"type\": ")
		if tmp, err := json.Marshal(strct.Type); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "url" field
	if strct.Url != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"url\": ")
		if tmp, err := json.Marshal(strct.Url); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}

	buf.WriteString("}")
	rv := buf.Bytes()
	return rv, nil
}

func (strct *Groupshortref) UnmarshalJSON(b []byte) error {
	var jsonMap map[string]json.RawMessage
	if err := json.Unmarshal(b, &jsonMap); err != nil {
		return err
	}
	// parse all the defined properties
	for k, v := range jsonMap {
		switch k {
		case "department":
			if err := json.Unmarshal([]byte(v), &strct.Department); err != nil {
				return err
			}
		case "id":
			if err := json.Unmarshal([]byte(v), &strct.Id); err != nil {
				return err
			}
		case "is_deleted":
			if err := json.Unmarshal([]byte(v), &strct.IsDeleted); err != nil {
				return err
			}
		case "level":
			if err := json.Unmarshal([]byte(v), &strct.Level); err != nil {
				return err
			}
		case "name":
			if err := json.Unmarshal([]byte(v), &strct.Name); err != nil {
				return err
			}
		case "role_scope":
			if err := json.Unmarshal([]byte(v), &strct.RoleScope); err != nil {
				return err
			}
		case "service":
			if err := json.Unmarshal([]byte(v), &strct.Service); err != nil {
				return err
			}
		case "type":
			if err := json.Unmarshal([]byte(v), &strct.Type); err != nil {
				return err
			}
		case "url":
			if err := json.Unmarshal([]byte(v), &strct.Url); err != nil {
				return err
			}
		default:
			return fmt.Errorf("additional property not allowed: \"" + k + "\"")
		}
	}
	return nil
}

func (strct *HeadsItems) MarshalJSON() ([]byte, error) {
	buf := bytes.NewBuffer(make([]byte, 0))
	buf.WriteString("{")
	comma := false
	// Marshal the "id" field
	if strct.Id != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"id\": ")
		if tmp, err := json.Marshal(strct.Id); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "person" field
	if strct.Person != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"person\": ")
		if tmp, err := json.Marshal(strct.Person); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "role" field
	if strct.Role != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"role\": ")
		if tmp, err := json.Marshal(strct.Role); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}

	buf.WriteString("}")
	rv := buf.Bytes()
	return rv, nil
}

func (strct *HeadsItems) UnmarshalJSON(b []byte) error {
	var jsonMap map[string]json.RawMessage
	if err := json.Unmarshal(b, &jsonMap); err != nil {
		return err
	}
	// parse all the defined properties
	for k, v := range jsonMap {
		switch k {
		case "id":
			if err := json.Unmarshal([]byte(v), &strct.Id); err != nil {
				return err
			}
		case "person":
			if err := json.Unmarshal([]byte(v), &strct.Person); err != nil {
				return err
			}
		case "role":
			if err := json.Unmarshal([]byte(v), &strct.Role); err != nil {
				return err
			}
		default:
			return fmt.Errorf("additional property not allowed: \"" + k + "\"")
		}
	}
	return nil
}

func (strct *Images) MarshalJSON() ([]byte, error) {
	buf := bytes.NewBuffer(make([]byte, 0))
	buf.WriteString("{")
	comma := false
	// Marshal the "avatar" field
	if strct.Avatar != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"avatar\": ")
		if tmp, err := json.Marshal(strct.Avatar); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "photo" field
	if strct.Photo != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"photo\": ")
		if tmp, err := json.Marshal(strct.Photo); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}

	buf.WriteString("}")
	rv := buf.Bytes()
	return rv, nil
}

func (strct *Images) UnmarshalJSON(b []byte) error {
	var jsonMap map[string]json.RawMessage
	if err := json.Unmarshal(b, &jsonMap); err != nil {
		return err
	}
	// parse all the defined properties
	for k, v := range jsonMap {
		switch k {
		case "avatar":
			if err := json.Unmarshal([]byte(v), &strct.Avatar); err != nil {
				return err
			}
		case "photo":
			if err := json.Unmarshal([]byte(v), &strct.Photo); err != nil {
				return err
			}
		default:
			return fmt.Errorf("additional property not allowed: \"" + k + "\"")
		}
	}
	return nil
}

func (strct *KeysItems) MarshalJSON() ([]byte, error) {
	buf := bytes.NewBuffer(make([]byte, 0))
	buf.WriteString("{")
	comma := false
	// Marshal the "description" field
	if strct.Description != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"description\": ")
		if tmp, err := json.Marshal(strct.Description); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "fingerprint" field
	if strct.Fingerprint != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"fingerprint\": ")
		if tmp, err := json.Marshal(strct.Fingerprint); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "fingerprint_sha256" field
	if strct.FingerprintSha256 != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"fingerprint_sha256\": ")
		if tmp, err := json.Marshal(strct.FingerprintSha256); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "id" field
	if strct.Id != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"id\": ")
		if tmp, err := json.Marshal(strct.Id); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "key" field
	if strct.Key != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"key\": ")
		if tmp, err := json.Marshal(strct.Key); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}

	buf.WriteString("}")
	rv := buf.Bytes()
	return rv, nil
}

func (strct *KeysItems) UnmarshalJSON(b []byte) error {
	var jsonMap map[string]json.RawMessage
	if err := json.Unmarshal(b, &jsonMap); err != nil {
		return err
	}
	// parse all the defined properties
	for k, v := range jsonMap {
		switch k {
		case "description":
			if err := json.Unmarshal([]byte(v), &strct.Description); err != nil {
				return err
			}
		case "fingerprint":
			if err := json.Unmarshal([]byte(v), &strct.Fingerprint); err != nil {
				return err
			}
		case "fingerprint_sha256":
			if err := json.Unmarshal([]byte(v), &strct.FingerprintSha256); err != nil {
				return err
			}
		case "id":
			if err := json.Unmarshal([]byte(v), &strct.Id); err != nil {
				return err
			}
		case "key":
			if err := json.Unmarshal([]byte(v), &strct.Key); err != nil {
				return err
			}
		default:
			return fmt.Errorf("additional property not allowed: \"" + k + "\"")
		}
	}
	return nil
}

func (strct *Kind_object) MarshalJSON() ([]byte, error) {
	buf := bytes.NewBuffer(make([]byte, 0))
	buf.WriteString("{")
	comma := false
	// Marshal the "id" field
	if strct.Id != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"id\": ")
		if tmp, err := json.Marshal(strct.Id); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "name" field
	if strct.Name != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"name\": ")
		if tmp, err := json.Marshal(strct.Name); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "slug" field
	if strct.Slug != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"slug\": ")
		if tmp, err := json.Marshal(strct.Slug); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}

	buf.WriteString("}")
	rv := buf.Bytes()
	return rv, nil
}

func (strct *Kind_object) UnmarshalJSON(b []byte) error {
	var jsonMap map[string]json.RawMessage
	if err := json.Unmarshal(b, &jsonMap); err != nil {
		return err
	}
	// parse all the defined properties
	for k, v := range jsonMap {
		switch k {
		case "id":
			if err := json.Unmarshal([]byte(v), &strct.Id); err != nil {
				return err
			}
		case "name":
			if err := json.Unmarshal([]byte(v), &strct.Name); err != nil {
				return err
			}
		case "slug":
			if err := json.Unmarshal([]byte(v), &strct.Slug); err != nil {
				return err
			}
		default:
			return fmt.Errorf("additional property not allowed: \"" + k + "\"")
		}
	}
	return nil
}

func (strct *LangPair) MarshalJSON() ([]byte, error) {
	buf := bytes.NewBuffer(make([]byte, 0))
	buf.WriteString("{")
	comma := false
	// Marshal the "en" field
	if strct.En != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"en\": ")
		if tmp, err := json.Marshal(strct.En); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "ru" field
	if strct.Ru != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"ru\": ")
		if tmp, err := json.Marshal(strct.Ru); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}

	buf.WriteString("}")
	rv := buf.Bytes()
	return rv, nil
}

func (strct *LangPair) UnmarshalJSON(b []byte) error {
	var jsonMap map[string]json.RawMessage
	if err := json.Unmarshal(b, &jsonMap); err != nil {
		return err
	}
	// parse all the defined properties
	for k, v := range jsonMap {
		switch k {
		case "en":
			if err := json.Unmarshal([]byte(v), &strct.En); err != nil {
				return err
			}
		case "ru":
			if err := json.Unmarshal([]byte(v), &strct.Ru); err != nil {
				return err
			}
		default:
			return fmt.Errorf("additional property not allowed: \"" + k + "\"")
		}
	}
	return nil
}

func (strct *Language) MarshalJSON() ([]byte, error) {
	buf := bytes.NewBuffer(make([]byte, 0))
	buf.WriteString("{")
	comma := false
	// Marshal the "auto_translate" field
	if strct.AutoTranslate != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"auto_translate\": ")
		if tmp, err := json.Marshal(strct.AutoTranslate); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "content" field
	if strct.Content != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"content\": ")
		if tmp, err := json.Marshal(strct.Content); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "native" field
	if strct.Native != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"native\": ")
		if tmp, err := json.Marshal(strct.Native); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "ui" field
	if strct.Ui != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"ui\": ")
		if tmp, err := json.Marshal(strct.Ui); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}

	buf.WriteString("}")
	rv := buf.Bytes()
	return rv, nil
}

func (strct *Language) UnmarshalJSON(b []byte) error {
	var jsonMap map[string]json.RawMessage
	if err := json.Unmarshal(b, &jsonMap); err != nil {
		return err
	}
	// parse all the defined properties
	for k, v := range jsonMap {
		switch k {
		case "auto_translate":
			if err := json.Unmarshal([]byte(v), &strct.AutoTranslate); err != nil {
				return err
			}
		case "content":
			if err := json.Unmarshal([]byte(v), &strct.Content); err != nil {
				return err
			}
		case "native":
			if err := json.Unmarshal([]byte(v), &strct.Native); err != nil {
				return err
			}
		case "ui":
			if err := json.Unmarshal([]byte(v), &strct.Ui); err != nil {
				return err
			}
		default:
			return fmt.Errorf("additional property not allowed: \"" + k + "\"")
		}
	}
	return nil
}

func (strct *Location) MarshalJSON() ([]byte, error) {
	buf := bytes.NewBuffer(make([]byte, 0))
	buf.WriteString("{")
	comma := false
	// Marshal the "x" field
	if strct.X != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"x\": ")
		if tmp, err := json.Marshal(strct.X); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "y" field
	if strct.Y != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"y\": ")
		if tmp, err := json.Marshal(strct.Y); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}

	buf.WriteString("}")
	rv := buf.Bytes()
	return rv, nil
}

func (strct *Location) UnmarshalJSON(b []byte) error {
	var jsonMap map[string]json.RawMessage
	if err := json.Unmarshal(b, &jsonMap); err != nil {
		return err
	}
	// parse all the defined properties
	for k, v := range jsonMap {
		switch k {
		case "x":
			if err := json.Unmarshal([]byte(v), &strct.X); err != nil {
				return err
			}
		case "y":
			if err := json.Unmarshal([]byte(v), &strct.Y); err != nil {
				return err
			}
		default:
			return fmt.Errorf("additional property not allowed: \"" + k + "\"")
		}
	}
	return nil
}

func (strct *Memorial_object) MarshalJSON() ([]byte, error) {
	buf := bytes.NewBuffer(make([]byte, 0))
	buf.WriteString("{")
	comma := false
	// Marshal the "death_date" field
	if strct.DeathDate != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"death_date\": ")
		if tmp, err := json.Marshal(strct.DeathDate); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "id" field
	if strct.Id != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"id\": ")
		if tmp, err := json.Marshal(strct.Id); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}

	buf.WriteString("}")
	rv := buf.Bytes()
	return rv, nil
}

func (strct *Memorial_object) UnmarshalJSON(b []byte) error {
	var jsonMap map[string]json.RawMessage
	if err := json.Unmarshal(b, &jsonMap); err != nil {
		return err
	}
	// parse all the defined properties
	for k, v := range jsonMap {
		switch k {
		case "death_date":
			if err := json.Unmarshal([]byte(v), &strct.DeathDate); err != nil {
				return err
			}
		case "id":
			if err := json.Unmarshal([]byte(v), &strct.Id); err != nil {
				return err
			}
		default:
			return fmt.Errorf("additional property not allowed: \"" + k + "\"")
		}
	}
	return nil
}

func (strct *Meta) MarshalJSON() ([]byte, error) {
	buf := bytes.NewBuffer(make([]byte, 0))
	buf.WriteString("{")
	comma := false
	// Marshal the "message_id" field
	if strct.MessageId != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"message_id\": ")
		if tmp, err := json.Marshal(strct.MessageId); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "modified_at" field
	if strct.ModifiedAt != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"modified_at\": ")
		if tmp, err := json.Marshal(strct.ModifiedAt); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}

	buf.WriteString("}")
	rv := buf.Bytes()
	return rv, nil
}

func (strct *Meta) UnmarshalJSON(b []byte) error {
	var jsonMap map[string]json.RawMessage
	if err := json.Unmarshal(b, &jsonMap); err != nil {
		return err
	}
	// parse all the defined properties
	for k, v := range jsonMap {
		switch k {
		case "message_id":
			if err := json.Unmarshal([]byte(v), &strct.MessageId); err != nil {
				return err
			}
		case "modified_at":
			if err := json.Unmarshal([]byte(v), &strct.ModifiedAt); err != nil {
				return err
			}
		default:
			return fmt.Errorf("additional property not allowed: \"" + k + "\"")
		}
	}
	return nil
}

func (strct *Name) MarshalJSON() ([]byte, error) {
	buf := bytes.NewBuffer(make([]byte, 0))
	buf.WriteString("{")
	comma := false
	// Marshal the "first" field
	if strct.First != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"first\": ")
		if tmp, err := json.Marshal(strct.First); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "has_namesake" field
	if strct.HasNamesake != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"has_namesake\": ")
		if tmp, err := json.Marshal(strct.HasNamesake); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "hidden_middle" field
	if strct.HiddenMiddle != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"hidden_middle\": ")
		if tmp, err := json.Marshal(strct.HiddenMiddle); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "last" field
	if strct.Last != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"last\": ")
		if tmp, err := json.Marshal(strct.Last); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "middle" field
	if strct.Middle != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"middle\": ")
		if tmp, err := json.Marshal(strct.Middle); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}

	buf.WriteString("}")
	rv := buf.Bytes()
	return rv, nil
}

func (strct *Name) UnmarshalJSON(b []byte) error {
	var jsonMap map[string]json.RawMessage
	if err := json.Unmarshal(b, &jsonMap); err != nil {
		return err
	}
	// parse all the defined properties
	for k, v := range jsonMap {
		switch k {
		case "first":
			if err := json.Unmarshal([]byte(v), &strct.First); err != nil {
				return err
			}
		case "has_namesake":
			if err := json.Unmarshal([]byte(v), &strct.HasNamesake); err != nil {
				return err
			}
		case "hidden_middle":
			if err := json.Unmarshal([]byte(v), &strct.HiddenMiddle); err != nil {
				return err
			}
		case "last":
			if err := json.Unmarshal([]byte(v), &strct.Last); err != nil {
				return err
			}
		case "middle":
			if err := json.Unmarshal([]byte(v), &strct.Middle); err != nil {
				return err
			}
		default:
			return fmt.Errorf("additional property not allowed: \"" + k + "\"")
		}
	}
	return nil
}

func (strct *Office) MarshalJSON() ([]byte, error) {
	buf := bytes.NewBuffer(make([]byte, 0))
	buf.WriteString("{")
	comma := false
	// Marshal the "address" field
	if strct.Address != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"address\": ")
		if tmp, err := json.Marshal(strct.Address); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "city" field
	if strct.City != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"city\": ")
		if tmp, err := json.Marshal(strct.City); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "code" field
	if strct.Code != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"code\": ")
		if tmp, err := json.Marshal(strct.Code); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "contacts" field
	if strct.Contacts != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"contacts\": ")
		if tmp, err := json.Marshal(strct.Contacts); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "created_at" field
	if strct.CreatedAt != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"created_at\": ")
		if tmp, err := json.Marshal(strct.CreatedAt); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "floors" field
	if strct.Floors != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"floors\": ")
		if tmp, err := json.Marshal(strct.Floors); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "have_map" field
	if strct.HaveMap != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"have_map\": ")
		if tmp, err := json.Marshal(strct.HaveMap); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "id" field
	if strct.Id != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"id\": ")
		if tmp, err := json.Marshal(strct.Id); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "is_deleted" field
	if strct.IsDeleted != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"is_deleted\": ")
		if tmp, err := json.Marshal(strct.IsDeleted); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "is_virtual" field
	if strct.IsVirtual != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"is_virtual\": ")
		if tmp, err := json.Marshal(strct.IsVirtual); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "_meta" field
	if strct.Meta != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"_meta\": ")
		if tmp, err := json.Marshal(strct.Meta); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "name" field
	if strct.Name != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"name\": ")
		if tmp, err := json.Marshal(strct.Name); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "timezone" field
	if strct.Timezone != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"timezone\": ")
		if tmp, err := json.Marshal(strct.Timezone); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}

	buf.WriteString("}")
	rv := buf.Bytes()
	return rv, nil
}

func (strct *Office) UnmarshalJSON(b []byte) error {
	var jsonMap map[string]json.RawMessage
	if err := json.Unmarshal(b, &jsonMap); err != nil {
		return err
	}
	// parse all the defined properties
	for k, v := range jsonMap {
		switch k {
		case "address":
			if err := json.Unmarshal([]byte(v), &strct.Address); err != nil {
				return err
			}
		case "city":
			if err := json.Unmarshal([]byte(v), &strct.City); err != nil {
				return err
			}
		case "code":
			if err := json.Unmarshal([]byte(v), &strct.Code); err != nil {
				return err
			}
		case "contacts":
			if err := json.Unmarshal([]byte(v), &strct.Contacts); err != nil {
				return err
			}
		case "created_at":
			if err := json.Unmarshal([]byte(v), &strct.CreatedAt); err != nil {
				return err
			}
		case "floors":
			if err := json.Unmarshal([]byte(v), &strct.Floors); err != nil {
				return err
			}
		case "have_map":
			if err := json.Unmarshal([]byte(v), &strct.HaveMap); err != nil {
				return err
			}
		case "id":
			if err := json.Unmarshal([]byte(v), &strct.Id); err != nil {
				return err
			}
		case "is_deleted":
			if err := json.Unmarshal([]byte(v), &strct.IsDeleted); err != nil {
				return err
			}
		case "is_virtual":
			if err := json.Unmarshal([]byte(v), &strct.IsVirtual); err != nil {
				return err
			}
		case "_meta":
			if err := json.Unmarshal([]byte(v), &strct.Meta); err != nil {
				return err
			}
		case "name":
			if err := json.Unmarshal([]byte(v), &strct.Name); err != nil {
				return err
			}
		case "timezone":
			if err := json.Unmarshal([]byte(v), &strct.Timezone); err != nil {
				return err
			}
		default:
			return fmt.Errorf("additional property not allowed: \"" + k + "\"")
		}
	}
	return nil
}

func (strct *Officeref) MarshalJSON() ([]byte, error) {
	buf := bytes.NewBuffer(make([]byte, 0))
	buf.WriteString("{")
	comma := false
	// Marshal the "address" field
	if strct.Address != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"address\": ")
		if tmp, err := json.Marshal(strct.Address); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "city" field
	if strct.City != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"city\": ")
		if tmp, err := json.Marshal(strct.City); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "code" field
	if strct.Code != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"code\": ")
		if tmp, err := json.Marshal(strct.Code); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "contacts" field
	if strct.Contacts != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"contacts\": ")
		if tmp, err := json.Marshal(strct.Contacts); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "created_at" field
	if strct.CreatedAt != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"created_at\": ")
		if tmp, err := json.Marshal(strct.CreatedAt); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "have_map" field
	if strct.HaveMap != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"have_map\": ")
		if tmp, err := json.Marshal(strct.HaveMap); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "id" field
	if strct.Id != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"id\": ")
		if tmp, err := json.Marshal(strct.Id); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "is_deleted" field
	if strct.IsDeleted != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"is_deleted\": ")
		if tmp, err := json.Marshal(strct.IsDeleted); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "is_virtual" field
	if strct.IsVirtual != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"is_virtual\": ")
		if tmp, err := json.Marshal(strct.IsVirtual); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "name" field
	if strct.Name != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"name\": ")
		if tmp, err := json.Marshal(strct.Name); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "timezone" field
	if strct.Timezone != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"timezone\": ")
		if tmp, err := json.Marshal(strct.Timezone); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}

	buf.WriteString("}")
	rv := buf.Bytes()
	return rv, nil
}

func (strct *Officeref) UnmarshalJSON(b []byte) error {
	var jsonMap map[string]json.RawMessage
	if err := json.Unmarshal(b, &jsonMap); err != nil {
		return err
	}
	// parse all the defined properties
	for k, v := range jsonMap {
		switch k {
		case "address":
			if err := json.Unmarshal([]byte(v), &strct.Address); err != nil {
				return err
			}
		case "city":
			if err := json.Unmarshal([]byte(v), &strct.City); err != nil {
				return err
			}
		case "code":
			if err := json.Unmarshal([]byte(v), &strct.Code); err != nil {
				return err
			}
		case "contacts":
			if err := json.Unmarshal([]byte(v), &strct.Contacts); err != nil {
				return err
			}
		case "created_at":
			if err := json.Unmarshal([]byte(v), &strct.CreatedAt); err != nil {
				return err
			}
		case "have_map":
			if err := json.Unmarshal([]byte(v), &strct.HaveMap); err != nil {
				return err
			}
		case "id":
			if err := json.Unmarshal([]byte(v), &strct.Id); err != nil {
				return err
			}
		case "is_deleted":
			if err := json.Unmarshal([]byte(v), &strct.IsDeleted); err != nil {
				return err
			}
		case "is_virtual":
			if err := json.Unmarshal([]byte(v), &strct.IsVirtual); err != nil {
				return err
			}
		case "name":
			if err := json.Unmarshal([]byte(v), &strct.Name); err != nil {
				return err
			}
		case "timezone":
			if err := json.Unmarshal([]byte(v), &strct.Timezone); err != nil {
				return err
			}
		default:
			return fmt.Errorf("additional property not allowed: \"" + k + "\"")
		}
	}
	return nil
}

func (strct *Official) MarshalJSON() ([]byte, error) {
	buf := bytes.NewBuffer(make([]byte, 0))
	buf.WriteString("{")
	comma := false
	// Marshal the "affiliation" field
	if strct.Affiliation != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"affiliation\": ")
		if tmp, err := json.Marshal(strct.Affiliation); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "contract_ended_at" field
	if strct.ContractEndedAt != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"contract_ended_at\": ")
		if tmp, err := json.Marshal(strct.ContractEndedAt); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "duties" field
	if strct.Duties != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"duties\": ")
		if tmp, err := json.Marshal(strct.Duties); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "employment" field
	if strct.Employment != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"employment\": ")
		if tmp, err := json.Marshal(strct.Employment); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "has_byod_access" field
	if strct.HasByodAccess != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"has_byod_access\": ")
		if tmp, err := json.Marshal(strct.HasByodAccess); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "is_dismissed" field
	if strct.IsDismissed != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"is_dismissed\": ")
		if tmp, err := json.Marshal(strct.IsDismissed); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "is_homeworker" field
	if strct.IsHomeworker != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"is_homeworker\": ")
		if tmp, err := json.Marshal(strct.IsHomeworker); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "is_robot" field
	if strct.IsRobot != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"is_robot\": ")
		if tmp, err := json.Marshal(strct.IsRobot); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "is_trainee" field
	if strct.IsTrainee != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"is_trainee\": ")
		if tmp, err := json.Marshal(strct.IsTrainee); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "join_at" field
	if strct.JoinAt != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"join_at\": ")
		if tmp, err := json.Marshal(strct.JoinAt); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "nda_ended_at" field
	if strct.NdaEndedAt != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"nda_ended_at\": ")
		if tmp, err := json.Marshal(strct.NdaEndedAt); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "organization" field
	if strct.Organization != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"organization\": ")
		if tmp, err := json.Marshal(strct.Organization); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "position" field
	if strct.Position != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"position\": ")
		if tmp, err := json.Marshal(strct.Position); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "quit_at" field
	if strct.QuitAt != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"quit_at\": ")
		if tmp, err := json.Marshal(strct.QuitAt); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "staff_agreement" field
	if strct.StaffAgreement != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"staff_agreement\": ")
		if tmp, err := json.Marshal(strct.StaffAgreement); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "wiretap" field
	if strct.Wiretap != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"wiretap\": ")
		if tmp, err := json.Marshal(strct.Wiretap); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}

	buf.WriteString("}")
	rv := buf.Bytes()
	return rv, nil
}

func (strct *Official) UnmarshalJSON(b []byte) error {
	var jsonMap map[string]json.RawMessage
	if err := json.Unmarshal(b, &jsonMap); err != nil {
		return err
	}
	// parse all the defined properties
	for k, v := range jsonMap {
		switch k {
		case "affiliation":
			if err := json.Unmarshal([]byte(v), &strct.Affiliation); err != nil {
				return err
			}
		case "contract_ended_at":
			if err := json.Unmarshal([]byte(v), &strct.ContractEndedAt); err != nil {
				return err
			}
		case "duties":
			if err := json.Unmarshal([]byte(v), &strct.Duties); err != nil {
				return err
			}
		case "employment":
			if err := json.Unmarshal([]byte(v), &strct.Employment); err != nil {
				return err
			}
		case "has_byod_access":
			if err := json.Unmarshal([]byte(v), &strct.HasByodAccess); err != nil {
				return err
			}
		case "is_dismissed":
			if err := json.Unmarshal([]byte(v), &strct.IsDismissed); err != nil {
				return err
			}
		case "is_homeworker":
			if err := json.Unmarshal([]byte(v), &strct.IsHomeworker); err != nil {
				return err
			}
		case "is_robot":
			if err := json.Unmarshal([]byte(v), &strct.IsRobot); err != nil {
				return err
			}
		case "is_trainee":
			if err := json.Unmarshal([]byte(v), &strct.IsTrainee); err != nil {
				return err
			}
		case "join_at":
			if err := json.Unmarshal([]byte(v), &strct.JoinAt); err != nil {
				return err
			}
		case "nda_ended_at":
			if err := json.Unmarshal([]byte(v), &strct.NdaEndedAt); err != nil {
				return err
			}
		case "organization":
			if err := json.Unmarshal([]byte(v), &strct.Organization); err != nil {
				return err
			}
		case "position":
			if err := json.Unmarshal([]byte(v), &strct.Position); err != nil {
				return err
			}
		case "quit_at":
			if err := json.Unmarshal([]byte(v), &strct.QuitAt); err != nil {
				return err
			}
		case "staff_agreement":
			if err := json.Unmarshal([]byte(v), &strct.StaffAgreement); err != nil {
				return err
			}
		case "wiretap":
			if err := json.Unmarshal([]byte(v), &strct.Wiretap); err != nil {
				return err
			}
		default:
			return fmt.Errorf("additional property not allowed: \"" + k + "\"")
		}
	}
	return nil
}

func (strct *Organization) MarshalJSON() ([]byte, error) {
	buf := bytes.NewBuffer(make([]byte, 0))
	buf.WriteString("{")
	comma := false
	// Marshal the "created_at" field
	if strct.CreatedAt != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"created_at\": ")
		if tmp, err := json.Marshal(strct.CreatedAt); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "id" field
	if strct.Id != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"id\": ")
		if tmp, err := json.Marshal(strct.Id); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "is_deleted" field
	if strct.IsDeleted != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"is_deleted\": ")
		if tmp, err := json.Marshal(strct.IsDeleted); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "_meta" field
	if strct.Meta != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"_meta\": ")
		if tmp, err := json.Marshal(strct.Meta); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "name" field
	if strct.Name != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"name\": ")
		if tmp, err := json.Marshal(strct.Name); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "name_en" field
	if strct.NameEn != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"name_en\": ")
		if tmp, err := json.Marshal(strct.NameEn); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}

	buf.WriteString("}")
	rv := buf.Bytes()
	return rv, nil
}

func (strct *Organization) UnmarshalJSON(b []byte) error {
	var jsonMap map[string]json.RawMessage
	if err := json.Unmarshal(b, &jsonMap); err != nil {
		return err
	}
	// parse all the defined properties
	for k, v := range jsonMap {
		switch k {
		case "created_at":
			if err := json.Unmarshal([]byte(v), &strct.CreatedAt); err != nil {
				return err
			}
		case "id":
			if err := json.Unmarshal([]byte(v), &strct.Id); err != nil {
				return err
			}
		case "is_deleted":
			if err := json.Unmarshal([]byte(v), &strct.IsDeleted); err != nil {
				return err
			}
		case "_meta":
			if err := json.Unmarshal([]byte(v), &strct.Meta); err != nil {
				return err
			}
		case "name":
			if err := json.Unmarshal([]byte(v), &strct.Name); err != nil {
				return err
			}
		case "name_en":
			if err := json.Unmarshal([]byte(v), &strct.NameEn); err != nil {
				return err
			}
		default:
			return fmt.Errorf("additional property not allowed: \"" + k + "\"")
		}
	}
	return nil
}

func (strct *Person) MarshalJSON() ([]byte, error) {
	buf := bytes.NewBuffer(make([]byte, 0))
	buf.WriteString("{")
	comma := false
	// Marshal the "accounts" field
	if strct.Accounts != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"accounts\": ")
		if tmp, err := json.Marshal(strct.Accounts); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "bicycles" field
	if strct.Bicycles != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"bicycles\": ")
		if tmp, err := json.Marshal(strct.Bicycles); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "cars" field
	if strct.Cars != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"cars\": ")
		if tmp, err := json.Marshal(strct.Cars); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "chief" field
	if strct.Chief != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"chief\": ")
		if tmp, err := json.Marshal(strct.Chief); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "chiefs" field
	if strct.Chiefs != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"chiefs\": ")
		if tmp, err := json.Marshal(strct.Chiefs); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "contacts" field
	if strct.Contacts != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"contacts\": ")
		if tmp, err := json.Marshal(strct.Contacts); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "created_at" field
	if strct.CreatedAt != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"created_at\": ")
		if tmp, err := json.Marshal(strct.CreatedAt); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "department_group" field
	if strct.DepartmentGroup != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"department_group\": ")
		if tmp, err := json.Marshal(strct.DepartmentGroup); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "education" field
	if strct.Education != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"education\": ")
		if tmp, err := json.Marshal(strct.Education); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "emails" field
	if strct.Emails != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"emails\": ")
		if tmp, err := json.Marshal(strct.Emails); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "environment" field
	if strct.Environment != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"environment\": ")
		if tmp, err := json.Marshal(strct.Environment); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "gpg_keys" field
	if strct.GpgKeys != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"gpg_keys\": ")
		if tmp, err := json.Marshal(strct.GpgKeys); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "groups" field
	if strct.Groups != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"groups\": ")
		if tmp, err := json.Marshal(strct.Groups); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "guid" field
	if strct.Guid != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"guid\": ")
		if tmp, err := json.Marshal(strct.Guid); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "hr_partners" field
	if strct.HrPartners != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"hr_partners\": ")
		if tmp, err := json.Marshal(strct.HrPartners); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "id" field
	if strct.Id != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"id\": ")
		if tmp, err := json.Marshal(strct.Id); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "images" field
	if strct.Images != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"images\": ")
		if tmp, err := json.Marshal(strct.Images); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "is_deleted" field
	if strct.IsDeleted != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"is_deleted\": ")
		if tmp, err := json.Marshal(strct.IsDeleted); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "keys" field
	if strct.Keys != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"keys\": ")
		if tmp, err := json.Marshal(strct.Keys); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "language" field
	if strct.Language != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"language\": ")
		if tmp, err := json.Marshal(strct.Language); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "location" field
	if strct.Location != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"location\": ")
		if tmp, err := json.Marshal(strct.Location); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "login" field
	if strct.Login != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"login\": ")
		if tmp, err := json.Marshal(strct.Login); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "memorial" field
	if strct.Memorial != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"memorial\": ")
		if tmp, err := json.Marshal(strct.Memorial); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "_meta" field
	if strct.Meta != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"_meta\": ")
		if tmp, err := json.Marshal(strct.Meta); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "name" field
	if strct.Name != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"name\": ")
		if tmp, err := json.Marshal(strct.Name); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "official" field
	if strct.Official != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"official\": ")
		if tmp, err := json.Marshal(strct.Official); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "personal" field
	if strct.Personal != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"personal\": ")
		if tmp, err := json.Marshal(strct.Personal); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "personal_emails" field
	if strct.PersonalEmails != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"personal_emails\": ")
		if tmp, err := json.Marshal(strct.PersonalEmails); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "phones" field
	if strct.Phones != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"phones\": ")
		if tmp, err := json.Marshal(strct.Phones); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "robot_owners" field
	if strct.RobotOwners != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"robot_owners\": ")
		if tmp, err := json.Marshal(strct.RobotOwners); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "robot_users" field
	if strct.RobotUsers != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"robot_users\": ")
		if tmp, err := json.Marshal(strct.RobotUsers); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "skype_accounts" field
	if strct.SkypeAccounts != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"skype_accounts\": ")
		if tmp, err := json.Marshal(strct.SkypeAccounts); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "telegram_accounts" field
	if strct.TelegramAccounts != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"telegram_accounts\": ")
		if tmp, err := json.Marshal(strct.TelegramAccounts); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "uid" field
	if strct.Uid != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"uid\": ")
		if tmp, err := json.Marshal(strct.Uid); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "work_email" field
	if strct.WorkEmail != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"work_email\": ")
		if tmp, err := json.Marshal(strct.WorkEmail); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "work_phone" field
	if strct.WorkPhone != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"work_phone\": ")
		if tmp, err := json.Marshal(strct.WorkPhone); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "yandex" field
	if strct.Yandex != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"yandex\": ")
		if tmp, err := json.Marshal(strct.Yandex); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}

	buf.WriteString("}")
	rv := buf.Bytes()
	return rv, nil
}

func (strct *Person) UnmarshalJSON(b []byte) error {
	var jsonMap map[string]json.RawMessage
	if err := json.Unmarshal(b, &jsonMap); err != nil {
		return err
	}
	// parse all the defined properties
	for k, v := range jsonMap {
		switch k {
		case "accounts":
			if err := json.Unmarshal([]byte(v), &strct.Accounts); err != nil {
				return err
			}
		case "bicycles":
			if err := json.Unmarshal([]byte(v), &strct.Bicycles); err != nil {
				return err
			}
		case "cars":
			if err := json.Unmarshal([]byte(v), &strct.Cars); err != nil {
				return err
			}
		case "chief":
			if err := json.Unmarshal([]byte(v), &strct.Chief); err != nil {
				return err
			}
		case "chiefs":
			if err := json.Unmarshal([]byte(v), &strct.Chiefs); err != nil {
				return err
			}
		case "contacts":
			if err := json.Unmarshal([]byte(v), &strct.Contacts); err != nil {
				return err
			}
		case "created_at":
			if err := json.Unmarshal([]byte(v), &strct.CreatedAt); err != nil {
				return err
			}
		case "department_group":
			if err := json.Unmarshal([]byte(v), &strct.DepartmentGroup); err != nil {
				return err
			}
		case "education":
			if err := json.Unmarshal([]byte(v), &strct.Education); err != nil {
				return err
			}
		case "emails":
			if err := json.Unmarshal([]byte(v), &strct.Emails); err != nil {
				return err
			}
		case "environment":
			if err := json.Unmarshal([]byte(v), &strct.Environment); err != nil {
				return err
			}
		case "gpg_keys":
			if err := json.Unmarshal([]byte(v), &strct.GpgKeys); err != nil {
				return err
			}
		case "groups":
			if err := json.Unmarshal([]byte(v), &strct.Groups); err != nil {
				return err
			}
		case "guid":
			if err := json.Unmarshal([]byte(v), &strct.Guid); err != nil {
				return err
			}
		case "hr_partners":
			if err := json.Unmarshal([]byte(v), &strct.HrPartners); err != nil {
				return err
			}
		case "id":
			if err := json.Unmarshal([]byte(v), &strct.Id); err != nil {
				return err
			}
		case "images":
			if err := json.Unmarshal([]byte(v), &strct.Images); err != nil {
				return err
			}
		case "is_deleted":
			if err := json.Unmarshal([]byte(v), &strct.IsDeleted); err != nil {
				return err
			}
		case "keys":
			if err := json.Unmarshal([]byte(v), &strct.Keys); err != nil {
				return err
			}
		case "language":
			if err := json.Unmarshal([]byte(v), &strct.Language); err != nil {
				return err
			}
		case "location":
			if err := json.Unmarshal([]byte(v), &strct.Location); err != nil {
				return err
			}
		case "login":
			if err := json.Unmarshal([]byte(v), &strct.Login); err != nil {
				return err
			}
		case "memorial":
			if err := json.Unmarshal([]byte(v), &strct.Memorial); err != nil {
				return err
			}
		case "_meta":
			if err := json.Unmarshal([]byte(v), &strct.Meta); err != nil {
				return err
			}
		case "name":
			if err := json.Unmarshal([]byte(v), &strct.Name); err != nil {
				return err
			}
		case "official":
			if err := json.Unmarshal([]byte(v), &strct.Official); err != nil {
				return err
			}
		case "personal":
			if err := json.Unmarshal([]byte(v), &strct.Personal); err != nil {
				return err
			}
		case "personal_emails":
			if err := json.Unmarshal([]byte(v), &strct.PersonalEmails); err != nil {
				return err
			}
		case "phones":
			if err := json.Unmarshal([]byte(v), &strct.Phones); err != nil {
				return err
			}
		case "robot_owners":
			if err := json.Unmarshal([]byte(v), &strct.RobotOwners); err != nil {
				return err
			}
		case "robot_users":
			if err := json.Unmarshal([]byte(v), &strct.RobotUsers); err != nil {
				return err
			}
		case "skype_accounts":
			if err := json.Unmarshal([]byte(v), &strct.SkypeAccounts); err != nil {
				return err
			}
		case "telegram_accounts":
			if err := json.Unmarshal([]byte(v), &strct.TelegramAccounts); err != nil {
				return err
			}
		case "uid":
			if err := json.Unmarshal([]byte(v), &strct.Uid); err != nil {
				return err
			}
		case "work_email":
			if err := json.Unmarshal([]byte(v), &strct.WorkEmail); err != nil {
				return err
			}
		case "work_phone":
			if err := json.Unmarshal([]byte(v), &strct.WorkPhone); err != nil {
				return err
			}
		case "yandex":
			if err := json.Unmarshal([]byte(v), &strct.Yandex); err != nil {
				return err
			}
		default:
			return fmt.Errorf("additional property not allowed: \"" + k + "\"")
		}
	}
	return nil
}

func (strct *Personal) MarshalJSON() ([]byte, error) {
	buf := bytes.NewBuffer(make([]byte, 0))
	buf.WriteString("{")
	comma := false
	// Marshal the "about" field
	if strct.About != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"about\": ")
		if tmp, err := json.Marshal(strct.About); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "address" field
	if strct.Address != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"address\": ")
		if tmp, err := json.Marshal(strct.Address); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "birthday" field
	if strct.Birthday != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"birthday\": ")
		if tmp, err := json.Marshal(strct.Birthday); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "children" field
	if strct.Children != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"children\": ")
		if tmp, err := json.Marshal(strct.Children); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "family_status" field
	if strct.FamilyStatus != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"family_status\": ")
		if tmp, err := json.Marshal(strct.FamilyStatus); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "gender" field
	if strct.Gender != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"gender\": ")
		if tmp, err := json.Marshal(strct.Gender); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "mobile_phone_model" field
	if strct.MobilePhoneModel != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"mobile_phone_model\": ")
		if tmp, err := json.Marshal(strct.MobilePhoneModel); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "mobile_phone_number" field
	if strct.MobilePhoneNumber != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"mobile_phone_number\": ")
		if tmp, err := json.Marshal(strct.MobilePhoneNumber); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "tshirt_size" field
	if strct.TshirtSize != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"tshirt_size\": ")
		if tmp, err := json.Marshal(strct.TshirtSize); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}

	buf.WriteString("}")
	rv := buf.Bytes()
	return rv, nil
}

func (strct *Personal) UnmarshalJSON(b []byte) error {
	var jsonMap map[string]json.RawMessage
	if err := json.Unmarshal(b, &jsonMap); err != nil {
		return err
	}
	// parse all the defined properties
	for k, v := range jsonMap {
		switch k {
		case "about":
			if err := json.Unmarshal([]byte(v), &strct.About); err != nil {
				return err
			}
		case "address":
			if err := json.Unmarshal([]byte(v), &strct.Address); err != nil {
				return err
			}
		case "birthday":
			if err := json.Unmarshal([]byte(v), &strct.Birthday); err != nil {
				return err
			}
		case "children":
			if err := json.Unmarshal([]byte(v), &strct.Children); err != nil {
				return err
			}
		case "family_status":
			if err := json.Unmarshal([]byte(v), &strct.FamilyStatus); err != nil {
				return err
			}
		case "gender":
			if err := json.Unmarshal([]byte(v), &strct.Gender); err != nil {
				return err
			}
		case "mobile_phone_model":
			if err := json.Unmarshal([]byte(v), &strct.MobilePhoneModel); err != nil {
				return err
			}
		case "mobile_phone_number":
			if err := json.Unmarshal([]byte(v), &strct.MobilePhoneNumber); err != nil {
				return err
			}
		case "tshirt_size":
			if err := json.Unmarshal([]byte(v), &strct.TshirtSize); err != nil {
				return err
			}
		default:
			return fmt.Errorf("additional property not allowed: \"" + k + "\"")
		}
	}
	return nil
}

func (strct *Personnewref) MarshalJSON() ([]byte, error) {
	buf := bytes.NewBuffer(make([]byte, 0))
	buf.WriteString("{")
	comma := false
	// Marshal the "guid" field
	if strct.Guid != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"guid\": ")
		if tmp, err := json.Marshal(strct.Guid); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "id" field
	if strct.Id != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"id\": ")
		if tmp, err := json.Marshal(strct.Id); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "login" field
	if strct.Login != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"login\": ")
		if tmp, err := json.Marshal(strct.Login); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "name" field
	if strct.Name != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"name\": ")
		if tmp, err := json.Marshal(strct.Name); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "uid" field
	if strct.Uid != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"uid\": ")
		if tmp, err := json.Marshal(strct.Uid); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}

	buf.WriteString("}")
	rv := buf.Bytes()
	return rv, nil
}

func (strct *Personnewref) UnmarshalJSON(b []byte) error {
	var jsonMap map[string]json.RawMessage
	if err := json.Unmarshal(b, &jsonMap); err != nil {
		return err
	}
	// parse all the defined properties
	for k, v := range jsonMap {
		switch k {
		case "guid":
			if err := json.Unmarshal([]byte(v), &strct.Guid); err != nil {
				return err
			}
		case "id":
			if err := json.Unmarshal([]byte(v), &strct.Id); err != nil {
				return err
			}
		case "login":
			if err := json.Unmarshal([]byte(v), &strct.Login); err != nil {
				return err
			}
		case "name":
			if err := json.Unmarshal([]byte(v), &strct.Name); err != nil {
				return err
			}
		case "uid":
			if err := json.Unmarshal([]byte(v), &strct.Uid); err != nil {
				return err
			}
		default:
			return fmt.Errorf("additional property not allowed: \"" + k + "\"")
		}
	}
	return nil
}

func (strct *Personref) MarshalJSON() ([]byte, error) {
	buf := bytes.NewBuffer(make([]byte, 0))
	buf.WriteString("{")
	comma := false
	// Marshal the "guid" field
	if strct.Guid != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"guid\": ")
		if tmp, err := json.Marshal(strct.Guid); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "id" field
	if strct.Id != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"id\": ")
		if tmp, err := json.Marshal(strct.Id); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "is_deleted" field
	if strct.IsDeleted != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"is_deleted\": ")
		if tmp, err := json.Marshal(strct.IsDeleted); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "login" field
	if strct.Login != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"login\": ")
		if tmp, err := json.Marshal(strct.Login); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "name" field
	if strct.Name != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"name\": ")
		if tmp, err := json.Marshal(strct.Name); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "official" field
	if strct.Official != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"official\": ")
		if tmp, err := json.Marshal(strct.Official); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "uid" field
	if strct.Uid != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"uid\": ")
		if tmp, err := json.Marshal(strct.Uid); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}

	buf.WriteString("}")
	rv := buf.Bytes()
	return rv, nil
}

func (strct *Personref) UnmarshalJSON(b []byte) error {
	var jsonMap map[string]json.RawMessage
	if err := json.Unmarshal(b, &jsonMap); err != nil {
		return err
	}
	// parse all the defined properties
	for k, v := range jsonMap {
		switch k {
		case "guid":
			if err := json.Unmarshal([]byte(v), &strct.Guid); err != nil {
				return err
			}
		case "id":
			if err := json.Unmarshal([]byte(v), &strct.Id); err != nil {
				return err
			}
		case "is_deleted":
			if err := json.Unmarshal([]byte(v), &strct.IsDeleted); err != nil {
				return err
			}
		case "login":
			if err := json.Unmarshal([]byte(v), &strct.Login); err != nil {
				return err
			}
		case "name":
			if err := json.Unmarshal([]byte(v), &strct.Name); err != nil {
				return err
			}
		case "official":
			if err := json.Unmarshal([]byte(v), &strct.Official); err != nil {
				return err
			}
		case "uid":
			if err := json.Unmarshal([]byte(v), &strct.Uid); err != nil {
				return err
			}
		default:
			return fmt.Errorf("additional property not allowed: \"" + k + "\"")
		}
	}
	return nil
}

func (strct *PhonesItems) MarshalJSON() ([]byte, error) {
	buf := bytes.NewBuffer(make([]byte, 0))
	buf.WriteString("{")
	comma := false
	// Marshal the "description" field
	if strct.Description != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"description\": ")
		if tmp, err := json.Marshal(strct.Description); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "id" field
	if strct.Id != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"id\": ")
		if tmp, err := json.Marshal(strct.Id); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "is_main" field
	if strct.IsMain != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"is_main\": ")
		if tmp, err := json.Marshal(strct.IsMain); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "kind" field
	if strct.Kind != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"kind\": ")
		if tmp, err := json.Marshal(strct.Kind); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "number" field
	if strct.Number != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"number\": ")
		if tmp, err := json.Marshal(strct.Number); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "protocol" field
	if strct.Protocol != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"protocol\": ")
		if tmp, err := json.Marshal(strct.Protocol); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "type" field
	if strct.Type != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"type\": ")
		if tmp, err := json.Marshal(strct.Type); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}

	buf.WriteString("}")
	rv := buf.Bytes()
	return rv, nil
}

func (strct *PhonesItems) UnmarshalJSON(b []byte) error {
	var jsonMap map[string]json.RawMessage
	if err := json.Unmarshal(b, &jsonMap); err != nil {
		return err
	}
	// parse all the defined properties
	for k, v := range jsonMap {
		switch k {
		case "description":
			if err := json.Unmarshal([]byte(v), &strct.Description); err != nil {
				return err
			}
		case "id":
			if err := json.Unmarshal([]byte(v), &strct.Id); err != nil {
				return err
			}
		case "is_main":
			if err := json.Unmarshal([]byte(v), &strct.IsMain); err != nil {
				return err
			}
		case "kind":
			if err := json.Unmarshal([]byte(v), &strct.Kind); err != nil {
				return err
			}
		case "number":
			if err := json.Unmarshal([]byte(v), &strct.Number); err != nil {
				return err
			}
		case "protocol":
			if err := json.Unmarshal([]byte(v), &strct.Protocol); err != nil {
				return err
			}
		case "type":
			if err := json.Unmarshal([]byte(v), &strct.Type); err != nil {
				return err
			}
		default:
			return fmt.Errorf("additional property not allowed: \"" + k + "\"")
		}
	}
	return nil
}

func (strct *Position) MarshalJSON() ([]byte, error) {
	buf := bytes.NewBuffer(make([]byte, 0))
	buf.WriteString("{")
	comma := false
	// Marshal the "code" field
	if strct.Code != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"code\": ")
		if tmp, err := json.Marshal(strct.Code); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "end_date" field
	if strct.EndDate != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"end_date\": ")
		if tmp, err := json.Marshal(strct.EndDate); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "id" field
	if strct.Id != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"id\": ")
		if tmp, err := json.Marshal(strct.Id); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "_meta" field
	if strct.Meta != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"_meta\": ")
		if tmp, err := json.Marshal(strct.Meta); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "name" field
	if strct.Name != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"name\": ")
		if tmp, err := json.Marshal(strct.Name); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "start_date" field
	if strct.StartDate != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"start_date\": ")
		if tmp, err := json.Marshal(strct.StartDate); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}

	buf.WriteString("}")
	rv := buf.Bytes()
	return rv, nil
}

func (strct *Position) UnmarshalJSON(b []byte) error {
	var jsonMap map[string]json.RawMessage
	if err := json.Unmarshal(b, &jsonMap); err != nil {
		return err
	}
	// parse all the defined properties
	for k, v := range jsonMap {
		switch k {
		case "code":
			if err := json.Unmarshal([]byte(v), &strct.Code); err != nil {
				return err
			}
		case "end_date":
			if err := json.Unmarshal([]byte(v), &strct.EndDate); err != nil {
				return err
			}
		case "id":
			if err := json.Unmarshal([]byte(v), &strct.Id); err != nil {
				return err
			}
		case "_meta":
			if err := json.Unmarshal([]byte(v), &strct.Meta); err != nil {
				return err
			}
		case "name":
			if err := json.Unmarshal([]byte(v), &strct.Name); err != nil {
				return err
			}
		case "start_date":
			if err := json.Unmarshal([]byte(v), &strct.StartDate); err != nil {
				return err
			}
		default:
			return fmt.Errorf("additional property not allowed: \"" + k + "\"")
		}
	}
	return nil
}

func (strct *ResponsiblesItems) MarshalJSON() ([]byte, error) {
	buf := bytes.NewBuffer(make([]byte, 0))
	buf.WriteString("{")
	comma := false
	// Marshal the "id" field
	if strct.Id != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"id\": ")
		if tmp, err := json.Marshal(strct.Id); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "permitted_at" field
	if strct.PermittedAt != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"permitted_at\": ")
		if tmp, err := json.Marshal(strct.PermittedAt); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "person" field
	if strct.Person != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"person\": ")
		if tmp, err := json.Marshal(strct.Person); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}

	buf.WriteString("}")
	rv := buf.Bytes()
	return rv, nil
}

func (strct *ResponsiblesItems) UnmarshalJSON(b []byte) error {
	var jsonMap map[string]json.RawMessage
	if err := json.Unmarshal(b, &jsonMap); err != nil {
		return err
	}
	// parse all the defined properties
	for k, v := range jsonMap {
		switch k {
		case "id":
			if err := json.Unmarshal([]byte(v), &strct.Id); err != nil {
				return err
			}
		case "permitted_at":
			if err := json.Unmarshal([]byte(v), &strct.PermittedAt); err != nil {
				return err
			}
		case "person":
			if err := json.Unmarshal([]byte(v), &strct.Person); err != nil {
				return err
			}
		default:
			return fmt.Errorf("additional property not allowed: \"" + k + "\"")
		}
	}
	return nil
}

func (strct *RobotOwnersItems) MarshalJSON() ([]byte, error) {
	buf := bytes.NewBuffer(make([]byte, 0))
	buf.WriteString("{")
	comma := false
	// Marshal the "id" field
	if strct.Id != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"id\": ")
		if tmp, err := json.Marshal(strct.Id); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "person" field
	if strct.Person != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"person\": ")
		if tmp, err := json.Marshal(strct.Person); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}

	buf.WriteString("}")
	rv := buf.Bytes()
	return rv, nil
}

func (strct *RobotOwnersItems) UnmarshalJSON(b []byte) error {
	var jsonMap map[string]json.RawMessage
	if err := json.Unmarshal(b, &jsonMap); err != nil {
		return err
	}
	// parse all the defined properties
	for k, v := range jsonMap {
		switch k {
		case "id":
			if err := json.Unmarshal([]byte(v), &strct.Id); err != nil {
				return err
			}
		case "person":
			if err := json.Unmarshal([]byte(v), &strct.Person); err != nil {
				return err
			}
		default:
			return fmt.Errorf("additional property not allowed: \"" + k + "\"")
		}
	}
	return nil
}

func (strct *RobotUsersItems) MarshalJSON() ([]byte, error) {
	buf := bytes.NewBuffer(make([]byte, 0))
	buf.WriteString("{")
	comma := false
	// Marshal the "id" field
	if strct.Id != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"id\": ")
		if tmp, err := json.Marshal(strct.Id); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "person" field
	if strct.Person != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"person\": ")
		if tmp, err := json.Marshal(strct.Person); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}

	buf.WriteString("}")
	rv := buf.Bytes()
	return rv, nil
}

func (strct *RobotUsersItems) UnmarshalJSON(b []byte) error {
	var jsonMap map[string]json.RawMessage
	if err := json.Unmarshal(b, &jsonMap); err != nil {
		return err
	}
	// parse all the defined properties
	for k, v := range jsonMap {
		switch k {
		case "id":
			if err := json.Unmarshal([]byte(v), &strct.Id); err != nil {
				return err
			}
		case "person":
			if err := json.Unmarshal([]byte(v), &strct.Person); err != nil {
				return err
			}
		default:
			return fmt.Errorf("additional property not allowed: \"" + k + "\"")
		}
	}
	return nil
}

func (strct *Room) MarshalJSON() ([]byte, error) {
	buf := bytes.NewBuffer(make([]byte, 0))
	buf.WriteString("{")
	comma := false
	// Marshal the "additional" field
	if strct.Additional != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"additional\": ")
		if tmp, err := json.Marshal(strct.Additional); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "capacity" field
	if strct.Capacity != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"capacity\": ")
		if tmp, err := json.Marshal(strct.Capacity); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "created_at" field
	if strct.CreatedAt != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"created_at\": ")
		if tmp, err := json.Marshal(strct.CreatedAt); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "equipment" field
	if strct.Equipment != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"equipment\": ")
		if tmp, err := json.Marshal(strct.Equipment); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "floor" field
	if strct.Floor != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"floor\": ")
		if tmp, err := json.Marshal(strct.Floor); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "id" field
	if strct.Id != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"id\": ")
		if tmp, err := json.Marshal(strct.Id); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "is_bookable" field
	if strct.IsBookable != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"is_bookable\": ")
		if tmp, err := json.Marshal(strct.IsBookable); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "is_deleted" field
	if strct.IsDeleted != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"is_deleted\": ")
		if tmp, err := json.Marshal(strct.IsDeleted); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "location" field
	if strct.Location != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"location\": ")
		if tmp, err := json.Marshal(strct.Location); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "_meta" field
	if strct.Meta != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"_meta\": ")
		if tmp, err := json.Marshal(strct.Meta); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "name" field
	if strct.Name != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"name\": ")
		if tmp, err := json.Marshal(strct.Name); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "number" field
	if strct.Number != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"number\": ")
		if tmp, err := json.Marshal(strct.Number); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "phone" field
	if strct.Phone != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"phone\": ")
		if tmp, err := json.Marshal(strct.Phone); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "type" field
	if strct.Type != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"type\": ")
		if tmp, err := json.Marshal(strct.Type); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}

	buf.WriteString("}")
	rv := buf.Bytes()
	return rv, nil
}

func (strct *Room) UnmarshalJSON(b []byte) error {
	var jsonMap map[string]json.RawMessage
	if err := json.Unmarshal(b, &jsonMap); err != nil {
		return err
	}
	// parse all the defined properties
	for k, v := range jsonMap {
		switch k {
		case "additional":
			if err := json.Unmarshal([]byte(v), &strct.Additional); err != nil {
				return err
			}
		case "capacity":
			if err := json.Unmarshal([]byte(v), &strct.Capacity); err != nil {
				return err
			}
		case "created_at":
			if err := json.Unmarshal([]byte(v), &strct.CreatedAt); err != nil {
				return err
			}
		case "equipment":
			if err := json.Unmarshal([]byte(v), &strct.Equipment); err != nil {
				return err
			}
		case "floor":
			if err := json.Unmarshal([]byte(v), &strct.Floor); err != nil {
				return err
			}
		case "id":
			if err := json.Unmarshal([]byte(v), &strct.Id); err != nil {
				return err
			}
		case "is_bookable":
			if err := json.Unmarshal([]byte(v), &strct.IsBookable); err != nil {
				return err
			}
		case "is_deleted":
			if err := json.Unmarshal([]byte(v), &strct.IsDeleted); err != nil {
				return err
			}
		case "location":
			if err := json.Unmarshal([]byte(v), &strct.Location); err != nil {
				return err
			}
		case "_meta":
			if err := json.Unmarshal([]byte(v), &strct.Meta); err != nil {
				return err
			}
		case "name":
			if err := json.Unmarshal([]byte(v), &strct.Name); err != nil {
				return err
			}
		case "number":
			if err := json.Unmarshal([]byte(v), &strct.Number); err != nil {
				return err
			}
		case "phone":
			if err := json.Unmarshal([]byte(v), &strct.Phone); err != nil {
				return err
			}
		case "type":
			if err := json.Unmarshal([]byte(v), &strct.Type); err != nil {
				return err
			}
		default:
			return fmt.Errorf("additional property not allowed: \"" + k + "\"")
		}
	}
	return nil
}

func (strct *Serviceref) MarshalJSON() ([]byte, error) {
	buf := bytes.NewBuffer(make([]byte, 0))
	buf.WriteString("{")
	comma := false
	// Marshal the "id" field
	if strct.Id != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"id\": ")
		if tmp, err := json.Marshal(strct.Id); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}

	buf.WriteString("}")
	rv := buf.Bytes()
	return rv, nil
}

func (strct *Serviceref) UnmarshalJSON(b []byte) error {
	var jsonMap map[string]json.RawMessage
	if err := json.Unmarshal(b, &jsonMap); err != nil {
		return err
	}
	// parse all the defined properties
	for k, v := range jsonMap {
		switch k {
		case "id":
			if err := json.Unmarshal([]byte(v), &strct.Id); err != nil {
				return err
			}
		default:
			return fmt.Errorf("additional property not allowed: \"" + k + "\"")
		}
	}
	return nil
}

func (strct *Shortrefdepartment) MarshalJSON() ([]byte, error) {
	buf := bytes.NewBuffer(make([]byte, 0))
	buf.WriteString("{")
	comma := false
	// Marshal the "id" field
	if strct.Id != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"id\": ")
		if tmp, err := json.Marshal(strct.Id); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}

	buf.WriteString("}")
	rv := buf.Bytes()
	return rv, nil
}

func (strct *Shortrefdepartment) UnmarshalJSON(b []byte) error {
	var jsonMap map[string]json.RawMessage
	if err := json.Unmarshal(b, &jsonMap); err != nil {
		return err
	}
	// parse all the defined properties
	for k, v := range jsonMap {
		switch k {
		case "id":
			if err := json.Unmarshal([]byte(v), &strct.Id); err != nil {
				return err
			}
		default:
			return fmt.Errorf("additional property not allowed: \"" + k + "\"")
		}
	}
	return nil
}

func (strct *Table) MarshalJSON() ([]byte, error) {
	buf := bytes.NewBuffer(make([]byte, 0))
	buf.WriteString("{")
	comma := false
	// Marshal the "created_at" field
	if strct.CreatedAt != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"created_at\": ")
		if tmp, err := json.Marshal(strct.CreatedAt); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "floor" field
	if strct.Floor != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"floor\": ")
		if tmp, err := json.Marshal(strct.Floor); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "id" field
	if strct.Id != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"id\": ")
		if tmp, err := json.Marshal(strct.Id); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "location" field
	if strct.Location != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"location\": ")
		if tmp, err := json.Marshal(strct.Location); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "_meta" field
	if strct.Meta != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"_meta\": ")
		if tmp, err := json.Marshal(strct.Meta); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}
	// Marshal the "number" field
	if strct.Number != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"number\": ")
		if tmp, err := json.Marshal(strct.Number); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}

	buf.WriteString("}")
	rv := buf.Bytes()
	return rv, nil
}

func (strct *Table) UnmarshalJSON(b []byte) error {
	var jsonMap map[string]json.RawMessage
	if err := json.Unmarshal(b, &jsonMap); err != nil {
		return err
	}
	// parse all the defined properties
	for k, v := range jsonMap {
		switch k {
		case "created_at":
			if err := json.Unmarshal([]byte(v), &strct.CreatedAt); err != nil {
				return err
			}
		case "floor":
			if err := json.Unmarshal([]byte(v), &strct.Floor); err != nil {
				return err
			}
		case "id":
			if err := json.Unmarshal([]byte(v), &strct.Id); err != nil {
				return err
			}
		case "location":
			if err := json.Unmarshal([]byte(v), &strct.Location); err != nil {
				return err
			}
		case "_meta":
			if err := json.Unmarshal([]byte(v), &strct.Meta); err != nil {
				return err
			}
		case "number":
			if err := json.Unmarshal([]byte(v), &strct.Number); err != nil {
				return err
			}
		default:
			return fmt.Errorf("additional property not allowed: \"" + k + "\"")
		}
	}
	return nil
}

func (strct *Yandex) MarshalJSON() ([]byte, error) {
	buf := bytes.NewBuffer(make([]byte, 0))
	buf.WriteString("{")
	comma := false
	// Marshal the "login" field
	if strct.Login != nil {
		if comma {
			buf.WriteString(",")
		}
		buf.WriteString("\"login\": ")
		if tmp, err := json.Marshal(strct.Login); err != nil {
			return nil, err
		} else {
			buf.Write(tmp)
		}
		comma = true
	}

	buf.WriteString("}")
	rv := buf.Bytes()
	return rv, nil
}

func (strct *Yandex) UnmarshalJSON(b []byte) error {
	var jsonMap map[string]json.RawMessage
	if err := json.Unmarshal(b, &jsonMap); err != nil {
		return err
	}
	// parse all the defined properties
	for k, v := range jsonMap {
		switch k {
		case "login":
			if err := json.Unmarshal([]byte(v), &strct.Login); err != nil {
				return err
			}
		default:
			return fmt.Errorf("additional property not allowed: \"" + k + "\"")
		}
	}
	return nil
}
