package database

import "context"

type Client interface {
	Get(ctx context.Context, collection string, filter map[string]interface{}, fields, sort map[string]int, limit, page int, result interface{}) error
	GetOne(ctx context.Context, collection string, filter map[string]interface{}, fields, sort map[string]int, result interface{}) error
	GetAll(ctx context.Context, collection string, result interface{}) error
	Count(ctx context.Context, collection string, filter map[string]interface{}) (int, error)
	AddItemToArray(ctx context.Context, collection, field string, filter map[string]interface{}, item string) error
	PullItemFromArray(ctx context.Context, collection, field string, filter map[string]interface{}, item string) error
}
