package database

import (
	"context"

	"go.mongodb.org/mongo-driver/bson"
	"go.mongodb.org/mongo-driver/bson/primitive"
)

type FakeClient struct{}

var fakeRolesCollection = []map[string]interface{}{
	{
		"_id":   primitive.ObjectID{},
		"login": "aksenovma",
		"uid":   "123",
		"roles": bson.A{},
	},
	{
		"_id":   primitive.ObjectID{},
		"login": "cracker",
		"uid":   "456",
		"roles": bson.A{"u"},
	},
	{
		"_id":   primitive.ObjectID{},
		"login": "denis-p",
		"uid":   "789",
		"roles": bson.A{"su", "a"},
	},
	{
		"_id":   primitive.ObjectID{},
		"login": "777",
		"uid":   "",
		"roles": bson.A{"u", "su"},
	},
}

func NewFakeClient() *FakeClient { return new(FakeClient) }

func strInArr(str string, arr bson.A) bool {
	for _, s := range arr {
		if s == str {
			return true
		}
	}
	return false
}

func getIDField(f string) string {
	switch f {
	case "tvm_app":
		{
			return "login"
		}
	case "user":
		{
			return "uid"
		}
	}
	return ""
}

func (fc *FakeClient) GetAll(ctx context.Context, collection string, _result interface{}) error {
	if collection != "roles" {
		return nil
	}

	return nil
}

func (fc *FakeClient) AddSliceToArray(
	ctx context.Context,
	collection, field string,
	filter map[string]string,
	items []string,
) (matched, modified bool, err error) {
	if collection != "roles" {
		return
	}

	for _, ur := range fakeRolesCollection {
		idField := getIDField(filter["type"])
		if idField == "" {
			return
		}

		if filter[idField] == ur[idField] && filter["type"] == ur["type"] {
			matched = true
			for _, r := range items {
				if ok := strInArr(r, ur["roles"].(bson.A)); !ok {
					modified = true
					break
				}
			}
			break
		}
	}
	return matched, modified, nil
}

func (fc *FakeClient) PullSliceFromArray(
	ctx context.Context,
	collection, field string,
	filter map[string]string,
	items []string,
) (matched bool, err error) {
	if collection != "roles" {
		return
	}

	for _, ur := range fakeRolesCollection {
		idField := getIDField(filter["type"])
		if idField == "" {
			return
		}

		if filter[idField] == ur[idField] && filter["type"] == ur["type"] {
			matched = true
			break
		}
	}
	return matched, nil
}

func (fc *FakeClient) AddItemToArray(ctx context.Context, collection, field string, filter map[string]interface{}, item string) error {
	return nil
}

func (fc *FakeClient) PullItemFromArray(ctx context.Context, collection, field string, filter map[string]interface{}, item string) error {
	return nil
}

func (fc *FakeClient) Count(ctx context.Context, collection string, filter map[string]interface{}) (int, error) {
	if collection != "roles" {
		return 0, nil
	}

	return len(fakeRolesCollection), nil
}

func (fc *FakeClient) Get(ctx context.Context, collection string, filter map[string]interface{}, fields, sort map[string]int, limit, page int, result interface{}) error {
	return nil
}

func (fc *FakeClient) GetOne(ctx context.Context, collection string, filter map[string]interface{}, fields, sort map[string]int, result interface{}) error {
	return nil
}
