package idm

import (
	"net/http"
	"os"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/yandex/tvm"
	"github.com/go-chi/chi/v5"

	"a.yandex-team.ru/intranet/legacy/staff-api/internal/database"
	"a.yandex-team.ru/intranet/legacy/staff-api/internal/user"
)

func GetRoutes(logger log.Logger, db database.Client) http.Handler {
	r := chi.NewRouter()

	var idmServiceID tvm.ClientID
	if os.Getenv("DEPLOY_STAGE_ID") == "tools_staff-api_production" {
		idmServiceID = 2001600
	} else {
		idmServiceID = 2001602
	}

	r.Use(func(next http.Handler) http.Handler {
		return http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
			serviceID := user.GetServiceID(r.Context())
			if serviceID != idmServiceID {
				http.Error(w, "You are not an IDM", http.StatusForbidden)
				return
			}
			next.ServeHTTP(w, r)
		})
	})

	r.Get("/info/", getInfoHandler(logger))
	r.Get("/get-all-roles/", getAllRolesHandler(logger, db))
	r.Post("/add-role/", getAddRoleHandler(logger, db))
	r.Post("/remove-role/", getRemoveRoleHandler(logger, db))

	return r
}
