"""
Django settings for witchery project.

Generated by 'django-admin startproject' using Django 1.8.13.

For more information on this file, see
https://docs.djangoproject.com/en/1.8/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/1.8/ref/settings/
"""

# Build paths inside the project like this: os.path.join(BASE_DIR, ...)
import os
import yenv
import sys


try:
    execfile('/etc/secret_settings.py')
except IOError:
    raise RuntimeError('Secrets not found')

ROBOT_OAUTH_TOKEN = os.getenv('STAFF_ROBOT_OAUTH_TOKEN')

from django_yauth.settings import *

YAUTH_TYPE = 'intranet'
YAUTH_USE_SITES = False
YAUTH_PASSPORT_FIELDS = [blackbox.FIELD_LANGUAGE, blackbox.FIELD_LOGIN, ('userinfo.tz.uid', 'tz')]

DEBUG = True


if yenv.type == 'production':
    DEBUG = False
    DOGMA_HOST = 'dogma.yandex-team.ru'
else:
    DOGMA_HOST = 'dogma.test.yandex-team.ru'
    DEBUG = bool(int(os.getenv('DJANGO_DEBUG', 1)))

BASE_DIR = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))

LOGGING = {
    'version': 1,
    'disable_existing_loggers': False,
    'formatters': {
        'file': {'()': 'ylog.FileFormatter'},
        'json': {
            '()': 'ylog.format.QloudJsonFormatter',
         },
    },
    'handlers': {
        'console': {
            'class': 'logging.StreamHandler',
            'formatter': 'json',
            'stream': sys.stdout,
        }
    },
    'loggers': {
        'django': {
            'level': os.getenv('DJANGO_LOG_LEVEL', 'INFO'),
            'handlers': ['console'],
            'propagate': True,
        },
        'requests': {
            'level': 'ERROR',
            'handlers': ['console'],
            'propagate': True,
        },
        'py.warnings': {
            'level': 'ERROR',
            'handlers': ['console'],
            'propagate': True,
        },
    },
    'root': {
        'level': os.getenv('DJANGO_LOG_LEVEL', 'INFO'),
        'handlers': ['console'],
    },
}

# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/1.8/howto/deployment/checklist/


ALLOWED_HOSTS = [
    '.yandex-team.ru',
    '.yandex.net',
    '.yandex.ru',
]

# Application definition

INSTALLED_APPS = (
    'django_yauth',
    # 'django.contrib.admin',
    # 'django.contrib.auth',
    # 'django.contrib.contenttypes',
    # 'django.contrib.sessions',
    # 'django.contrib.messages',
    # 'django.contrib.staticfiles',
)

MIDDLEWARE_CLASSES = (
    # 'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'witchery.middleware.PingMiddleware',
    # 'django.middleware.csrf.CsrfViewMiddleware',
    'django_yauth.middleware.YandexAuthMiddleware',
    # 'django.contrib.auth.middleware.AuthenticationMiddleware',
    # 'django.contrib.auth.middleware.SessionAuthenticationMiddleware',
    # 'django.contrib.messages.middleware.MessageMiddleware',
    # 'django.middleware.clickjacking.XFrameOptionsMiddleware',
    'django.middleware.security.SecurityMiddleware',
)

ROOT_URLCONF = 'witchery.urls'

# TEMPLATES = [
#     {
#         'BACKEND': 'django.template.backends.django.DjangoTemplates',
#         'DIRS': [],
#         'APP_DIRS': True,
#         'OPTIONS': {
#             'context_processors': [
#                 'django.template.context_processors.debug',
#                 'django.template.context_processors.request',
#                 'django.contrib.auth.context_processors.auth',
#                 'django.contrib.messages.context_processors.messages',
#             ],
#         },
#     },
# ]

WSGI_APPLICATION = 'witchery.wsgi.application'

# Database
# https://docs.djangoproject.com/en/1.8/ref/settings/#databases

# DATABASES = {
#     'default': {
#         'ENGINE': 'django.db.backends.sqlite3',
#         'NAME': os.path.join(BASE_DIR, 'db.sqlite3'),
#     }
# }


# Internationalization
# https://docs.djangoproject.com/en/1.8/topics/i18n/

LANGUAGE_CODE = 'en-us'

TIME_ZONE = 'UTC'

USE_I18N = True

USE_L10N = True

USE_TZ = True


# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/1.8/howto/static-files/

# STATIC_URL = '/static/'
