import os

from datetime import date, timedelta


class CONST:
    ACTIVE = int(os.getenv('BOT_ACTIVE', 0))
    QUEUES = os.getenv('BOT_QUEUES').split(',')
    OAUTH_TOKEN = os.getenv('BOT_OAUTH_TOKEN')

    ST_HOST = 'https://st-api.yandex-team.ru'
    ST_ISSUE_SEARCH_URL = ST_HOST + '/v2/issues/_search'
    ST_ISSUE_COUNT_URL = ST_HOST + '/v2/issues/_count'
    ST_CHANGELOG_URL = ST_HOST + '/v2/issues/%(issue_key)s/changelog'
    ST_TRANSITION_URL = ST_HOST + '/v2/issues/%(issue_key)s/transitions/will_not_fix/_execute'
    HEADERS = {
        'Authorization': 'OAuth %s' % OAUTH_TOKEN,
        'Content-Type': 'application/json',
    }
    MONTH_TS = date.today() - timedelta(days=30)
    COMMENT = (
        'Тикет закрыт, поскольку по задаче месяц не было новостей, '
        'если задача станет актуальной - переоткройте, пожалуйста, '
        'тикет с обновлением по задаче. Если в тикете обсуждалось '
        'согласование договора, иного документа и документ был подписан, '
        'то приложите, пожалуйста, скан.'
    )
    PAGE_SIZE = 15
    ST_ISSUES_QUERY = {'filter': {'queue': QUEUES, 'status': 'needInfo'}}
