import sys
import logging
from ylog.format import QloudJsonFormatter


def get_logger():
    logger = getattr(get_logger, 'logger_cache', None)
    if logger is None:
        logger = logging.getLogger('bot')
        logger.setLevel(logging.DEBUG)
        ch = logging.StreamHandler(sys.stdout)
        ch.setLevel(logging.DEBUG)
        ch.setFormatter(QloudJsonFormatter())
        logger.addHandler(ch)
        setattr(get_logger, 'logger_cache', logger)
    return logger
