from datetime import date


def to_date(data):
    return date(*[int(f) for f in data[:10].split('-')])


class Issue:
    def __init__(self, data):
        self._data = data
        self.author = data['createdBy']['id']
        self.created_at = to_date(data['createdAt'])
        self.assignee = data.get('assignee') and data['assignee']['id']
        self.key = data['key']


class Event:
    def __init__(self, issue, data):
        self._data = data
        self.issue = issue
        self.id = data['id']
        self.author = data['updatedBy']['id']
        self.date = to_date(data['updatedAt'])
        self.type = data['type']
        self.comment_added = 'added' in data.get('comments', {})
        self.comment_updated = 'updated' in data.get('comments', {})
