from fastapi import FastAPI


def csrf_exempt(func):
    func.csrf_exempt = True
    return func


async def collect_csrf_exempt(app: FastAPI):
    csrf_exempt_endpoints = set()
    for route in app.routes:
        if getattr(route.endpoint, 'csrf_exempt', False):
            csrf_exempt_endpoints.add(route.path_regex)
    app.state.csrf_exempt_endpoints = csrf_exempt_endpoints
