#!/bin/bash

set -o errexit
set -o pipefail
set -o nounset

RED='\033[0;31m'
GREEN='\033[0;32m'
NC='\033[0m' # No Color

function failed {
  printf "${RED}$@${NC}\n"
}

function success {
  printf "${GREEN}$@${NC}\n"
}

urlconf=$1
echo -n "Check ${urlconf} schema... "

tmp_file=$(mktemp /tmp/lms-swagger.XXXXXX)
swagger_file=schema/${urlconf}.json
origsha=($(sha1sum $swagger_file))

spectacular_args="--urlconf config.urls.${urlconf} --format openapi-json --lang ru_RU --file ${tmp_file}"
./manage.py spectacular $spectacular_args  &> /dev/null
gensha=($(sha1sum ${tmp_file}))


if [[ ! $gensha == $origsha ]]; then
  echo $(failed failed)
  diff -u $swagger_file $tmp_file
  echo "${swagger_file} is outdated!"
  rm ${tmp_file} &> /dev/null
  exit 1
else
  echo $(success done)
fi

rm ${tmp_file} &> /dev/null
