from drf_spectacular.views import SpectacularAPIView, SpectacularSwaggerView

from django.conf import settings
from django.conf.urls import include, url
from django.conf.urls.static import static
from django.contrib import admin
from django.urls import path
from django.views import defaults as default_views
from django.views.generic import TemplateView

from lms.contrib.ping.views import PingView
from lms.contrib.s3upload.views import get_upload_params
from lms.tracker import urls as tracker_urls

from . import api as api_urls
from . import externalapi as external_api_urls
from . import index_api as index_api_urls
from . import labapi as labapi_urls

urlpatterns = [
    path("", TemplateView.as_view(template_name="pages/home.html"), name="home"),
    path("ping/", PingView.as_view(), name="ping"),
    path("get_upload_params/", get_upload_params, name="s3upload")
] + static(settings.MEDIA_URL, document_root=settings.MEDIA_ROOT)

# Django Admin, use {% url 'admin:index' %}
if settings.ADMIN_ENABLED:
    urlpatterns += [
        path(settings.ADMIN_URL, admin.site.urls),
    ]

# drf-spectacular
if settings.SWAGGER_ENABLED:
    if settings.API_ENABLED:
        urlpatterns += [
            path('api/schema/', SpectacularAPIView.as_view(urlconf='config.urls.api'), name='api-schema'),
            path('api/schema/swagger/', SpectacularSwaggerView.as_view(url_name='api-schema'), name='swagger-ui'),
        ]

        urlpatterns += [
            path('labapi/schema/', SpectacularAPIView.as_view(urlconf='config.urls.labapi'), name='labapi-schema'),
            path('labapi/schema/swagger/', SpectacularSwaggerView.as_view(url_name='labapi-schema'), name='swagger-ui'),
        ]

        urlpatterns += [
            path(
                'index_api/schema/',
                SpectacularAPIView.as_view(urlconf='config.urls.index_api'),
                name='index_api-schema'
            ),
            path(
                'index_api/schema/swagger/',
                SpectacularSwaggerView.as_view(url_name='index_api-schema'),
                name='swagger-ui'
            ),
        ]

    urlpatterns += [
        path(settings.TRACKER_API_BASE_URL, include([
            path(
                'schema/',
                SpectacularAPIView.as_view(urlconf='lms.tracker.urls'),
                name='tracker-schema',
            ),
            path(
                'schema/swagger/',
                SpectacularSwaggerView.as_view(url_name='tracker-schema'),
                name='swagger-ui',
            ),
        ])),
    ]

    if settings.EXTERNAL_API_ENABLED:
        urlpatterns += [
            path(settings.EXTERNAL_API_BASE_URL, include([
                path(
                    'schema/',
                    SpectacularAPIView.as_view(urlconf='config.urls.externalapi'),
                    name='external_api-schema'
                ),
                path(
                    'schema/swagger/',
                    SpectacularSwaggerView.as_view(url_name='external_api-schema'),
                    name='swagger-ui'
                ),
            ]))
        ]

if settings.API_ENABLED:
    # API v1
    urlpatterns += [
        path('', include(api_urls)),
    ]

    # LabAPI v1
    urlpatterns += [
        path('', include(labapi_urls)),
    ]

    # IndexAPI v1
    urlpatterns += [
        path('', include(index_api_urls)),
    ]

if settings.EXTERNAL_API_ENABLED:
    urlpatterns += [
        path('', include(external_api_urls)),
    ]

# IDM API v1
urlpatterns += [
    url('idm/', include('django_idm_api.urls')),
]

# Tracker API
urlpatterns += [
    path(settings.TRACKER_API_BASE_URL, include(tracker_urls)),
]

if settings.DEBUG:
    # This allows the error pages to be debugged during development, just visit
    # these url in browser to see how these error pages look like.
    urlpatterns += [
        path(
            "400/",
            default_views.bad_request,
            kwargs={"exception": Exception("Bad Request!")},
        ),
        path(
            "403/",
            default_views.permission_denied,
            kwargs={"exception": Exception("Permission Denied")},
        ),
        path(
            "404/",
            default_views.page_not_found,
            kwargs={"exception": Exception("Page not Found")},
        ),
        path("500/", default_views.server_error),
    ]

    if "debug_toolbar" in settings.INSTALLED_APPS:
        import debug_toolbar

        urlpatterns = [path("__debug__/", include(debug_toolbar.urls))] + urlpatterns
