from django.conf import settings
from django.urls import include, path

from lms.assignments.views.api import AssignmentStudentResultViewSet, AssignmentViewSet
from lms.classrooms.views.api import (
    ClassroomTimeslotCancelViewSet, ClassroomTimeslotChangeViewSet, ClassroomTimeslotCheckinViewSet, ClassroomViewSet,
    StudentClassroomTimeslotViewSet, TimeslotExchangeAcceptViewSet, TimeslotExchangeCreateViewSet,
    TimeslotExchangeViewSet,
)
from lms.courses.views.api import (
    CourseBlockViewSet, CourseCategoriesViewSet, CourseCategoryViewSet, CourseCityViewSet, CourseGroupViewSet,
    CourseModuleStudentCompleteViewSet, CourseModuleViewSet, CoursePermissionsViewSet, CourseSlugViewSet,
    CourseStudentCompleteViewSet, CourseViewSet, LinkedCourseViewSet, ProviderViewSet, StudentModuleProgressViewSet,
    StudyModeViewSet, TutorViewSet,
)
from lms.enrollments.survey.urls import urlpatterns as survey_dataset_urls
from lms.enrollments.views.api import (
    CourseEnrollmentViewSet, EnrolledUserViewSet, EnrollmentViewSet, EnrollSurveyViewSet, UserEnrollViewSet,
)
from lms.mailing.views.api import CourseFollowViewSet, CourseMailingViewSet, MyCourseFollowsListViewSet
from lms.mentorships.views.api import UserColleagueViewSet
from lms.preferences.views.api import ColorThemeViewSet
from lms.resources.views.api import LinkResourceViewSet, TextResourceViewSet, VideoResourceViewSet
from lms.scorm.views.api import ScormResourceStudentAttemptViewSet, ScormStudentAttemptViewSet, ScormViewSet
from lms.staff.views.api import UserStaffProfileViewSet
from lms.tags.views.api import TagViewSet, UserTagViewSet
from lms.tracker.views.api import EnrolledUserTrackerIssueViewSet, StudentSlotTrackerIssueViewSet
from lms.users.views.api import UserPermissionsViewSet, UserViewSet

study_mode_list = StudyModeViewSet.as_view({
    'get': 'list',
})

course_list = CourseViewSet.as_view({
    'get': 'list',
})

course_detail = CourseViewSet.as_view({
    'get': 'retrieve',
})

course_slug = CourseSlugViewSet.as_view({
    'get': 'retrieve',
})

course_category_list = CourseCategoryViewSet.as_view({
    'get': 'list',
})

course_category_detail = CourseCategoryViewSet.as_view({
    'get': 'retrieve',
})

course_categories_list = CourseCategoriesViewSet.as_view({
    'get': 'list',
})

course_city_list = CourseCityViewSet.as_view({
    'get': 'list',
})

provider_list = ProviderViewSet.as_view({
    'get': 'list',
})

course_group_list = CourseGroupViewSet.as_view({
    'get': 'list',
})

course_enrollment_list = CourseEnrollmentViewSet.as_view({
    'get': 'list',
})

course_module_list = CourseModuleViewSet.as_view({
    'get': 'list',
})

course_module_detail = CourseModuleViewSet.as_view({
    'get': 'retrieve',
})

course_block_list = CourseBlockViewSet.as_view({
    'get': 'list',
})

course_block_detail = CourseBlockViewSet.as_view({
    'get': 'retrieve',
})

course_classroom_list = ClassroomViewSet.as_view({
    'get': 'list',
})

classroom_detail = ClassroomViewSet.as_view({
    'get': 'retrieve',
})

scorm_detail = ScormViewSet.as_view({
    'get': 'retrieve',
})

user_scorm_attempt_create = ScormStudentAttemptViewSet.as_view({
    'post': 'create',
})

user_scorm_detail = ScormStudentAttemptViewSet.as_view({
    'get': 'retrieve',
    'post': 'new_attempt',  # TODO убрать, оставил для совместимости
})

user_scorm_resource_detail = ScormResourceStudentAttemptViewSet.as_view({
    'get': 'retrieve',
    'put': 'update',
})

classroom_timeslot_checkin = ClassroomTimeslotCheckinViewSet.as_view({
    'post': 'create',
})

classroom_timeslot_cancel = ClassroomTimeslotCancelViewSet.as_view({
    'post': 'create',
})

classroom_timeslot_change = ClassroomTimeslotChangeViewSet.as_view({
    'post': 'create',
})

timeslot_exchange_create = TimeslotExchangeCreateViewSet.as_view({
    'put': 'update',
})

timeslot_exchange_detail = TimeslotExchangeViewSet.as_view({
    'get': 'retrieve',
})

timeslot_exchange_accept = TimeslotExchangeAcceptViewSet.as_view({
    'post': 'create',
})

text_resource_detail = TextResourceViewSet.as_view({
    'get': 'retrieve',
})

link_resource_detail = LinkResourceViewSet.as_view({
    'get': 'retrieve',
})

video_resource_detail = VideoResourceViewSet.as_view({
    'get': 'retrieve',
})

assignment_detail = AssignmentViewSet.as_view({
    'get': 'retrieve',
})

linked_course_detail = LinkedCourseViewSet.as_view({
    'get': 'retrieve',
})

user_assignment_detail = AssignmentStudentResultViewSet.as_view({
    'get': 'retrieve',
})

assignment_complete = AssignmentStudentResultViewSet.as_view({
    'post': 'set_completed',
})

assignment_incomplete = AssignmentStudentResultViewSet.as_view({
    'post': 'set_incomplete',
})

enrollment_detail = EnrollmentViewSet.as_view({
    'get': 'retrieve',
})

enroll_survey_detail = EnrollSurveyViewSet.as_view({
    'get': 'retrieve',
})

enrolled_user_list = EnrolledUserViewSet.as_view({
    'post': 'create',
})

color_themes_list = ColorThemeViewSet.as_view({
    'get': 'list',
})

user_profile_detail = UserViewSet.as_view({
    'get': 'retrieve',
    'put': 'update',
    'patch': 'partial_update',
})

user_profile_create = UserViewSet.as_view({
    'post': 'create',
})

enroller_user_tracker_issue_list = EnrolledUserTrackerIssueViewSet.as_view({
    'get': 'list',
})

student_slot_tracker_issue_list = StudentSlotTrackerIssueViewSet.as_view({
    'get': 'list',
})

user_permission_list = UserPermissionsViewSet.as_view({
    'get': 'list',
})

user_course_permission_list = CoursePermissionsViewSet.as_view({
    'get': 'list',
})

user_classroom_timeslot_list = StudentClassroomTimeslotViewSet.as_view({
    'get': 'list',
})

user_classroom_timeslot_detail = StudentClassroomTimeslotViewSet.as_view({
    'delete': 'destroy',
})

course_mailing_list = CourseMailingViewSet.as_view({
    'get': 'list',
})

course_follow = CourseFollowViewSet.as_view({
    'post': 'follow',
})

course_unfollow = CourseFollowViewSet.as_view({
    'post': 'unfollow',
})

user_course_follows = MyCourseFollowsListViewSet.as_view({
    'get': 'list',
})

tutor_detail = TutorViewSet.as_view({
    'get': 'retrieve',
})

my_enroll_list = UserEnrollViewSet.as_view({
    'get': 'list',
})

my_enroll_detail = UserEnrollViewSet.as_view({
    'get': 'retrieve',
})

my_course_complete = CourseStudentCompleteViewSet.as_view({
    'put': 'set_complete',
})

student_module_progress_list = StudentModuleProgressViewSet.as_view({
    'get': 'list',
})

tag_list = TagViewSet.as_view({
    'get': 'list',
})

user_tag_list = UserTagViewSet.as_view({
    'get': 'list',
    'put': 'update',
})

user_colleague_list = UserColleagueViewSet.as_view({
    'get': 'list',
})

user_colleague_detail = UserColleagueViewSet.as_view({
    'get': 'retrieve',
})

user_staff_profile_detail = UserStaffProfileViewSet.as_view({
    'get': 'retrieve',
})

course_module_complete = CourseModuleStudentCompleteViewSet.as_view({
    'put': 'set_complete',
})

app_name = 'api'
urlpatterns = [
    path(settings.API_BASE_URL, include([
        path('studymodes/', study_mode_list, name='studymode-list'),
        path('providers/', provider_list, name='provider-list'),
        path('course_cities/', course_city_list, name='course-city-list'),
        path('course_categories/', course_category_list, name='course-category-list'),
        path('course_categories/<int:pk>/', course_category_detail, name='course-category-detail'),
        path('course_slug/<slug:slug>/', course_slug, name='course-slug-detail'),
        path('course_modules/<int:pk>/', course_module_detail, name='course-module-detail'),
        path('course_blocks/<int:pk>/', course_block_detail, name='course-block-detail'),
        path('courses/', course_list, name='course-list'),
        path('courses/<int:pk>/', course_detail, name='course-detail'),
        path('courses/<int:pk>/groups/', course_group_list, name='course-groups'),
        path('courses/<int:pk>/categories/', course_categories_list, name='course-categories'),
        path('courses/<int:pk>/enrollments/', course_enrollment_list, name='course-enrollments'),
        path('courses/<int:pk>/enroll/', enrolled_user_list, name='course-enroll'),
        path('courses/<int:pk>/modules/', course_module_list, name='course-modules'),
        path('courses/<int:pk>/blocks/', course_block_list, name='course-blocks'),
        path('courses/<int:pk>/classroom_modules/', course_classroom_list, name='course-classroom-list'),
        path('courses/<int:pk>/mailings/', course_mailing_list, name='course-mailing-list'),
        path('courses/<int:pk>/follow/', course_follow, name='course-follow'),
        path('courses/<int:pk>/unfollow/', course_unfollow, name='course-unfollow'),
        path('classroom_modules/<int:pk>/', classroom_detail, name='classroom-detail'),
        path('classroom_timeslots/<int:pk>/checkin/', classroom_timeslot_checkin, name='classroom-timeslot-checkin'),
        path('classroom_timeslots/<int:pk>/cancel/', classroom_timeslot_cancel, name='classroom-timeslot-cancel'),
        path('classroom_timeslots/<int:pk>/change/', classroom_timeslot_change, name='classroom-timeslot-change'),
        path('classroom_timeslots/<int:pk>/exchange/', timeslot_exchange_create, name='timeslot-exchange-create'),
        path('timeslot_exchanges/<uuid:pk>/', timeslot_exchange_detail, name='timeslot-exchange-detail'),
        path('timeslot_exchanges/<uuid:pk>/accept/', timeslot_exchange_accept, name='timeslot-exchange-accept'),
        path('scorm_modules/<int:pk>/', scorm_detail, name='scorm-detail'),
        path('textresource_modules/<int:pk>/', text_resource_detail, name='textresource-detail'),
        path('linkresource_modules/<int:pk>/', link_resource_detail, name='linkresource-detail'),
        path('videoresource_modules/<int:pk>/', video_resource_detail, name='videoresource-detail'),
        path('assignment_modules/<int:pk>/', assignment_detail, name='assignment-detail'),
        path('linkedcourse_modules/<int:pk>/', linked_course_detail, name='linked-course-detail'),
        path('enrollments/<int:pk>/', enrollment_detail, name='enrollment-detail'),
        path('enrollment_surveys/<int:pk>/', enroll_survey_detail, name='enroll-survey-detail'),
        path('color_themes/', color_themes_list, name='color-theme-list'),
        path('tutors/<int:pk>/', tutor_detail, name='tutor-detail'),
        path('tags/', tag_list, name='tag-list'),
        path('my/courses/<int:pk>/permissions/', user_course_permission_list, name='my-course-permissions'),
        path('my/classroom_modules/<int:pk>/timeslots/', user_classroom_timeslot_list, name='my-classroom-timeslots'),
        path('my/classroom_timeslots/<int:pk>/', user_classroom_timeslot_detail, name='my-classroom-timeslot-detail'),
        path('my/enroll/', my_enroll_list, name='my-enroll'),
        path('my/enroll/<int:pk>/', my_enroll_detail, name='my-enroll-detail'),
        # TODO добавить my/enroll/<int:pk>/complete/
        path('my/enroll/<int:pk>/tracker_issues/', enroller_user_tracker_issue_list, name='my-enroll-tracker-issues'),
        path(
            'my/timeslots/<int:pk>/tracker_issues/',
            student_slot_tracker_issue_list,
            name='my-timeslot-tracker-issues',
        ),
        path('my/profile/', user_profile_detail, name='my-profile'),
        path('my/permissions/', user_permission_list, name='my-permissions'),
        path('my/course_follows/', user_course_follows, name='user-course-follows'),
        path('my/scorm_modules/', user_scorm_attempt_create, name='my-scorm-attempt-create'),
        path('my/scorm_modules/<int:pk>/', user_scorm_detail, name='my-scorm-detail'),
        path('my/scorm_resources/<int:pk>/', user_scorm_resource_detail, name='my-scorm-resource-detail'),
        path('my/staff/profile/', user_staff_profile_detail, name='my-staff-profile-detail'),
        path('my/tags/', user_tag_list, name='my-tags'),
        path('my/assignment_modules/<int:pk>/', user_assignment_detail, name='my-assignment-detail'),
        path('my/assignment_modules/<int:pk>/complete/', assignment_complete, name='my-assignment-complete'),
        path('my/assignment_modules/<int:pk>/incomplete/', assignment_incomplete, name='my-assignment-incomplete'),
        path('my/courses/', my_enroll_list, name='my-courses'),  # TODO убрать, оставил для совместимости
        path('my/courses/<int:pk>/complete/', my_course_complete, name='my-course-complete'),
        path('my/courses/<int:pk>/modules/', student_module_progress_list, name='my-course-module-list'),
        path('my/course_modules/<int:pk>/complete/', course_module_complete, name='my-course-module-complete'),
        path('my/colleagues/', user_colleague_list, name='my-colleague-list'),
        path('my/colleagues/<int:pk>/', user_colleague_detail, name='my-colleague-detail'),
        path('users/', user_profile_create, name='user-create'),
        path(settings.DATASET_BASE_URL, include(survey_dataset_urls)),
    ])),
]
