from django.conf import settings
from django.urls import include, path

from lms.courses.views.externalapi import CourseExternalViewSet, CourseResultsExternalViewSet

course_list = CourseExternalViewSet.as_view({
    'get': 'list',
})

course_results_list = CourseResultsExternalViewSet.as_view({
    'get': 'list',
})

app_name = 'externalapi'
urlpatterns = [
    path(f'{settings.EXTERNAL_API_BASE_URL}v1/', include([
        path('courses/', course_list, name='course-list'),
        path('courses/<int:course_id>/results/', course_results_list, name='course-results-list'),
    ]))
]
