from django.conf import settings
from django.urls import include, path

from lms.courses.views.index_api import CourseIndexViewSet

course_index_list = CourseIndexViewSet.as_view({
    'get': 'list',
})

course_index_detail = CourseIndexViewSet.as_view({
    'get': 'retrieve',
})

app_name = 'index_api'
urlpatterns = [
    path(settings.INDEX_API_BASE_URL, include([
        path('courses/', course_index_list, name='course-index-list'),
        path('courses/<int:pk>/', course_index_detail, name='course-index-detail'),
    ])),
]
