from django.conf import settings
from django.urls import include, path  # noqa

from lms.assignments.views.labapi import AssignmentLabViewSet
from lms.classrooms.views.labapi import (
    ClassroomLabViewSet, ClassroomTimeslotLabViewSet, ClassroomTimeslotStudentListLabViewSet,
)
from lms.courses.views.labapi import (
    CohortLabViewSet, CourseBlockLabViewSet, CourseCalendarViewSet, CourseCategoriesLabViewSet,
    CourseCategoryLabViewSet, CourseCityLabViewSet, CourseFileLabViewSet, CourseGroupLabViewSet, CourseLabViewSet,
    CourseModuleLabViewSet, CoursePermissionsLabViewSet, CourseProgressLabViewSet, CourseProgressRecalculateLabViewSet,
    CourseSlugLabViewSet, CourseStudentLabViewSet, CourseTeamInCourseLabViewSet, CourseTeamLabViewSet,
    CourseTeamMemberListLabViewSet, CourseVisibilityCheckLabViewSet, CourseVisibilityLabViewSet,
    CourseWorkflowLabViewSet, LinkedCourseLabViewSet, ProviderLabViewSet, StudyModeLabViewSet, TutorLabViewSet,
)
from lms.enrollments.views.labapi import (
    EnrollmentInstantLabViewSet, EnrollmentLabViewSet, EnrollmentManualLabViewSet, EnrollSurveyLabViewSet,
)
from lms.mailing.views.labapi import CourseFollowerLabViewSet, CourseMailingLabViewSet, MailingLabViewSet
from lms.moduletypes.views.labapi import ModuleTypeLabViewSet
from lms.preferences.views.labapi import ColorThemeLabViewSet
from lms.reports.views.labapi import EnrolledUsersReportLabViewSet, ReportFileLabViewSet, StudentSlotsReportLabViewSet
from lms.resources.views.labapi import LinkResourceLabViewSet, TextResourceLabViewSet, VideoResourceLabViewSet
from lms.scorm.views.labapi import ScormFileLabViewSet, ScormLabViewSet
from lms.staff.views.labapi import (
    StaffCityLabViewSet, StaffCountryLabViewSet, StaffGroupLabViewSet, StaffLanguageLabViewSet, StaffOfficeLabViewSet,
)
from lms.tags.views.labapi import TagLabViewSet
from lms.tracker.views.labapi import (
    ClassroomQueueLabViewSet, ClassroomTrackerQueueLabViewSet, ClassroomWithTrackerQueueLabViewSet,
    EnrolledUserLabViewSet, EnrollmentQueueLabViewSet, EnrollmentTrackerQueueLabViewSet, EnrollmentTrackerViewSet,
    TrackerQueueLabViewSet,
)
from lms.users.views.labapi import UserLabViewSet, UserPermissionsLabViewSet

course_student_list = CourseStudentLabViewSet.as_view({
    'get': 'list',
})

enrollment_queue_list = EnrollmentQueueLabViewSet.as_view({
    'get': 'list',
})

enrollment_instant_detail = EnrollmentInstantLabViewSet.as_view({
    'get': 'retrieve',
    'put': 'update',
    'patch': 'partial_update',
    'delete': 'destroy',
})

enrollment_instant_create = EnrollmentInstantLabViewSet.as_view({
    'post': 'create',
})

enrollment_manual_detail = EnrollmentManualLabViewSet.as_view({
    'get': 'retrieve',
    'put': 'update',
    'patch': 'partial_update',
    'delete': 'destroy',
})

enrollment_manual_create = EnrollmentManualLabViewSet.as_view({
    'post': 'create',
})

enrollment_tracker_detail = EnrollmentTrackerViewSet.as_view({
    'get': 'retrieve',
    'put': 'update',
    'patch': 'partial_update',
    'delete': 'destroy',
})

enrollment_tracker_create = EnrollmentTrackerViewSet.as_view({
    'post': 'create',
})

report_file_detail = ReportFileLabViewSet.as_view({
    'get': 'retrieve',
})

enrolled_users_report_create = EnrolledUsersReportLabViewSet.as_view({
    'post': 'create',
})

student_slots_report_create = StudentSlotsReportLabViewSet.as_view({
    'post': 'create',
})

cohort_list = CohortLabViewSet.as_view({
    'get': 'list',
})

cohort_create = CohortLabViewSet.as_view({
    'post': 'create',
})

cohort_detail = CohortLabViewSet.as_view({
    'get': 'retrieve',
    'put': 'update',
    'patch': 'partial_update',
    'delete': 'destroy',
})

workflow_list = CourseWorkflowLabViewSet.as_view({
    'get': 'list',
})
study_mode_list = StudyModeLabViewSet.as_view({
    'get': 'list',
})

provider_list = ProviderLabViewSet.as_view({
    'get': 'list',
})

course_city_list = CourseCityLabViewSet.as_view({
    'get': 'list',
})

course_list = CourseLabViewSet.as_view({
    'get': 'list',
    'post': 'create',
})

course_detail = CourseLabViewSet.as_view({
    'get': 'retrieve',
    'put': 'update',
    'patch': 'partial_update',
})

course_slug_validate = CourseSlugLabViewSet.as_view({
    'get': 'validate',
})

course_category_list = CourseCategoryLabViewSet.as_view({
    'get': 'list',
})

course_category_detail = CourseCategoryLabViewSet.as_view({
    'get': 'retrieve',
})

course_categories_list = CourseCategoriesLabViewSet.as_view({
    'get': 'list',
})

course_visibility_detail = CourseVisibilityLabViewSet.as_view({
    'get': 'retrieve',
    'put': 'update',
    'delete': 'destroy',
})

course_visibility_check = CourseVisibilityCheckLabViewSet.as_view({
    'get': 'retrieve',
})

color_theme_list = ColorThemeLabViewSet.as_view({
    'get': 'list',
})

enrollment_tracker_queue_list = EnrollmentTrackerQueueLabViewSet.as_view({
    'get': 'list',
})

enrollment_tracker_queue_create = EnrollmentTrackerQueueLabViewSet.as_view({
    'post': 'create',
})

enrollment_tracker_queue_detail = EnrollmentTrackerQueueLabViewSet.as_view({
    'get': 'retrieve',
    'put': 'update',
    'patch': 'partial_update',
    'delete': 'destroy',
})

tracker_queue_list = TrackerQueueLabViewSet.as_view({
    'get': 'list',
})

classroom_tracker_queue_list = ClassroomTrackerQueueLabViewSet.as_view({
    'get': 'list',
})

classroom_tracker_queue_create = ClassroomTrackerQueueLabViewSet.as_view({
    'post': 'create',
})

classroom_tracker_queue_detail = ClassroomTrackerQueueLabViewSet.as_view({
    'get': 'retrieve',
    'delete': 'destroy',
})

enroll_survey_form_list = EnrollSurveyLabViewSet.as_view({
    'get': 'list',
})

enroll_survey_form_detail = EnrollSurveyLabViewSet.as_view({
    'get': 'retrieve',
})

enrolled_user_list = EnrolledUserLabViewSet.as_view({
    'get': 'list',
})

enrolled_user_detail = EnrolledUserLabViewSet.as_view({
    'patch': 'partial_update',
})

enrollment_lab_list = EnrollmentLabViewSet.as_view({
    'get': 'list',
})

enrollment_lab_create = EnrollmentLabViewSet.as_view({
    'post': 'create',
})

enrollment_lab_detail = EnrollmentLabViewSet.as_view({
    'get': 'retrieve',
    'put': 'update',
    'patch': 'partial_update',
    'delete': 'destroy',
})

course_group_lab_list = CourseGroupLabViewSet.as_view({
    'get': 'list',
})

course_group_lab_create = CourseGroupLabViewSet.as_view({
    'post': 'create',
})

course_group_lab_detail = CourseGroupLabViewSet.as_view({
    'get': 'retrieve',
    'put': 'update',
    'patch': 'partial_update',
    'delete': 'destroy',
})

course_slug = CourseSlugLabViewSet.as_view({
    'get': 'retrieve',
})

staff_language_list = StaffLanguageLabViewSet.as_view({
    'get': 'list',
})

staff_city_list = StaffCityLabViewSet.as_view({
    'get': 'list',
})

staff_office_list = StaffOfficeLabViewSet.as_view({
    'get': 'list',
})

staff_country_list = StaffCountryLabViewSet.as_view({
    'get': 'list',
})

staff_department_list = StaffGroupLabViewSet.as_view({
    'get': 'list',
})

staff_department_detail = StaffGroupLabViewSet.as_view({
    'get': 'retrieve',
})

user_profile_detail = UserLabViewSet.as_view({
    'get': 'retrieve',
    'put': 'update',
    'patch': 'partial_update',
})

user_permission_list = UserPermissionsLabViewSet.as_view({
    'get': 'list',
})

user_course_permission_list = CoursePermissionsLabViewSet.as_view({
    'get': 'list'
})

course_team_lab_list = CourseTeamLabViewSet.as_view({
    'get': 'list',
    'post': 'create',
})

course_team_lab_detail = CourseTeamLabViewSet.as_view({
    'get': 'retrieve',
    'put': 'update',
    'patch': 'partial_update',
    'delete': 'destroy',
})

course_team_members = CourseTeamMemberListLabViewSet.as_view({
    'get': 'list',
    'put': 'update',
    'delete': 'destroy',
})

course_course_teams = CourseTeamInCourseLabViewSet.as_view({
    'get': 'list',
    'put': 'update',
    'delete': 'destroy',
})

moduletype_list = ModuleTypeLabViewSet.as_view({
    'get': 'list',
})

course_module_list = CourseModuleLabViewSet.as_view({
    'get': 'list',
})

course_module_detail = CourseModuleLabViewSet.as_view({
    'get': 'retrieve',
})

course_module_move_up = CourseModuleLabViewSet.as_view({'put': 'move_up'})
course_module_move_down = CourseModuleLabViewSet.as_view({'put': 'move_down'})
course_module_move_top = CourseModuleLabViewSet.as_view({'put': 'move_top'})
course_module_move_bottom = CourseModuleLabViewSet.as_view({'put': 'move_bottom'})
course_module_move_above = CourseModuleLabViewSet.as_view({'put': 'move_above'})
course_module_move_below = CourseModuleLabViewSet.as_view({'put': 'move_below'})

course_block_list = CourseBlockLabViewSet.as_view({
    'get': 'list',
})

course_block_create = CourseBlockLabViewSet.as_view({
    'post': 'create',
})

course_block_detail = CourseBlockLabViewSet.as_view({
    'get': 'retrieve',
    'put': 'update',
    'patch': 'partial_update',
    'delete': 'destroy',
})

course_block_move_above = CourseBlockLabViewSet.as_view({'put': 'move_above'})
course_block_move_below = CourseBlockLabViewSet.as_view({'put': 'move_below'})

course_progress_list = CourseProgressLabViewSet.as_view({
    'get': 'list',
})

course_progress_recalculate = CourseProgressRecalculateLabViewSet.as_view({
    'put': 'update',
})

course_classroom_list = ClassroomLabViewSet.as_view({
    'get': 'list',
})

classroom_create_with_tracker = ClassroomWithTrackerQueueLabViewSet.as_view({
    'post': 'create',
})

classroom_detail_with_tracker = ClassroomWithTrackerQueueLabViewSet.as_view({
    'get': 'retrieve',
    'put': 'update',
    'patch': 'partial_update',
    'delete': 'destroy',
})

classroom_queues_list = ClassroomQueueLabViewSet.as_view({
    'get': 'list',
})

classroom_timeslot_list = ClassroomTimeslotLabViewSet.as_view({
    'get': 'list',
})

classroom_timeslot_create = ClassroomTimeslotLabViewSet.as_view({
    'post': 'create',
})

classroom_timeslot_detail = ClassroomTimeslotLabViewSet.as_view({
    'get': 'retrieve',
    'put': 'update',
    'patch': 'partial_update',
    'delete': 'destroy',
})

scorm_create = ScormLabViewSet.as_view({
    'post': 'create',
})

scorm_detail = ScormLabViewSet.as_view({
    'get': 'retrieve',
    'put': 'update',
    'patch': 'partial_update',
    'delete': 'destroy',
})

course_file_create = CourseFileLabViewSet.as_view({
    'post': 'create',
})

scormfile_list = ScormFileLabViewSet.as_view({
    'get': 'list',
})

scormfile_create = ScormFileLabViewSet.as_view({
    'post': 'create',
})

scormfile_detail = ScormFileLabViewSet.as_view({
    'get': 'retrieve',
    'delete': 'destroy',
})

classroom_timeslot_student_list = ClassroomTimeslotStudentListLabViewSet.as_view({
    'get': 'list',
})

text_resource_create = TextResourceLabViewSet.as_view({
    'post': 'create',
})

text_resource_detail = TextResourceLabViewSet.as_view({
    'get': 'retrieve',
    'put': 'update',
    'patch': 'partial_update',
    'delete': 'destroy',
})

link_resource_create = LinkResourceLabViewSet.as_view({
    'post': 'create',
})

link_resource_detail = LinkResourceLabViewSet.as_view({
    'get': 'retrieve',
    'put': 'update',
    'patch': 'partial_update',
    'delete': 'destroy',
})

video_resource_create = VideoResourceLabViewSet.as_view({
    'post': 'create',
})

video_resource_detail = VideoResourceLabViewSet.as_view({
    'get': 'retrieve',
    'put': 'update',
    'patch': 'partial_update',
    'delete': 'destroy',
})

assignment_create = AssignmentLabViewSet.as_view({
    'post': 'create',
})

assignment_detail = AssignmentLabViewSet.as_view({
    'get': 'retrieve',
    'put': 'update',
    'patch': 'partial_update',
    'delete': 'destroy',
})

linked_course_create = LinkedCourseLabViewSet.as_view({
    'post': 'create',
})

linked_course_detail = LinkedCourseLabViewSet.as_view({
    'get': 'retrieve',
    'put': 'update',
    'patch': 'partial_update',
    'delete': 'destroy',
})

mailing_list = MailingLabViewSet.as_view({
    'get': 'list',
})

course_mailing_list = CourseMailingLabViewSet.as_view({
    'get': 'list',
})

course_mailing_create = CourseMailingLabViewSet.as_view({
    'post': 'create',
})

course_mailing_detail = CourseMailingLabViewSet.as_view({
    'get': 'retrieve',
    'put': 'update',
    'patch': 'update',
    'delete': 'destroy',
})

course_follower_list = CourseFollowerLabViewSet.as_view({
    'get': 'list',
})

tutor_list = TutorLabViewSet.as_view({
    'get': 'list',
})

tutor_detail = TutorLabViewSet.as_view({
    'get': 'retrieve',
})

course_calendar = CourseCalendarViewSet.as_view({
    'get': 'retrieve',
})

tag_create = TagLabViewSet.as_view({
    'get': 'list',
    'post': 'create',
})

tag_detail = TagLabViewSet.as_view({
    'get': 'retrieve',
    'put': 'update',
    'patch': 'partial_update',
    'delete': 'destroy',
})

app_name = 'labapi'
urlpatterns = [
    path(settings.LABAPI_BASE_URL, include([
        path('studymodes/', study_mode_list, name='studymode-list'),
        path('workflows/', workflow_list, name='workflow-list'),
        path('providers/', provider_list, name='provider-list'),
        path('course_cities/', course_city_list, name='course-city-list'),
        path('course_categories/', course_category_list, name='course-category-list'),
        path('course_categories/<int:pk>/', course_category_detail, name='course-category-detail'),
        path('course_slug/<str:slug>/validate/', course_slug_validate, name='course-slug-validate'),
        path('course_slug/<slug:slug>/', course_slug, name='course-slug-detail'),
        path('course_groups/', course_group_lab_create, name='course-group-create'),
        path('course_groups/<int:pk>/', course_group_lab_detail, name='course-group-detail'),
        path('course_mailings/', course_mailing_create, name='course-mailing-create'),
        path('course_mailings/<int:pk>/', course_mailing_detail, name='course-mailing-detail'),
        path('course_modules/<int:pk>/', course_module_detail, name='course-module-detail'),
        path('course_modules/<int:pk>/move_up/', course_module_move_up, name='course-module-move-up'),
        path('course_modules/<int:pk>/move_down/', course_module_move_down, name='course-module-move-down'),
        path('course_modules/<int:pk>/move_top/', course_module_move_top, name='course-module-move-top'),
        path('course_modules/<int:pk>/move_bottom/', course_module_move_bottom, name='course-module-move-bottom'),
        path('course_modules/<int:pk>/move_above/', course_module_move_above, name='course-module-move-above'),
        path('course_modules/<int:pk>/move_below/', course_module_move_below, name='course-module-move-below'),
        path('course_blocks/', course_block_create, name='course-block-create'),
        path('course_blocks/<int:pk>/', course_block_detail, name='course-block-detail'),
        path('course_blocks/<int:pk>/move_above/', course_block_move_above, name='course-block-move-above'),
        path('course_blocks/<int:pk>/move_below/', course_block_move_below, name='course-block-move-below'),
        path('course_teams/', course_team_lab_list, name='course-team-list'),
        path('course_teams/<int:pk>/', course_team_lab_detail, name='course-team-detail'),
        path('course_teams/<int:pk>/members/', course_team_members, name='course-team-members'),
        path('courses/', course_list, name='course-list'),
        path('courses/<int:pk>/', course_detail, name='course-detail'),
        path('courses/<int:pk>/groups/', course_group_lab_list, name='course-group-list'),
        path('courses/<int:pk>/visibility/', course_visibility_detail, name='course-visibility-list'),
        path('courses/<int:pk>/visibility/check/', course_visibility_check, name='course-visibility-check'),
        path('courses/<int:pk>/enrollments/', enrollment_lab_list, name='course-enrollment-list'),
        path('courses/<int:pk>/categories/', course_categories_list, name='course-categories'),
        path('courses/<int:pk>/teams/', course_course_teams, name='course-course-teams'),
        path('courses/<int:pk>/modules/', course_module_list, name='course-module-list'),
        path('courses/<int:pk>/blocks/', course_block_list, name='course-block-list'),
        path('courses/<int:pk>/classroom_modules/', course_classroom_list, name='course-classroom-list'),
        path('courses/<int:pk>/mailings/', course_mailing_list, name='course-mailing-list'),
        path('courses/<int:pk>/followers/', course_follower_list, name='course-follower-list'),
        path('courses/<int:pk>/enrolled_users/', enrolled_user_list, name='enrolled-user-list'),
        path(
            'courses/<int:pk>/reports/enrolled_users/',
            enrolled_users_report_create, name='enrolled-user-report-create',
        ),
        path(
            'courses/<int:pk>/reports/student_slots/',
            student_slots_report_create, name='student-slots-report-create',
        ),
        path('courses/<int:pk>/cohorts/', cohort_list, name='cohort-list'),
        path('courses/<int:pk>/students/', course_student_list, name='course-student-list'),
        path('courses/<int:pk>/calendar/', course_calendar, name='course-calendar'),
        path('courses/<int:pk>/progress/', course_progress_list, name='course-progress-list'),
        path('courses/<int:pk>/progress/recalculate/', course_progress_recalculate, name='course-progress-recalculate'),
        path('classroom_modules/', classroom_create_with_tracker, name='classroom-create'),
        path('classroom_modules/<int:pk>/', classroom_detail_with_tracker, name='classroom-detail'),
        path('classroom_queues/', classroom_queues_list, name='classroom-queues-list'),
        path('classroom_modules/<int:pk>/timeslots/', classroom_timeslot_list, name='classroom-timeslot-list'),
        path(
            'classroom_modules/<int:pk>/tracker_queues/',
            classroom_tracker_queue_list,
            name='classroom-tracker-queue-list',
        ),
        path('classroom_timeslots/', classroom_timeslot_create, name='classroom-timeslot-create'),
        path('classroom_timeslots/<int:pk>/', classroom_timeslot_detail, name='classroom-timeslot-detail'),
        path(
            'classroom_timeslots/<int:pk>/students/',
            classroom_timeslot_student_list,
            name='classroom-timeslot-student-list'
        ),
        path('course_files/', course_file_create, name='course-file-create'),
        path('scorm_modules/', scorm_create, name='scorm-create'),
        path('scorm_modules/<int:pk>/', scorm_detail, name='scorm-detail'),
        path('scorm_modules/<int:pk>/files/', scormfile_list, name='scorm-file-list'),
        path('scorm_files/', scormfile_create, name='scormfile-create'),
        path('scorm_files/<int:pk>/', scormfile_detail, name='scormfile-detail'),
        path('textresource_modules/', text_resource_create, name='textresource-create'),
        path('textresource_modules/<int:pk>/', text_resource_detail, name='textresource-detail'),
        path('linkresource_modules/', link_resource_create, name='linkresource-create'),
        path('linkresource_modules/<int:pk>/', link_resource_detail, name='linkresource-detail'),
        path('videoresource_modules/', video_resource_create, name='videoresource-create'),
        path('videoresource_modules/<int:pk>/', video_resource_detail, name='videoresource-detail'),
        path('assignment_modules/', assignment_create, name='assignment-create'),
        path('assignment_modules/<int:pk>/', assignment_detail, name='assignment-detail'),
        path('linkedcourse_modules/', linked_course_create, name='linked-course-create'),
        path('linkedcourse_modules/<int:pk>/', linked_course_detail, name='linked-course-detail'),
        path('color_themes/', color_theme_list, name='color-theme-list'),
        path('enrollments/', enrollment_lab_create, name='enrollment-create'),
        path('enrollments/<int:pk>/', enrollment_lab_detail, name='enrollment-detail'),
        path('enrollments/instant/', enrollment_instant_create, name='enrollment-instant-create'),
        path('enrollments/instant/<int:pk>/', enrollment_instant_detail, name='enrollment-instant-detail'),
        path('enrollments/manual/', enrollment_manual_create, name='enrollment-manual-create'),
        path('enrollments/manual/<int:pk>/', enrollment_manual_detail, name='enrollment-manual-detail'),
        path('enrollments/tracker/', enrollment_tracker_create, name='enrollment-tracker-create'),
        path('enrollments/tracker/<int:pk>/', enrollment_tracker_detail, name='enrollment-tracker-detail'),
        path('enrollment_surveys/', enroll_survey_form_list, name='enrollment-survey-form-list'),
        path('enrollment_surveys/<int:pk>/', enroll_survey_form_detail, name='enrollment-survey-form-detail'),
        path('enrolled_users/<int:pk>/', enrolled_user_detail, name='enrolled-user-detail'),
        path(
            'enrollments/<int:pk>/tracker_queues/',
            enrollment_tracker_queue_list,
            name='enrollment-tracker-queue-list',
        ),
        path('moduletypes/', moduletype_list, name='moduletype-list'),
        path(
            'tracker_queues/',  # TODO: отрефакторить до 'enrollment_tracker_queues/'
            enrollment_tracker_queue_create,
            name='enrollment-tracker-queue-create',
        ),
        path(
            'tracker_queues/<int:pk>/',  # TODO: отрефакторить до 'enrollment_tracker_queues/'
            enrollment_tracker_queue_detail,
            name='enrollment-tracker-queue-detail',
        ),
        # TODO: отрефакторить до 'tracker_queues/'
        path('tracker_queues_list/', tracker_queue_list, name='tracker-queue-list'),
        path(
            'classroom_tracker_queues/', classroom_tracker_queue_create, name='classroom-tracker-queue-create',
        ),
        path(
            'classroom_tracker_queues/<int:pk>/', classroom_tracker_queue_detail, name='classroom-tracker-queue-detail',
        ),
        path('staff/languages/', staff_language_list, name='staff-language-list'),
        path('staff/countries/', staff_country_list, name='staff-country-list'),
        path('staff/cities/', staff_city_list, name='staff-city-list'),
        path('staff/offices/', staff_office_list, name='staff-office-list'),
        path('staff/departments/', staff_department_list, name='staff-department-list'),
        path('staff/departments/<int:pk>/', staff_department_detail, name='staff-department-detail'),
        path('mailings/', mailing_list, name='mailing-list'),
        path('tutors/', tutor_list, name='tutor-list'),
        path('tutors/<int:pk>/', tutor_detail, name='tutor-detail'),
        path('tracker/enrollment_queues/', enrollment_queue_list, name='enrollment-queue-list'),
        path('reports/<uuid:pk>/', report_file_detail, name='report-file-detail'),
        path('cohorts/', cohort_create, name='cohort-create'),
        path('cohorts/<int:pk>/', cohort_detail, name='cohort-detail'),
        path('tags/', tag_create, name='tag-create'),
        path('tags/<int:pk>/', tag_detail, name='tag-detail'),
        path('my/courses/<int:pk>/permissions/', user_course_permission_list, name='my-course-permissions'),
        path('my/profile/', user_profile_detail, name='my-profile'),
        path('my/permissions/', user_permission_list, name='my-permissions'),
    ]))
]
