from django_admin_listfilter_dropdown.filters import RelatedOnlyDropdownFilter

from django.contrib import admin

from .models import ActionEvent, AddAchievementEvent, CourseTrigger


@admin.register(ActionEvent)
class ActionEventAdmin(admin.ModelAdmin):
    fields = (
        'status', 'description', 'message', 'event_type',
        'completion_date', 'created', 'modified',
    )
    list_display = (
        'status', 'event_type', 'created', 'modified',
    )

    search_fields = ('description', 'message')
    list_filter = ('status', 'event_type')
    readonly_fields = ('message', 'completion_date', 'created', 'modified')


@admin.register(AddAchievementEvent)
class AddAchievementEventAdmin(ActionEventAdmin):
    fields = (
        'user', 'course', 'achievement_id', 'level',
    ) + ActionEventAdmin.fields
    list_display = (
        'user', 'course', 'achievement_id', 'level',
    ) + ActionEventAdmin.list_display

    raw_id_fields = ('user', 'course')
    list_select_related = ('user', 'course')
    search_fields = (
        'user__username', 'user__id', 'user__yauid',
        'course__name', 'course__id', 'course__slug',
        'achievement_id',
    ) + ActionEventAdmin.search_fields

    readonly_fields = ActionEventAdmin.readonly_fields

    list_filter = (
        ('course', RelatedOnlyDropdownFilter),
        'level',
    ) + ActionEventAdmin.list_filter


@admin.register(CourseTrigger)
class CourseTriggerAdmin(admin.ModelAdmin):
    fields = (
        'name', 'description', 'course', 'trigger_type', 'action_type',
        'parameters', 'created', 'modified',
    )
    list_display = (
        'name', 'course', 'trigger_type', 'action_type', 'created', 'modified',
    )
    list_select_related = ('course',)

    search_fields = ('id', 'name', 'course__id', 'course__slug', 'course__name',)
    list_filter = ('trigger_type', 'action_type')
    readonly_fields = ('created', 'modified')
    raw_id_fields = ('course',)
